/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import jp.sourceforge.jindolf.HTMLUtils;
import jp.sourceforge.jindolf.Topic;

public class SysEvent
implements Topic {
    private EventClass eventClass;
    private String message;
    private Type type = Type.UNKNOWN;

    public static EventClass decodeEventClass(CharSequence eventClass) {
        EventClass result;
        if ("announce".contentEquals(eventClass)) {
            result = EventClass.ANNOUNCE;
        } else if ("order".contentEquals(eventClass)) {
            result = EventClass.ORDER;
        } else if ("extra".contentEquals(eventClass)) {
            result = EventClass.EXTRA;
        } else {
            assert (false);
            return null;
        }
        return result;
    }

    public static CharSequence encodeEventClass(EventClass eventClass) {
        String result;
        switch (eventClass) {
            case ANNOUNCE: {
                result = "announce";
                break;
            }
            case ORDER: {
                result = "order";
                break;
            }
            case EXTRA: {
                result = "extra";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return result;
    }

    public SysEvent(EventClass eventClass, String message) throws NullPointerException {
        if (eventClass == null || message == null) {
            throw new NullPointerException();
        }
        this.eventClass = eventClass;
        this.message = message = message.replace("<br />", "\n");
    }

    public String getMessage() {
        return this.message;
    }

    public CharSequence buildJdfHTML() {
        StringBuilder html = new StringBuilder();
        String talk = this.getMessage();
        talk = talk.replace("\n", "<br></br>");
        html.append((CharSequence)HTMLUtils.elemented("div", SysEvent.encodeEventClass(this.eventClass), talk));
        html.append("<br></br>");
        html.append("\n<!-- -->\n");
        return html;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STARTPROLOGUE,
        ONSTAGE,
        WINVILLAGE,
        WINWOLF,
        WINHAMSTER,
        GAMEOVER,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventClass {
        ANNOUNCE,
        ORDER,
        EXTRA;

    }
}

