/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Village;

public class VillageIconRenderer
extends DefaultTreeCellRenderer {
    private static final ImageIcon prologueIcon;
    private static final ImageIcon progressIcon;
    private static final ImageIcon epilogueIcon;
    private static final ImageIcon gameoverIcon;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (leaf && value instanceof Village) {
            Village village = (Village)value;
            switch (village.getState()) {
                case PROLOGUE: {
                    this.setLeafIcon(prologueIcon);
                    break;
                }
                case PROGRESS: {
                    this.setLeafIcon(progressIcon);
                    break;
                }
                case EPILOGUE: {
                    this.setLeafIcon(epilogueIcon);
                    break;
                }
                case GAMEOVER: {
                    this.setLeafIcon(gameoverIcon);
                }
            }
        }
        Component comp = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        return comp;
    }

    static {
        URL url = Jindolf.getResource("resources/prologue.png");
        prologueIcon = new ImageIcon(url);
        url = Jindolf.getResource("resources/progress.png");
        progressIcon = new ImageIcon(url);
        url = Jindolf.getResource("resources/epilogue.png");
        epilogueIcon = new ImageIcon(url);
        url = Jindolf.getResource("resources/gameover.png");
        gameoverIcon = new ImageIcon(url);
    }
}

