/*
 * Lands tree container
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: LandsTree.java 87 2008-07-10 17:12:36Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/**
 * 国一覧Tree周辺コンポーネント群
 */
@SuppressWarnings("serial")
public class LandsTree
        extends JPanel
        implements ActionListener{
    
    private static final String ascendingSymbol = "↑";
    private static final String descendingSymbol = "↓";

    private JButton orderButton = new JButton(ascendingSymbol);
    private JButton reloadButton = new JButton("村一覧get");
    private JTree treeView = new JTree();

    private boolean ascending = true;
    
    public LandsTree(){
        super();

        design();
        
        this.orderButton.setActionCommand(MenuManager.COMMAND_SWITCHORDER);
        this.orderButton.addActionListener(this);

        this.reloadButton.setActionCommand(MenuManager.COMMAND_VILLAGELIST);

        return;
    }

    /**
     * GUIパーツのデザインを行う。
     */
    private void design(){
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        setLayout(layout);
        
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = GridBagConstraints.WEST;
        constraints.fill = GridBagConstraints.NONE;
        add(orderButton, constraints);

        constraints.gridwidth = GridBagConstraints.REMAINDER;
        add(reloadButton, constraints);

        constraints.gridwidth = GridBagConstraints.REMAINDER;
        constraints.fill = GridBagConstraints.BOTH;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        add(createLandSelector(), constraints);
        
        return;
    }
    
    /**
     * 国村選択ツリーコンポーネントを生成する。
     * @return 国村選択ツリーコンポーネント
     */
    private JComponent createLandSelector(){
        this.treeView.setRootVisible(false);
        this.treeView.setCellRenderer(new VillageIconRenderer());
        
        EmptyBorder border = new EmptyBorder(5, 5, 5, 5);
        this.treeView.setBorder(border);

        JScrollPane landSelector = new JScrollPane(this.treeView);

        return landSelector;
    }

    /**
     * リロードボタンを返す。
     * @return リロードボタン
     */
    public JButton getReloadVillageListButton(){
        return this.reloadButton;
    }
    
    /**
     * 国村選択ツリービューを返す。
     * @return 国村選択ツリービュー
     */
    public JTree getTreeView(){
        return this.treeView;
    }

    /**
     * 管理下のLandsModelを返す。
     * @return LandsModel
     */
    private LandsModel getLandsModel(){
        TreeModel model = this.treeView.getModel();
        if(model instanceof LandsModel){
            return (LandsModel) model;
        }
        return null;
    }
    
    /**
     * Tree表示順を反転させる。
     * @return 反転後が昇順ならtrue
     */
    private boolean toggleTreeOrder(){
        this.ascending = ! this.ascending;

        if(this.ascending){
            this.orderButton.setText(ascendingSymbol);
        }else{
            this.orderButton.setText(descendingSymbol);
        }

        final TreePath lastPath = this.treeView.getSelectionPath();
        
        LandsModel model = getLandsModel();
        if(model != null){
            model.setAscending(this.ascending);
        }
        
        SwingUtilities.invokeLater(new Runnable(){
            public void run(){
                if(lastPath != null){
                    treeView.setSelectionPath(lastPath);
                    treeView.scrollPathToVisible(lastPath);
                }
                return;
            }
        });
        
        return this.ascending;
    }
    
    /**
     * ボタン押下処理
     * @param event ボタン押下イベント
     */
    public void actionPerformed(ActionEvent event){
        String cmd = event.getActionCommand();
        if(MenuManager.COMMAND_SWITCHORDER.equals(cmd)){
            toggleTreeOrder();
        }
        return;
    }
    
    /**
     * L&F を変更する。
     */
    @Override
    public void updateUI(){
        super.updateUI();
        if(this.treeView != null){
            this.treeView.setCellRenderer(new VillageIconRenderer());
        }
        return;
    }
}
