/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.swing.text.StyleContext;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.StyleSheet;
import jp.sourceforge.jindolf.JdfViewFactory;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.UnshareStyleEditorKit;
import jp.sourceforge.jindolf.Village;

public class JdfEditorKit
extends UnshareStyleEditorKit {
    private static final String cssSrc = "resources/jindolf.css";
    private static final String cssContent;
    private ViewFactory defaultFactory;

    public JdfEditorKit(Village village) {
        this.defaultFactory = new JdfViewFactory(village);
        StyleSheet originalStyle = new StyleSheet();
        StringReader reader = new StringReader(cssContent);
        try {
            originalStyle.loadRules(reader, null);
            ((Reader)reader).close();
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "CSS\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093", e);
        }
        this.setStyleSheet(originalStyle);
    }

    public ViewFactory getViewFactory() {
        return this.defaultFactory;
    }

    public void dumpStyleSheet(PrintStream out) {
        StyleSheet sheet = this.getStyleSheet();
        Enumeration<?> styleNames = sheet.getStyleNames();
        while (styleNames.hasMoreElements()) {
            String stylename = (String)styleNames.nextElement();
            out.println("stylename=" + stylename);
            StyleContext.NamedStyle style = (StyleContext.NamedStyle)sheet.getStyle(stylename);
            String styleName = style.getName();
            out.println("rulename=" + styleName);
            Enumeration<?> attrs = style.getAttributeNames();
            while (attrs.hasMoreElements()) {
                Object key = attrs.nextElement();
                Object value = style.getAttribute(key);
                out.println("key=" + key + "   value=" + value);
            }
        }
    }

    static {
        InputStream is = Jindolf.getResourceAsStream(cssSrc);
        Reader reader = new InputStreamReader(is);
        reader = new BufferedReader(reader);
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[256];
        try {
            int chs;
            while ((chs = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, chs);
            }
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "CSS\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093", e);
            sb.delete(0, sb.length());
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "CSS\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u307f\u3067\u7570\u5e38\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
        cssContent = sb.toString();
    }
}

