/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.text.DateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.HTMLUtils;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;

public class Talk
implements Topic {
    private static final DateFormat dform = DateFormat.getDateTimeInstance(2, 2);
    private static final Pattern anchorRegex;
    private final Period homePeriod;
    private final Type talkType;
    private final Avatar avatar;
    private final String messageID;
    private final int hour;
    private final int minute;
    private final String dialog;
    private final int charNum;
    private int count = -1;

    public Talk(Period homePeriod, Type talkType, Avatar avatar, String messageID, int hour, int minute, String dialog) {
        if (homePeriod == null || talkType == null || avatar == null || messageID == null || dialog == null) {
            throw new NullPointerException();
        }
        if (hour < 0 || 23 < hour) {
            throw new IllegalArgumentException();
        }
        if (minute < 0 || 59 < minute) {
            throw new IllegalArgumentException();
        }
        this.homePeriod = homePeriod;
        this.talkType = talkType;
        this.avatar = avatar;
        this.messageID = messageID;
        this.hour = hour;
        this.minute = minute;
        this.dialog = dialog.replace("<br />", "\n");
        this.charNum = this.dialog.length();
    }

    public Type getTalkType() {
        return this.talkType;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public String getMessageID() {
        return this.messageID;
    }

    private long getTimeFromID() {
        String epoch = this.messageID.replace("mes", "");
        long result = Long.parseLong(epoch) * 1000L;
        return result;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public String getDialog() {
        return this.dialog.replace("\n", "<br></br>");
    }

    public void setCount(int count) {
        this.count = count;
    }

    private String getAnchor() {
        int day = this.homePeriod.getDay();
        String hstr = "0" + this.hour;
        hstr = hstr.substring(hstr.length() - 2);
        String mstr = "0" + this.minute;
        mstr = mstr.substring(mstr.length() - 2);
        return String.valueOf(day) + "d" + hstr + ":" + mstr;
    }

    public String getTime() {
        StringBuilder result = new StringBuilder();
        if (this.hour <= 11) {
            result.append("\u5348\u524d&nbsp;").append(this.hour);
        } else {
            result.append("\u5348\u5f8c&nbsp;").append(this.hour - 12);
        }
        result.append("\u6642&nbsp;").append(this.minute).append("\u5206");
        return result.toString();
    }

    public static Type decodeType(String encoded) {
        Type type;
        if (encoded.equals("say")) {
            type = Type.PUBLIC;
        } else if (encoded.equals("think")) {
            type = Type.PRIVATE;
        } else if (encoded.equals("whisper")) {
            type = Type.WOLFONLY;
        } else if (encoded.equals("groan")) {
            type = Type.GRAVE;
        } else {
            return null;
        }
        return type;
    }

    public static Type decodeIntlType(String encoded) {
        Type type;
        if (encoded.equals("public")) {
            type = Type.PUBLIC;
        } else if (encoded.equals("private")) {
            type = Type.PRIVATE;
        } else if (encoded.equals("wolfonly")) {
            type = Type.WOLFONLY;
        } else if (encoded.equals("grave")) {
            type = Type.GRAVE;
        } else {
            return null;
        }
        return type;
    }

    public static String encodeIntlType(Type type) {
        String result;
        switch (type) {
            case PUBLIC: {
                result = "public";
                break;
            }
            case PRIVATE: {
                result = "private";
                break;
            }
            case WOLFONLY: {
                result = "wolfonly";
                break;
            }
            case GRAVE: {
                result = "grave";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return result;
    }

    public static String encodeColorName(Type type) {
        String result;
        switch (type) {
            case PUBLIC: {
                result = "\u767d";
                break;
            }
            case PRIVATE: {
                result = "\u7070";
                break;
            }
            case WOLFONLY: {
                result = "\u8d64";
                break;
            }
            case GRAVE: {
                result = "\u9752";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return result;
    }

    private CharSequence buildJdfHTMLDiv() {
        StringBuilder div = new StringBuilder();
        String mesClass = Talk.encodeIntlType(this.getTalkType());
        String content = this.getDialog();
        Matcher matcher = anchorRegex.matcher(content);
        StringBuffer newContent = new StringBuffer();
        while (matcher.find()) {
            String anchor = matcher.group();
            String dd = "";
            if (matcher.start(1) < matcher.end(1)) {
                if (matcher.start(2) < matcher.end(2)) {
                    dd = "0";
                } else if (matcher.start(3) < matcher.end(3)) {
                    Village village = this.homePeriod.getVillage();
                    Period epilogue = village.getEpilogue();
                    dd = epilogue != null ? Integer.toString(epilogue.getDay()) : "99";
                } else if (matcher.start(4) < matcher.end(4)) {
                    String ddsubs = matcher.group(4);
                    int ddint = Integer.parseInt(ddsubs);
                    dd = Integer.toString(ddint);
                } else assert (false);
            } else {
                dd = Integer.toString(this.homePeriod.getDay());
            }
            boolean isPM = false;
            if (matcher.start(5) < matcher.end(5)) {
                if (matcher.start(6) < matcher.end(6)) {
                    isPM = false;
                } else if (matcher.start(7) < matcher.end(7)) {
                    isPM = true;
                } else assert (false);
            } else {
                isPM = false;
            }
            String hh = "";
            String mm = "";
            String hhsubs = "";
            String mmsubs = "";
            if (matcher.start(8) < matcher.end(8)) {
                hhsubs = matcher.group(9);
                mmsubs = matcher.group(10);
            } else if (matcher.start(11) < matcher.end(11)) {
                hhsubs = matcher.group(12);
                mmsubs = matcher.group(13);
            } else assert (false);
            int hhint = Integer.parseInt(hhsubs);
            int mmint = Integer.parseInt(mmsubs);
            if (isPM) {
                hhint = (hhint + 12) % 24;
            }
            hh = Integer.toString(hhint);
            mm = Integer.toString(mmint);
            StringBuilder href = new StringBuilder();
            href.append(dd).append("d");
            href.append(hh).append(":");
            href.append(mm);
            anchor = "<a href=\"" + href + "\">" + anchor + "</a>";
            matcher.appendReplacement(newContent, anchor);
        }
        matcher.appendTail(newContent);
        div.append("<div class=\"");
        div.append(mesClass);
        div.append("\">");
        div.append(newContent);
        div.append("</div>");
        return div;
    }

    private CharSequence buildTimeSpans() {
        StringBuilder result = new StringBuilder(" ");
        String simple = this.getTime();
        String anchor = this.getAnchor();
        long epoch = this.getTimeFromID();
        String decoded = dform.format(epoch);
        result.append((CharSequence)HTMLUtils.elemented("span", "time", simple)).append(" ");
        result.append((CharSequence)HTMLUtils.elemented("span", "time", anchor)).append(" <br></br>");
        result.append((CharSequence)HTMLUtils.elemented("span", "time", decoded)).append(" ");
        if (this.count > 0) {
            String talkCount = "(" + Talk.encodeColorName(this.getTalkType()) + "#" + this.count + ")";
            result.append((CharSequence)HTMLUtils.elemented("span", "time", talkCount)).append(" ");
        }
        if (this.charNum > 0) {
            String charCount = "" + this.charNum + "\u5b57";
            result.append((CharSequence)HTMLUtils.elemented("span", "time", charCount)).append(" ");
        }
        return result;
    }

    public CharSequence buildJdfHTML() {
        StringBuilder html = new StringBuilder();
        StringBuilder aElem = HTMLUtils.elemented("a", "name", this.getMessageID(), this.avatar.getFullName());
        CharSequence timeInfo = this.buildTimeSpans();
        CharSequence imgElem = this.getTalkType() == Type.GRAVE ? HTMLUtils.elemented("img", "avatar", "", "") : this.avatar.buildJdfHTMLImg();
        imgElem = HTMLUtils.elemented("td", imgElem);
        CharSequence content = this.buildJdfHTMLDiv();
        content = HTMLUtils.elemented("td", content);
        StringBuilder table = new StringBuilder();
        table = table.append(imgElem).append(content);
        table = HTMLUtils.elemented("tr", table);
        table = HTMLUtils.elemented("table", table);
        StringBuilder msgDiv = new StringBuilder();
        msgDiv.append("<div class=\"message\"");
        msgDiv.append(" avatar=\"").append(this.getAvatar().getFullName()).append("\"");
        msgDiv.append(" talktype=\"").append(Talk.encodeIntlType(this.getTalkType())).append("\"");
        msgDiv.append(">");
        msgDiv.append((CharSequence)aElem).append(timeInfo).append((CharSequence)table);
        msgDiv.append("</div>");
        html.append((CharSequence)msgDiv).append("\n<!-- -->\n");
        return html;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.avatar.getFullName());
        if (this.talkType == Type.PUBLIC) {
            result.append(" says ");
        } else if (this.talkType == Type.PRIVATE) {
            result.append(" think ");
        } else if (this.talkType == Type.WOLFONLY) {
            result.append(" howl ");
        } else if (this.talkType == Type.GRAVE) {
            result.append(" groan ");
        }
        result.append(this.dialog);
        return result.toString();
    }

    static {
        String Spchar = " \u3000\\t";
        String Sp = "[" + Spchar + "]";
        String Sp_n = "(?:" + Sp + "|" + "(?:\\Q&nbsp;\\E)" + ")*?";
        String day = "((?:(\u30d7\u30ed(?:\u30ed\u30fc\u30b0)?)|(\u30a8\u30d4(?:\u30ed\u30fc\u30b0)?)|(?:([1-9\uff11-\uff19]?[0-9\uff10-\uff19])" + Sp_n + "(?:[dD\uff44\uff24]|(?:\u65e5\u76ee?))" + ")" + ")" + Sp_n + ")?";
        String ampm = "((?:((?:[aA\uff41\uff21][\\.\uff0e]?[mM\uff4d\uff2d][\\.\uff0e]?)|(?:\u5348\u524d))|((?:[pP\uff50\uff30][\\.\uff0e]?[mM\uff4d\uff2d][\\.\uff0e]?)|(?:\u5348\u5f8c)))" + Sp_n + ")?";
        String hhmm = "(?:(([0-2\uff10-\uff12]?[0-9\uff10-\uff19])" + Sp_n + "[:;\uff1a\uff1b]?" + Sp_n + "([0-5\uff10-\uff15][0-9\uff10-\uff19])" + ")" + "|" + "(" + "([0-2\uff10-\uff12]?[0-9\uff10-\uff19])" + Sp_n + "\u6642" + Sp_n + "([0-5\uff10-\uff15]?[0-9\uff10-\uff19])" + Sp_n + "\u5206" + ")" + ")";
        anchorRegex = Pattern.compile(day + ampm + hhmm, 32);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PUBLIC,
        WOLFONLY,
        PRIVATE,
        GRAVE;

    }
}

