/*
 * anchor link listener
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: AnchorListener.java 42 2008-06-25 12:35:34Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkEvent.EventType;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

/**
 * 発言アンカーのクリック処理
 */
// TODO ***Listener なクラス名は変かも。
// TODO 検索ハイライトと連動しないバグが存在。は消えた？
public class AnchorListener implements HyperlinkListener{
    private Village village;
    private Map<Element, Element> anchorMap = new HashMap<Element, Element>();

    /**
     * 村指定と共に生成。
     * @param village 村
     */
    public AnchorListener(Village village){
        super();
        this.village = village;
        return;
    }

    /**
     * 元の発言直後に差し込むためのHTML文字列を生成する。
     * @param href AタグのHREF属性値
     * @return HTML文字列
     */
    private String buildAnchorDiv(String href) throws IOException{
        StringBuilder content = new StringBuilder();

        Pattern anchorRegex =
                Pattern.compile("([0-9]?[0-9])d([0-2]?[0-9]):([0-5]?[0-9])");
        Matcher matcher = anchorRegex.matcher(href);
        if( ! matcher.matches() ) content.append("[見つかりません]");

        String dayStr = matcher.group(1);
        String hourStr = matcher.group(2);
        String minuteStr = matcher.group(3);

        int day = Integer.parseInt(dayStr);
        int hour = Integer.parseInt(hourStr);
        int minute = Integer.parseInt(minuteStr);

        Period period = village.getPeriod(day); // TODO null check
        period.updatePeriod();
        for(Topic topic : period.getTopicList()){
            Talk talk;
            if(topic instanceof Talk) talk = (Talk) topic;
            else continue;

            if(talk.getHour() != hour) continue;
            if(talk.getMinute() != minute) continue;
            
            Avatar avatar = talk.getAvatar();
            if(village.getAvatarFaceImage(avatar) == null){
                Period prologue = village.getPrologue();
                prologue.updatePeriod();
                if(village.getAvatarFaceImage(avatar) == null){
                    assert false;
                }
            }
            
            String fullName = avatar.getFullName();
            
            content.append("<img avatar=\"")
                   .append(fullName)
                   .append("\"></img>");
            content.append(fullName).append(" ");
            content.append(talk.getTime()).append("<br>");
            content.append(talk.getDialog()).append("<br>");
        }

        // TODO [JRE1.6 for Win] has BUG.
        String start =
                "<div "
                +"style=\"margin-left: 32px; "
                +"font-size: 18px; "
                +"color: #ffff99;\" "
                +"class=\"anchorDiv\" origin=\""
                + href
                + "\">";
        String close = "</div>";

        return start + content + close;
    }

    /**
     * 発言アンカーがクリックされたときリスナー経由で呼ばれる。
     * @param event イベント
     */
    public void hyperlinkUpdate(HyperlinkEvent event){
        EventType eType = event.getEventType();
        if(eType != EventType.ACTIVATED){
            return;
        }

        Element sourceElem = event.getSourceElement();
        if(sourceElem == null){
            return;
        }
        AttributeSet attrSrc = sourceElem.getAttributes();
        if(attrSrc == null){
            return;
        }
        AttributeSet attrAnchor =
                (AttributeSet) (attrSrc.getAttribute(HTML.Tag.A));
        if(attrAnchor == null){
            return;
        }
        String href = (String) (attrAnchor.getAttribute(HTML.Attribute.HREF));
        if(href == null){
            return;
        }

        Element prevElem = sourceElem;
        for(;;){
            String name = prevElem.getName();
            if(name.equalsIgnoreCase("table")){
                break;
            }
            prevElem = prevElem.getParentElement();
            if(prevElem == null){
                return;
            }
        }

        HTMLDocument doc = (HTMLDocument) (sourceElem.getDocument());
        Element anchorDiv = anchorMap.get(prevElem);

        String origin = null;
        if(anchorDiv != null){
            AttributeSet attrAnchorDiv = anchorDiv.getAttributes();
            origin = (String) (attrAnchorDiv.getAttribute("origin"));

            int start = anchorDiv.getStartOffset();
            int end = anchorDiv.getEndOffset();
            int length = end - start;
            try{
                doc.remove(start, length);
            }catch(BadLocationException e){
                //IGNORE
            }
            anchorMap.remove(prevElem);
        }

        if(href.equals(origin)){
            return;
        }

        String newDiv;
        try{
            newDiv = buildAnchorDiv(href);
        }catch(IOException e){
            Jindolf.logger.log(Level.WARNING,
                               "アンカー先の発言の読み込みに失敗しました",
                               e);
            return;
        }
        
        try{
            doc.insertAfterEnd(prevElem, newDiv);
        }catch(IOException e){
            //IGNORE
        }catch(BadLocationException e){
            //IGNORE
        }
        int prevEnd = prevElem.getEndOffset();
        anchorDiv = doc.getParagraphElement(prevEnd);
        anchorMap.put(prevElem, anchorDiv);

        return;
    }
}
