/*
 * browser scroller 
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: JdfScroller.java 71 2008-07-03 15:32:09Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EmptyBorder;

/**
 * 内部ブラウザを内包するスクロールペイン。
 */
@SuppressWarnings("serial")
public class JdfScroller extends JScrollPane{

    private final JdfBrowser browser;
    
    /**
     * 内部ブラウザを内包するスクロールペインを生成する。
     * @param period 日
     */
    public JdfScroller(Period period){
        super();
        
        this.browser = new JdfBrowser(period);
        this.browser.setBorder(new EmptyBorder(0, 0, 0, 0));
 
        setViewportView(this.browser);
        setHorizontalScrollBarPolicy(
                ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        
        return;
    }
    
    /**
     * ビューポート内の内部ブラウザを返す。
     * @return 内部ブラウザ
     */
    public JdfBrowser getJdfBrowser(){
        return this.browser;
    }
    
    /**
     * スクロール位置を返す。
     * @return スクロール位置
     */
    public int getVerticalPosition(){
        JScrollBar vt = getVerticalScrollBar();
        int pos = vt.getValue();
        return pos;
    }
    
    /**
     * スクロール位置を設定する。
     * @param pos スクロール位置
     */
    public void setVerticalPosition(int pos){
        JScrollBar vt = getVerticalScrollBar();
        vt.setValue(pos);
        return;
    }
}
