/*
 * system event view
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: SysEventView.java 50 2008-06-27 16:46:43Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.StyleSheet;

/**
 * JdfViewFactory用のSysEvent描画用ビュー
 */
public class SysEventView extends TopicView{

    private static Color COLOR_TRANS = new Color(0, 0, 0, 0);

    private SysEvent.EventClass eventClass;

    /**
     * ボーダービューを生成する。
     * SysEvent用
     * @param elem HTML要素
     * @param eventClass 発言種別
     */
    public SysEventView(Element elem, SysEvent.EventClass eventClass){
        super(elem);
        this.eventClass = eventClass;
        return;
    }

    /**
     * ボーダー枠を描画。
     * @param g2 グラフィックコンテキスト
     * @param bounds 描画領域
     */
    // TODO マージンとパディングを反映させるべき。
    private void drawBorder(Graphics2D g2, Rectangle bounds){
        StyleSheet styleSheet = getStyleSheet();
        AttributeSet vattr = styleSheet.getViewAttributes(this);
        Color fgColor = styleSheet.getForeground(vattr);
        g2.setColor(fgColor);
        g2.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        return;
    }
    
    /**
     * Topicビューを描画
     * @param g グラフィックコンテキスト
     * @param allocation 描画領域
     */
    @Override
    public void paint(Graphics g, Shape allocation){
        Graphics2D g2 = (Graphics2D) g;
        g2.addRenderingHints(GUIUtils.getDefaultHints());

        Rectangle bounds = allocation.getBounds();
        g2.setColor(COLOR_TRANS);
        g2.fill(bounds);

        // ignore BoxPainter !
        drawBorder(g2, bounds);
        drawContent(g2, bounds);
        
        return;
    }
}
