/*
 * topic view
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: TopicView.java 26 2008-06-20 12:51:53Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.BlockView;

/**
 * JdfViewFactory用のTopic描画用ビュー
 */
public class TopicView extends BlockView{

    private boolean isVisible;

    /**
     * Topicビューを生成する。
     * Talk用
     * @param elem HTML要素
     */
    public TopicView(Element elem){
        super(elem, View.Y_AXIS);
        this.isVisible = true;
        return;
    }

    /**
     * このViewが可視か否か設定する。
     * @param visible 可視ならtrue
     */
    public void setVisible(boolean visible){
        this.isVisible = visible;
        return;
    }

    /**
     * このViewが可視か否か判定する。
     * @return 可視ならtrue
     */
    @Override
    public boolean isVisible(){
        return this.isVisible;
    }

    /**
     * ビューの最大寸法を返す。
     * ビューが不可視なら0.0fを返す。
     * @param axis 方向
     * @return 寸法
     */
    @Override
    public float getMaximumSpan(int axis){
        if(isVisible()) return super.getMaximumSpan(axis);
        return 0.0f;
    }

    /**
     * ビューの望ましい寸法を返す。
     * ビューが不可視なら0.0fを返す。
     * @param axis 方向
     * @return 寸法
     */
    @Override
    public float getPreferredSpan(int axis){
        if(isVisible()) return super.getPreferredSpan(axis);
        return 0.0f;
    }

    /**
     * ビューの最小寸法を返す。
     * ビューが不可視なら0.0fを返す。
     * @param axis 方向
     * @return 寸法
     */
    @Override
    public float getMinimumSpan(int axis){
        if(isVisible()) return super.getMinimumSpan(axis);
        return 0.0f;
    }

    /**
     * 子ビューを描画
     * @param g2 グラフィックコンテキスト
     * @param bounds 描画領域
     */
    protected void drawContent(Graphics2D g2, Rectangle bounds){
        int ix = bounds.x + getLeftInset();
        int iy = bounds.y + getTopInset();
        Rectangle clip = g2.getClipBounds();
        Rectangle allocChild = new Rectangle();
        int viewMax = getViewCount();
        for(int viewNo = 0; viewNo < viewMax; viewNo++){
            allocChild.setBounds(ix + getOffset(X_AXIS, viewNo),
                                 iy + getOffset(Y_AXIS, viewNo),
                                 getSpan(X_AXIS, viewNo),
                                 getSpan(Y_AXIS, viewNo));
            if(!allocChild.intersects(clip)){
                continue;
            }
            paintChild(g2, allocChild, viewNo);
        }
        return;
    }

    /**
     * 自分自身と子ビューを描画する。
     * このビューが不可視なら何もしない。
     * @param g グラフィックコンテキスト
     * @param allocation 描画領域
     */
    @Override
    public void paint(Graphics g, Shape allocation){
        if(isVisible()) super.paint(g, allocation);
        return;
    }
}
