/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.RowsLtoR;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Village;

public class AnchorDraw
implements RowsLtoR {
    private static final Color COLOR_ANCHOR = new Color(0xFFFF99);
    private static final int UNDER_MARGIN = 5;
    private final Talk talk;
    private final GlyphDraw caption;
    private final GlyphDraw dialog;
    private final Image faceImage;
    private final Point imageOrigin = new Point();
    private final Point captionOrigin = new Point();
    private final Point dialogOrigin = new Point();
    private final Rectangle bounds = new Rectangle();
    private Font font;
    private FontRenderContext frc;

    public AnchorDraw(Talk talk, Font font, FontRenderContext frc) {
        this.talk = talk;
        this.font = font;
        this.frc = frc;
        Period period = this.talk.getPeriod();
        Village village = period.getVillage();
        Avatar avatar = this.talk.getAvatar();
        Image image = this.talk.getTalkType() == Talk.Type.GRAVE ? village.getGraveImage() : village.getAvatarFaceImage(avatar);
        this.faceImage = image;
        this.caption = new GlyphDraw(this.font, this.frc, this.getCaptionString());
        this.dialog = new GlyphDraw(this.font, this.frc, this.talk.getDialog());
        this.caption.setColor(COLOR_ANCHOR);
        this.dialog.setColor(COLOR_ANCHOR);
    }

    private CharSequence getCaptionString() {
        StringBuilder result = new StringBuilder();
        Avatar avatar = this.talk.getAvatar();
        result.append(avatar.getFullName()).append(' ').append(this.talk.getAnchorNotation());
        return result;
    }

    public Rectangle setWidth(int newWidth) {
        int captionYpos;
        int imageYpos;
        int imageWidth = this.faceImage.getWidth(null);
        int imageHeight = this.faceImage.getHeight(null);
        Rectangle captionRect = this.caption.setWidth(newWidth - imageWidth);
        int captionWidth = captionRect.width;
        int captionHeight = captionRect.height;
        Rectangle dialogRect = this.dialog.setWidth(newWidth);
        int dialogWidth = dialogRect.width;
        int dialogHeight = dialogRect.height;
        int headerHeight = Math.max(imageHeight, captionHeight);
        int totalWidth = Math.max(imageWidth + captionWidth, dialogWidth);
        int totalHeight = headerHeight;
        totalHeight += dialogHeight;
        if (imageHeight > captionHeight) {
            imageYpos = 0;
            captionYpos = (imageHeight - captionHeight) / 2;
        } else {
            imageYpos = (captionHeight - imageHeight) / 2;
            captionYpos = 0;
        }
        this.imageOrigin.setLocation(0, imageYpos);
        this.captionOrigin.setLocation(imageWidth, captionYpos);
        this.dialogOrigin.setLocation(0, headerHeight);
        this.bounds.width = totalWidth;
        this.bounds.height = totalHeight + 5;
        return this.bounds;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setPos(int xPos, int yPos) {
        this.bounds.x = xPos;
        this.bounds.y = yPos;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public void setFontInfo(Font font, FontRenderContext frc) {
        this.font = font;
        this.frc = frc;
        this.caption.setFontInfo(this.font, this.frc);
        this.dialog.setFontInfo(this.font, this.frc);
        int width = this.getWidth();
        this.setWidth(width);
    }

    public void drag(Point from, Point to) {
        this.caption.drag(from, to);
        this.dialog.drag(from, to);
    }

    public Appendable appendSelected(Appendable appendable) throws IOException {
        this.caption.appendSelected(appendable);
        this.dialog.appendSelected(appendable);
        return appendable;
    }

    public void clearSelect() {
        this.caption.clearSelect();
        this.dialog.clearSelect();
    }

    public int setRegex(Pattern searchRegex) {
        int total = 0;
        return total += this.dialog.setRegex(searchRegex);
    }

    public void paint(Graphics2D g) {
        int xPos = this.bounds.x;
        int yPos = this.bounds.y;
        g.drawImage(this.faceImage, xPos + this.imageOrigin.x, yPos + this.imageOrigin.y, null);
        this.caption.setPos(xPos + this.captionOrigin.x, yPos + this.captionOrigin.y);
        this.caption.paint(g);
        this.dialog.setPos(xPos + this.dialogOrigin.x, yPos + this.dialogOrigin.y);
        this.dialog.paint(g);
    }
}

