/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.event.MouseInputListener;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.RowsLtoR;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.SysEventDraw;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.TalkDraw;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.TopicFilter;
import jp.sourceforge.jindolf.Village;

public class Discussion
extends JComponent
implements Scrollable,
MouseInputListener {
    private static final Insets insets = new Insets(15, 15, 15, 15);
    private static final int horizontalGap = Discussion.insets.left + Discussion.insets.right;
    private static final int verticalGap = Discussion.insets.top + Discussion.insets.bottom;
    private static final Font font = new Font("Dialog", 0, 20);
    private static final boolean antiAliaseText;
    private static final boolean useFractional;
    private static final FontRenderContext frc;
    private static final RenderingHints hints;
    private Period period;
    private TopicFilter topicFilter = null;
    private TopicFilter.FilterContext filterContext;
    private Pattern searchRegex = null;
    private final List<RowsLtoR> rowList = new LinkedList<RowsLtoR>();
    private Dimension idealSize;
    private int lastWidth = -1;
    private Point dragFrom;
    private DiscussionPopup popup = new DiscussionPopup();
    private Action copySelectedAction = new AbstractAction(){

        public void actionPerformed(ActionEvent event) {
            Discussion.this.copySelected();
        }
    };

    public Discussion(Period period) {
        this.setPeriod(period);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setComponentPopupMenu(this.popup);
        this.updateInputMap();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", this.copySelectedAction);
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        if (period == null) {
            this.period = null;
            this.rowList.clear();
            return;
        }
        if (this.period == period && period.getTopics() == this.rowList.size()) {
            return;
        }
        this.period = period;
        this.filterContext = null;
        this.rowList.clear();
        for (Topic topic : this.period.getTopicList()) {
            RowsLtoR row;
            if (topic instanceof Talk) {
                Talk talk = (Talk)topic;
                row = new TalkDraw(talk, font, frc);
            } else if (topic instanceof SysEvent) {
                SysEvent sysEvent = (SysEvent)topic;
                row = new SysEventDraw(sysEvent, font, frc);
            } else {
                assert (false);
                continue;
            }
            this.rowList.add(row);
        }
        this.clearSizeCache();
        int width = this.getWidth();
        this.calcIdealSize(width);
        this.repaint();
        this.revalidate();
    }

    public Insets getInsets() {
        return insets;
    }

    public void showTopics(boolean force) {
        this.setPeriod(this.getPeriod());
    }

    public void setTopicFilter(TopicFilter filter) {
        this.topicFilter = filter;
        this.filtering();
    }

    public void filtering() {
        if (this.topicFilter != null && this.topicFilter.isSame(this.filterContext)) {
            return;
        }
        this.filterContext = this.topicFilter != null ? this.topicFilter.getFilterContext() : null;
        int width = this.getWidth();
        this.calcIdealSizeIntl(width);
        this.repaint();
        this.revalidate();
    }

    public void setSearchRegex(Pattern searchRegex) {
        if (this.searchRegex == searchRegex) {
            return;
        }
        this.searchRegex = searchRegex;
    }

    public int highlightRegex() {
        int total = 0;
        for (RowsLtoR row : this.rowList) {
            if (!(row instanceof TalkDraw)) continue;
            TalkDraw talkDraw = (TalkDraw)row;
            total += talkDraw.setRegex(this.searchRegex);
        }
        this.repaint();
        return total;
    }

    private void clearSizeCache() {
        this.idealSize = null;
        this.lastWidth = -1;
        this.revalidate();
    }

    private boolean isFiltered(RowsLtoR row) {
        Topic topic;
        if (this.topicFilter == null) {
            return false;
        }
        if (row instanceof TalkDraw) {
            topic = ((TalkDraw)row).getTalk();
        } else if (row instanceof SysEventDraw) {
            topic = ((SysEventDraw)row).getSysEvent();
        } else {
            return false;
        }
        return this.topicFilter.isFiltered(topic);
    }

    private Rectangle calcRect(int xPos, int yPos, int widthLimit) {
        int innerLimit = widthLimit - horizontalGap;
        Rectangle unionRect = null;
        for (RowsLtoR row : this.rowList) {
            if (this.isFiltered(row)) continue;
            row.setPos(xPos, yPos);
            Rectangle rowBound = row.setWidth(innerLimit);
            yPos += rowBound.height;
            if (unionRect == null) {
                unionRect = new Rectangle(rowBound);
                continue;
            }
            unionRect.add(rowBound);
        }
        return unionRect;
    }

    private void calcIdealSize(int newWidth) {
        if (newWidth == this.lastWidth) {
            return;
        }
        this.calcIdealSizeIntl(newWidth);
    }

    private void calcIdealSizeIntl(int newWidth) {
        this.lastWidth = newWidth;
        Rectangle unionRect = this.calcRect(Discussion.insets.left, Discussion.insets.top, newWidth);
        if (this.idealSize == null) {
            this.idealSize = new Dimension();
        }
        int newHeight = verticalGap;
        if (unionRect != null) {
            newHeight += unionRect.height;
        }
        this.idealSize.width = newWidth;
        this.idealSize.height = newHeight;
        this.setPreferredSize(this.idealSize);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(hints);
        g2.setColor(Color.BLACK);
        Rectangle clipRect = g.getClipBounds();
        g2.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        for (RowsLtoR row : this.rowList) {
            Rectangle rowRect = row.getBounds();
            if (!rowRect.intersects(clipRect) || this.isFiltered(row)) continue;
            row.paint(g2);
        }
    }

    public void setSize(Dimension size) {
        this.setBounds(this.getX(), this.getY(), size.width, size.height);
    }

    public void setSize(int width, int height) {
        this.setBounds(this.getX(), this.getY(), width, height);
    }

    @Deprecated
    public void resize(Dimension size) {
        this.setBounds(this.getX(), this.getY(), size.width, size.height);
    }

    @Deprecated
    public void resize(int width, int height) {
        this.setBounds(this.getX(), this.getY(), width, height);
    }

    public void setBounds(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        int oldWidth = this.getWidth();
        super.setBounds(x, y, width, height);
        if (oldWidth == width) {
            return;
        }
        this.calcIdealSize(width);
        if (this.idealSize.width != width || this.idealSize.height != height) {
            this.revalidate();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        return 30;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 30;
    }

    private void drag(Point from, Point to) {
        Rectangle dragRegion = new Rectangle();
        dragRegion.setFrameFromDiagonal(from, to);
        for (RowsLtoR row : this.rowList) {
            if (!row.getBounds().intersects(dragRegion)) continue;
            row.drag(from, to);
        }
        this.repaint();
    }

    private void clearSelect() {
        for (RowsLtoR row : this.rowList) {
            row.clearSelect();
        }
        this.repaint();
    }

    private RowsLtoR hitCheck(Point pt) {
        for (RowsLtoR row : this.rowList) {
            Rectangle bounds = row.getBounds();
            if (!bounds.contains(pt)) continue;
            return row;
        }
        return null;
    }

    private void hitAnchor(Point pt) {
        List<Talk> talkList;
        if (this.period == null) {
            return;
        }
        RowsLtoR row = this.hitCheck(pt);
        if (row == null) {
            return;
        }
        if (!(row instanceof TalkDraw)) {
            return;
        }
        TalkDraw chat = (TalkDraw)row;
        Anchor anchor = chat.getAnchor(pt);
        if (anchor == null) {
            return;
        }
        Village village = this.period.getVillage();
        try {
            talkList = village.getTalkListFromAnchor(anchor);
        }
        catch (IOException e) {
            return;
        }
        if (talkList.size() <= 0) {
            return;
        }
        chat.showAnchorTalks(anchor, talkList);
        int width = this.getWidth();
        this.calcIdealSizeIntl(width);
        this.repaint();
        this.revalidate();
    }

    public void mouseClicked(MouseEvent ev) {
        Point pt = ev.getPoint();
        if (ev.getButton() == 1) {
            this.clearSelect();
            this.hitAnchor(pt);
        }
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mousePressed(MouseEvent ev) {
        this.requestFocusInWindow();
        if (ev.getButton() == 1) {
            this.clearSelect();
            this.dragFrom = ev.getPoint();
        }
    }

    public void mouseReleased(MouseEvent ev) {
        if (ev.getButton() == 1) {
            this.dragFrom = null;
        }
    }

    public void mouseDragged(MouseEvent ev) {
        if (this.dragFrom == null) {
            return;
        }
        Point dragTo = ev.getPoint();
        this.drag(this.dragFrom, dragTo);
    }

    public void mouseMoved(MouseEvent ev) {
    }

    public CharSequence getSelected() {
        StringBuilder selected = new StringBuilder();
        for (RowsLtoR row : this.rowList) {
            try {
                row.appendSelected(selected);
            }
            catch (IOException e) {
                assert (false);
                return null;
            }
        }
        if (selected.length() <= 0) {
            return null;
        }
        return selected;
    }

    private void copyToClipBoard(CharSequence data) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        StringSelection selection = new StringSelection(((Object)data).toString());
        clipboard.setContents(selection, selection);
    }

    public CharSequence copySelected() {
        CharSequence selected = this.getSelected();
        if (selected == null) {
            return null;
        }
        this.copyToClipBoard(selected);
        return selected;
    }

    public CharSequence copyTalk(RowsLtoR row) {
        if (row == null) {
            return null;
        }
        if (!(row instanceof TalkDraw)) {
            return null;
        }
        TalkDraw talkDraw = (TalkDraw)row;
        Talk talk = talkDraw.getTalk();
        StringBuilder selected = new StringBuilder();
        Avatar avatar = talk.getAvatar();
        selected.append(avatar.getName()).append(' ');
        String anchor = talk.getAnchorNotation();
        selected.append(anchor).append('\n');
        selected.append(talk.getDialog());
        if (selected.charAt(selected.length() - 1) != '\n') {
            selected.append('\n');
        }
        this.copyToClipBoard(selected);
        return selected;
    }

    public void updateUI() {
        super.updateUI();
        this.updateInputMap();
    }

    private void updateInputMap() {
        KeyStroke[] strokes;
        InputMap thisInputMap = this.getInputMap();
        InputMap sampleInputMap = new JTextField().getInputMap();
        for (KeyStroke stroke : strokes = sampleInputMap.allKeys()) {
            Object bind = sampleInputMap.get(stroke);
            if (!bind.equals("copy-to-clipboard")) continue;
            thisInputMap.put(stroke, "copy-to-clipboard");
        }
    }

    static {
        hints = new RenderingHints(null);
        if (AppSetting.osName != null && AppSetting.javaVendor != null && AppSetting.osName.toUpperCase().contains("WINDOWS") && AppSetting.javaVendor.toUpperCase().contains("SUN")) {
            antiAliaseText = false;
            useFractional = false;
        } else {
            antiAliaseText = true;
            useFractional = true;
        }
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (antiAliaseText) {
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (useFractional) {
            hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        } else {
            hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        AffineTransform affineTx = new AffineTransform();
        frc = new FontRenderContext(affineTx, antiAliaseText, useFractional);
    }

    private class DiscussionPopup
    extends JPopupMenu
    implements ActionListener {
        private final JMenuItem menuCopy = new JMenuItem("\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc");
        private final JMenuItem menuSelTalk = new JMenuItem("\u3053\u306e\u767a\u8a00\u3092\u30b3\u30d4\u30fc");
        private RowsLtoR lastPopupedRow;

        public DiscussionPopup() {
            this.add(this.menuCopy);
            this.add(this.menuSelTalk);
            this.menuCopy.setActionCommand("COPY");
            this.menuSelTalk.setActionCommand("SELTALK");
            this.menuCopy.addActionListener(this);
            this.menuSelTalk.addActionListener(this);
        }

        public void show(Component comp, int x, int y) {
            this.lastPopupedRow = Discussion.this.hitCheck(new Point(x, y));
            if (this.lastPopupedRow != null && this.lastPopupedRow instanceof TalkDraw) {
                this.menuSelTalk.setEnabled(true);
            } else {
                this.menuSelTalk.setEnabled(false);
            }
            if (Discussion.this.getSelected() != null) {
                this.menuCopy.setEnabled(true);
            } else {
                this.menuCopy.setEnabled(false);
            }
            super.show(comp, x, y);
        }

        public void actionPerformed(ActionEvent event) {
            String cmd = event.getActionCommand();
            if (cmd.equals("COPY")) {
                Discussion.this.copySelected();
            } else if (cmd.equals("SELTALK")) {
                Discussion.this.copyTalk(this.lastPopupedRow);
            }
        }
    }
}

