/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.TopicFilter;

public class FilterPanel
extends JFrame
implements ActionListener,
TopicFilter {
    private final JCheckBox checkPublic = new JCheckBox("\u516c\u958b", true);
    private final JCheckBox checkWolf = new JCheckBox("\u72fc", true);
    private final JCheckBox checkPrivate = new JCheckBox("\u72ec\u308a\u8a00", true);
    private final JCheckBox checkGrave = new JCheckBox("\u5893\u4e0b", true);
    private final JCheckBox checkExtra = new JCheckBox("Extra", true);
    private final JButton selAllButton = new JButton("\u5168\u9078\u629e");
    private final JButton selNoneButton = new JButton("\u5168\u89e3\u9664");
    private final JButton negateButton = new JButton("\u53cd\u8ee2");
    private final Map<Avatar, JCheckBox> cbMap = new HashMap<Avatar, JCheckBox>();
    private final List<JCheckBox> cbList = new LinkedList<JCheckBox>();
    private EventListenerList listeners;

    public FilterPanel() {
        super("\u767a\u8a00\u30d5\u30a3\u30eb\u30bf - " + Jindolf.title);
        this.setResizable(true);
        Toolkit kit = this.getToolkit();
        kit.setDynamicLayout(false);
        this.setIconImage(GUIUtils.getWindowIconImage());
        this.setLocationByPlatform(true);
        JComponent topicPanel = this.createTopicPanel();
        JComponent avatarPanel = this.createAvatarPanel();
        JComponent buttonPanel = this.createButtonPanel();
        this.design(topicPanel, avatarPanel, buttonPanel);
        this.listeners = new EventListenerList();
        this.checkPublic.addActionListener(this);
        this.checkWolf.addActionListener(this);
        this.checkPrivate.addActionListener(this);
        this.checkGrave.addActionListener(this);
        this.checkExtra.addActionListener(this);
        for (JCheckBox avatarCheckBox : this.cbList) {
            avatarCheckBox.addActionListener(this);
        }
        this.selAllButton.addActionListener(this);
        this.selNoneButton.addActionListener(this);
        this.negateButton.addActionListener(this);
    }

    private void design(JComponent topicPanel, JComponent avatarPanel, JComponent buttonPanel) {
        Container content = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.weightx = 0.2;
        constraints.weighty = 1.0;
        constraints.gridheight = 0;
        constraints.fill = 1;
        constraints.anchor = 10;
        content.add((Component)topicPanel, constraints);
        constraints.weightx = 0.0;
        constraints.gridheight = 0;
        constraints.fill = 3;
        content.add((Component)new JSeparator(1), constraints);
        constraints.weightx = 0.8;
        constraints.weighty = 1.0;
        constraints.gridheight = 1;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        content.add((Component)avatarPanel, constraints);
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        content.add((Component)new JSeparator(), constraints);
        constraints.insets = new Insets(5, 5, 5, 5);
        content.add((Component)buttonPanel, constraints);
    }

    private JComponent createTopicPanel() {
        this.checkPublic.setToolTipText("\u8ab0\u306b\u3067\u3082\u898b\u3048\u308b\u767a\u8a00");
        this.checkWolf.setToolTipText("\u4eba\u72fc\u540c\u58eb\u306b\u3057\u304b\u898b\u3048\u306a\u3044\u767a\u8a00");
        this.checkPrivate.setToolTipText("\u672c\u4eba\u306b\u3057\u304b\u898b\u3048\u306a\u3044\u767a\u8a00");
        this.checkGrave.setToolTipText("\u6b7b\u8005\u540c\u58eb\u306b\u3057\u304b\u898b\u3048\u306a\u3044\u767a\u8a00");
        this.checkExtra.setToolTipText("\u5360\u3044\u5148\u3084\u8b77\u885b\u5148\u306a\u3069\u306e\u30b7\u30b9\u30c6\u30e0\u30e1\u30c3\u30bb\u30fc\u30b8");
        JPanel topicPanel = new JPanel();
        topicPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        topicPanel.setLayout(layout);
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        topicPanel.add((Component)this.checkPublic, constraints);
        constraints.gridwidth = 0;
        topicPanel.add((Component)this.checkWolf, constraints);
        constraints.gridwidth = 0;
        topicPanel.add((Component)this.checkPrivate, constraints);
        constraints.gridwidth = 0;
        topicPanel.add((Component)this.checkGrave, constraints);
        constraints.gridwidth = 0;
        topicPanel.add((Component)this.checkExtra, constraints);
        return topicPanel;
    }

    private JComponent createAvatarPanel() {
        int cols = 4;
        JPanel avatarPanel = new JPanel();
        avatarPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        avatarPanel.setLayout(layout);
        constraints.weightx = 0.25;
        constraints.weighty = 1.0;
        constraints.anchor = 17;
        int xPos = 0;
        for (Avatar avatar : Avatar.getPredefinedAvatars()) {
            JCheckBox checkBox = new JCheckBox(avatar.getName(), true);
            checkBox.setToolTipText(avatar.getJobTitle());
            this.cbList.add(checkBox);
            if (xPos >= 3) {
                constraints.gridwidth = 0;
                xPos = 0;
            } else {
                constraints.gridwidth = 1;
                ++xPos;
            }
            avatarPanel.add((Component)checkBox, constraints);
            this.cbMap.put(avatar, checkBox);
        }
        return avatarPanel;
    }

    private JComponent createButtonPanel() {
        this.selAllButton.setToolTipText("\u5168\u30ad\u30e3\u30e9\u30af\u30bf\u306e\u767a\u8a00\u3092\u8868\u793a\u3059\u308b");
        this.selNoneButton.setToolTipText("\u5168\u30ad\u30e3\u30e9\u30af\u30bf\u306e\u767a\u8a00\u3092\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u3059\u308b");
        this.negateButton.setToolTipText("(\u8868\u793a\u21d4\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0)\u306e\u8a2d\u5b9a\u3092\u53cd\u8ee2\u3055\u305b\u308b");
        JPanel buttonPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        buttonPanel.setLayout(layout);
        constraints.weightx = 0.3333333333333333;
        constraints.insets = new Insets(0, 0, 0, 5);
        buttonPanel.add((Component)this.selAllButton, constraints);
        buttonPanel.add((Component)this.selNoneButton, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        buttonPanel.add((Component)this.negateButton, constraints);
        return buttonPanel;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listeners.getListeners(ChangeListener.class);
    }

    protected void fireCheckChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener listener : this.getChangeListeners()) {
            listener.stateChanged(changeEvent);
        }
    }

    public void initButtons() {
        this.checkPublic.setSelected(true);
        this.checkWolf.setSelected(true);
        this.checkPrivate.setSelected(true);
        this.checkGrave.setSelected(true);
        this.checkExtra.setSelected(true);
        this.selAllButton.doClick();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.selAllButton) {
            boolean hasChanged = false;
            for (JCheckBox avatarCBox : this.cbList) {
                if (avatarCBox.isSelected()) continue;
                avatarCBox.setSelected(true);
                hasChanged = true;
            }
            if (hasChanged) {
                this.fireCheckChanged();
            }
        } else if (source == this.selNoneButton) {
            boolean hasChanged = false;
            for (JCheckBox avatarCBox : this.cbList) {
                if (!avatarCBox.isSelected()) continue;
                avatarCBox.setSelected(false);
                hasChanged = true;
            }
            if (hasChanged) {
                this.fireCheckChanged();
            }
        } else if (source == this.negateButton) {
            for (JCheckBox avatarCBox : this.cbList) {
                if (avatarCBox.isSelected()) {
                    avatarCBox.setSelected(false);
                    continue;
                }
                avatarCBox.setSelected(true);
            }
            this.fireCheckChanged();
        } else if (source instanceof JCheckBox) {
            this.fireCheckChanged();
        }
    }

    public boolean isFiltered(Topic topic) {
        JCheckBox cbox;
        if (!(topic instanceof Talk)) {
            if (topic instanceof SysEvent) {
                SysEvent sysEvent = (SysEvent)topic;
                return sysEvent.getEventClass() == SysEvent.EventClass.EXTRA && !this.checkExtra.isSelected();
            }
            return false;
        }
        Talk talk = (Talk)topic;
        Talk.Type type = talk.getTalkType();
        switch (type) {
            case PUBLIC: {
                cbox = this.checkPublic;
                break;
            }
            case WOLFONLY: {
                cbox = this.checkWolf;
                break;
            }
            case PRIVATE: {
                cbox = this.checkPrivate;
                break;
            }
            case GRAVE: {
                cbox = this.checkGrave;
                break;
            }
            default: {
                assert (false);
                return true;
            }
        }
        if (!cbox.isSelected()) {
            return true;
        }
        Avatar avatar = talk.getAvatar();
        cbox = this.cbMap.get(avatar);
        return !cbox.isSelected();
    }

    public TopicFilter.FilterContext getFilterContext() {
        return new FilterPanelContext();
    }

    public boolean isSame(TopicFilter.FilterContext context) {
        if (context == null) {
            return false;
        }
        if (!(context instanceof FilterPanelContext)) {
            return false;
        }
        FilterPanelContext argContext = (FilterPanelContext)context;
        FilterPanelContext thisContext = (FilterPanelContext)this.getFilterContext();
        return thisContext.context.equals(argContext.context);
    }

    private class FilterPanelContext
    implements TopicFilter.FilterContext {
        private final BitSet context = new BitSet();

        public FilterPanelContext() {
            int index = 0;
            this.context.set(index++, FilterPanel.this.checkPublic.isSelected());
            this.context.set(index++, FilterPanel.this.checkWolf.isSelected());
            this.context.set(index++, FilterPanel.this.checkPrivate.isSelected());
            this.context.set(index++, FilterPanel.this.checkGrave.isSelected());
            this.context.set(index++, FilterPanel.this.checkExtra.isSelected());
            for (Avatar avatar : Avatar.getPredefinedAvatars()) {
                JCheckBox checkBox = (JCheckBox)FilterPanel.this.cbMap.get(avatar);
                this.context.set(index++, checkBox.isSelected());
            }
        }
    }
}

