/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.Controller;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.MenuManager;
import jp.sourceforge.jindolf.PileHandler;
import jp.sourceforge.jindolf.TopFrameView;

public class Jindolf {
    public static final String version = "2.7.2";
    public static final String license = "The MIT License";
    public static final String contact = "http://jindolf.sourceforge.jp/";
    public static final Date initDate;
    public static final long initNano;
    public static final ClassLoader loader;
    public static final Class selfClass;
    public static final Package selfPackage;
    public static final Package jrePackage;
    public static final Runtime runtime;
    public static SecurityManager secManager;
    public static final Logger logger;
    public static final String title;
    public static final String author;
    public static final String copyright;
    public static final String id;
    private static final int STOCK_SIZE = 65536;
    private static byte[] stock;
    private static final Charset CHARSET_UTF8;

    public static InputStream getResourceAsStream(String name) {
        return selfClass.getResourceAsStream(name);
    }

    public static URL getResource(String name) {
        return selfClass.getResource(name);
    }

    public static void keepStock() {
        if (stock == null) {
            stock = new byte[65536];
        }
    }

    public static void freeStock() {
        stock = null;
        runtime.runFinalization();
        Thread.yield();
        runtime.gc();
        Thread.yield();
    }

    private static void preLoadClass() throws LinkageError, ExceptionInInitializerError {
        String[] classes;
        for (String className : classes = new String[]{"java.lang.Object", "jp.sourceforge.jindolf.TabBrowser", "jp.sourceforge.jindolf.TopFrameView", "java.net.HttpURLConnection", "java.text.SimpleDateFormat"}) {
            try {
                if (loader != null) {
                    Class.forName(className, true, loader);
                    continue;
                }
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.WARNING, "\u30af\u30e9\u30b9\u306e\u660e\u793a\u7684\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            }
        }
    }

    public static boolean hasRuntime5() {
        boolean result;
        try {
            result = jrePackage.isCompatibleWith("1.5");
        }
        catch (NumberFormatException e) {
            assert (false);
            return false;
        }
        return result;
    }

    public static boolean hasRuntime6() {
        boolean result;
        try {
            result = jrePackage.isCompatibleWith("1.6");
        }
        catch (NumberFormatException e) {
            assert (false);
            return false;
        }
        return result;
    }

    public static void exit(int exitCode) throws SecurityException {
        try {
            logger.info("\u7d42\u4e86\u30b3\u30fc\u30c9[" + exitCode + "]\u3067VM\u3054\u3068\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002");
            runtime.exit(exitCode);
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, "VM\u3092\u7d42\u4e86\u3067\u304d\u307e\u305b\u3093\u3002", e);
            throw e;
        }
    }

    private static void testEnvironment() {
        if (!Jindolf.hasRuntime5()) {
            logger.severe(title + " needs JRE1.5 platform or later.");
            Jindolf.exit(1);
        }
        if (GraphicsEnvironment.isHeadless()) {
            logger.severe(title + " needs bit-map display, keyboard, & pointing-device.");
            Jindolf.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(final String[] args) {
        ConsoleHandler consoleHandler;
        AppSetting.parseOptions(args);
        if (AppSetting.needHelp) {
            Jindolf.showHelpMessage();
            runtime.exit(0);
        }
        if (AppSetting.needVersion) {
            System.out.println(id);
            runtime.exit(0);
        }
        if (AppSetting.needVMInfo) {
            System.out.println(AppSetting.getVMInfo());
        }
        if (AppSetting.consolelog) {
            consoleHandler = new ConsoleHandler();
            logger.addHandler(consoleHandler);
        } else {
            consoleHandler = null;
        }
        if (Jindolf.hasRuntime6() && AppSetting.noSplash) {
            System.out.println("JRE1.6\u4ee5\u964d\u3067\u306f\u3001Java\u5b9f\u884c\u7cfb\u306e\u65b9\u3067\u30b9\u30d7\u30e9\u30c3\u30b7\u30e5\u753b\u9762\u306e\u975e\u8868\u793a\u3092\u6307\u793a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        Jindolf.testEnvironment();
        runtime.addShutdownHook(new Thread(){

            public void run() {
                Handler[] handlers;
                logger.info("\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u51e6\u7406\u306b\u5165\u308a\u307e\u3059\u2026");
                for (Handler handler : handlers = logger.getHandlers()) {
                    handler.flush();
                    if (!(handler instanceof PileHandler)) continue;
                    PileHandler pile = (PileHandler)handler;
                    if (consoleHandler != null) {
                        pile.delegate(consoleHandler);
                    } else {
                        pile.delegate(new ConsoleHandler());
                    }
                    pile.close();
                    break;
                }
                System.out.flush();
                System.err.flush();
                runtime.runFinalization();
                Thread.yield();
            }
        });
        logger.info(id + " \u304c " + initDate + " \u306b\u5b9f\u884c\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002 ");
        logger.info("Max-heap:" + runtime.maxMemory() / 1024L / 1024L + "MByte" + " Total-heap:" + runtime.totalMemory() / 1024L / 1024L + "MByte");
        logger.info("\n" + AppSetting.getVMInfo());
        if (AppSetting.boldMetal) {
            UIManager.put("swing.boldMetal", Boolean.TRUE);
        } else {
            UIManager.put("swing.boldMetal", Boolean.FALSE);
        }
        Window splashWindow = null;
        if (!Jindolf.hasRuntime6() && !AppSetting.noSplash) {
            splashWindow = Jindolf.createSplashWindow();
            splashWindow.setVisible(true);
            GUIUtils.dispatchAWTEvent();
        }
        boolean hasError = false;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Jindolf.startGUI(args);
                }
            });
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u521d\u671f\u5316\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            hasError = true;
        }
        finally {
            if (splashWindow != null) {
                splashWindow.setVisible(false);
                splashWindow.dispose();
                splashWindow = null;
                GUIUtils.dispatchAWTEvent();
            }
        }
        if (hasError) {
            Jindolf.exit(1);
        }
    }

    private static void startGUI(String[] args) {
        Jindolf.preLoadClass();
        LandsModel model = new LandsModel();
        try {
            model.loadLandList();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "\u56fd\u5b9a\u7fa9\u4e00\u89a7\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            Jindolf.exit(1);
        }
        TopFrameView topFrame = Jindolf.buildMVC(model);
        topFrame.setDefaultCloseOperation(3);
        topFrame.setResizable(true);
        topFrame.setIconImage(GUIUtils.getWindowIconImage());
        topFrame.pack();
        Dimension initGeometry = new Dimension(AppSetting.frameWidth, AppSetting.frameHeight);
        topFrame.setSize(initGeometry);
        if (AppSetting.frameXpos <= Integer.MIN_VALUE || AppSetting.frameYpos <= Integer.MIN_VALUE) {
            topFrame.setLocationByPlatform(true);
        } else {
            topFrame.setLocation(AppSetting.frameXpos, AppSetting.frameYpos);
        }
        Toolkit kit = topFrame.getToolkit();
        kit.setDynamicLayout(false);
        topFrame.setVisible(true);
    }

    private static Window createSplashWindow() {
        JWindow splashWindow = new JWindow();
        JLabel splashLabel = new JLabel(GUIUtils.getLogoIcon());
        splashWindow.add(splashLabel);
        splashWindow.pack();
        splashWindow.setLocationRelativeTo(null);
        return splashWindow;
    }

    private static TopFrameView buildMVC(LandsModel model) {
        MenuManager menuManager = new MenuManager();
        TopFrameView topFrame = new TopFrameView();
        topFrame.setJMenuBar(menuManager.createMenuBar());
        new Controller(menuManager, topFrame, model);
        return topFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showHelpMessage() {
        System.out.flush();
        System.err.flush();
        InputStream is = Jindolf.getResourceAsStream("resources/help.txt");
        is = new BufferedInputStream(is);
        InputStreamReader reader = new InputStreamReader(is, CHARSET_UTF8);
        LineNumberReader lineReader = new LineNumberReader(reader);
        try {
            while (true) {
                String line;
                try {
                    line = lineReader.readLine();
                }
                catch (IOException e) {
                    try {
                        lineReader.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return;
                }
                if (line == null) {
                    break;
                }
                if (line.startsWith("#")) continue;
                System.out.println(line);
            }
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException e) {}
        }
        System.out.flush();
        System.err.flush();
    }

    private Jindolf() {
        assert (false);
        throw new Error();
    }

    static {
        String implVendor;
        ClassLoader thisLoader;
        CHARSET_UTF8 = Charset.forName("UTF-8");
        initDate = new Date();
        initNano = System.nanoTime();
        selfClass = Jindolf.class;
        selfPackage = selfClass.getPackage();
        jrePackage = Object.class.getPackage();
        runtime = Runtime.getRuntime();
        secManager = System.getSecurityManager();
        logger = Logger.getLogger(selfPackage.getName());
        logger.setUseParentHandlers(false);
        logger.addHandler(new PileHandler());
        try {
            thisLoader = selfClass.getClassLoader();
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, "\u30af\u30e9\u30b9\u30ed\u30fc\u30c0\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            thisLoader = null;
        }
        loader = thisLoader;
        String implTitle = selfPackage.getImplementationTitle();
        title = implTitle != null ? implTitle : "Jindolf";
        String implVersion = selfPackage.getImplementationVersion();
        if (implVersion != null && !version.equals(implVersion)) {
            String message = "\u30d1\u30c3\u30b1\u30fc\u30b8\u5b9a\u7fa9\u3068\u30d0\u30fc\u30b8\u30e7\u30f3\u756a\u53f7\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002[" + implVersion + "]\u2260[" + version + "]";
            System.err.println(message);
            runtime.exit(1);
        }
        author = (implVendor = selfPackage.getImplementationVendor()) != null ? implVendor : "olyutorskii";
        copyright = "Copyright(c) 2008 " + author;
        id = title + " Ver." + version + " " + copyright + " (" + license + ")";
        Jindolf.keepStock();
    }
}

