/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class MenuManager {
    public static final String COMMAND_EXIT = "EXIT";
    public static final String COMMAND_ABOUT = "ABOUT";
    public static final String COMMAND_LANDF = "LANDF";
    public static final String COMMAND_HELPDOC = "HELPDOC";
    public static final String COMMAND_FILTER = "FILTER";
    public static final String COMMAND_ACCOUNT = "ACCOUNT";
    public static final String COMMAND_RELOAD = "RELOAD";
    public static final String COMMAND_SEARCH = "SEARCH";
    public static final String COMMAND_COPY = "COPY";
    public static final String COMMAND_PRINT = "PRINT";
    public static final String COMMAND_SELALL = "SELALL";
    public static final String COMMAND_COPYTALK = "SELTALK";
    public static final String COMMAND_SWITCHORDER = "SWITCHORDER";
    public static final String COMMAND_VILLAGELIST = "VILLAGELIST";
    public static final String COMMAND_SHOWLOG = "SHOWLOG";
    private Set<AbstractButton> items = new HashSet<AbstractButton>();
    private JMenuItem itemExit;
    private JMenuItem itemAbout;
    private JMenuItem itemHelpDoc;
    private JMenuItem itemFilter;
    private JMenuItem itemAccount;
    private JMenuItem itemShowLog;
    private ButtonGroup landfGroup = new ButtonGroup();
    private Map<ButtonModel, String> landfMap = new HashMap<ButtonModel, String>();

    public MenuManager() {
        this.itemExit = new JMenuItem("Exit");
        this.itemAbout = new JMenuItem("About");
        this.itemHelpDoc = new JMenuItem("Help document");
        this.itemFilter = new JMenuItem("Show Filter");
        this.itemAccount = new JMenuItem("Manage Account");
        this.itemShowLog = new JMenuItem("Show Log Message");
        this.itemExit.setActionCommand(COMMAND_EXIT);
        this.itemAbout.setActionCommand(COMMAND_ABOUT);
        this.itemHelpDoc.setActionCommand(COMMAND_HELPDOC);
        this.itemFilter.setActionCommand(COMMAND_FILTER);
        this.itemAccount.setActionCommand(COMMAND_ACCOUNT);
        this.itemShowLog.setActionCommand(COMMAND_SHOWLOG);
        this.itemExit.setMnemonic(88);
        this.itemAbout.setMnemonic(65);
        this.itemHelpDoc.setMnemonic(72);
        this.itemFilter.setMnemonic(70);
        this.itemAccount.setMnemonic(77);
        this.itemShowLog.setMnemonic(83);
        this.items.add(this.itemExit);
        this.items.add(this.itemAbout);
        this.items.add(this.itemHelpDoc);
        this.items.add(this.itemFilter);
        this.items.add(this.itemAccount);
        this.items.add(this.itemShowLog);
        this.createLookAndFeelMenuItems();
    }

    private void createLookAndFeelMenuItems() {
        UIManager.LookAndFeelInfo[] landfs;
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        String currentName = currentLookAndFeel.getClass().getName();
        AbstractButton matchedButton = null;
        for (UIManager.LookAndFeelInfo lafInfo : landfs = UIManager.getInstalledLookAndFeels()) {
            String name = lafInfo.getName();
            String className = lafInfo.getClassName();
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(name);
            button.setActionCommand(COMMAND_LANDF);
            if (className.equals(currentName)) {
                matchedButton = button;
            }
            this.items.add(button);
            this.landfGroup.add(button);
            this.landfMap.put(button.getModel(), className);
        }
        if (matchedButton != null) {
            matchedButton.setSelected(true);
        }
    }

    public String getSelectedLookAndFeel() {
        ButtonModel selected = this.landfGroup.getSelection();
        if (selected == null) {
            return null;
        }
        String className = this.landfMap.get(selected);
        return className;
    }

    public void addActionListener(ActionListener listener) {
        for (AbstractButton button : this.items) {
            button.addActionListener(listener);
        }
    }

    public JMenuBar createMenuBar() {
        JMenu menuFile = new JMenu("File");
        JMenu menuLook = new JMenu("Look & Feel");
        JMenu menuWindow = new JMenu("Window");
        JMenu menuHelp = new JMenu("Help");
        menuFile.setMnemonic(70);
        menuLook.setMnemonic(76);
        menuWindow.setMnemonic(87);
        menuHelp.setMnemonic(72);
        menuFile.add(this.itemExit);
        menuWindow.add(this.itemFilter);
        menuWindow.add(this.itemAccount);
        menuWindow.add(this.itemShowLog);
        menuHelp.add(this.itemHelpDoc);
        menuHelp.addSeparator();
        menuHelp.add(this.itemAbout);
        Enumeration<AbstractButton> landfButtons = this.landfGroup.getElements();
        while (landfButtons.hasMoreElements()) {
            JMenuItem item = (JMenuItem)landfButtons.nextElement();
            menuLook.add(item);
        }
        JMenuBar bar = new JMenuBar();
        bar.add(menuFile);
        bar.add(menuWindow);
        bar.add(menuLook);
        bar.add(menuHelp);
        return bar;
    }
}

