/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Image;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Period {
    private static final Pattern villageInfoRegex;
    private static final Pattern startMessageRegex;
    private static final Pattern switchTagRegex;
    private static final Pattern talkRegex;
    private static final Pattern eventBodyRegex;
    private static final Pattern anchorRegex;
    private final Village homeVillage;
    private final Type periodType;
    private final int day;
    private final List<Topic> topicList;
    private final List<Topic> unmodList;
    private final Map<Avatar, int[]> countMap;
    private boolean isHot;

    public Period(Village homeVillage, Type periodType, int day) throws NullPointerException {
        this(homeVillage, periodType, day, false);
    }

    private Period(Village homeVillage, Type periodType, int day, boolean isHot) throws NullPointerException {
        if (homeVillage == null || periodType == null) {
            throw new NullPointerException();
        }
        if (day < 0) {
            throw new IllegalArgumentException("Period day is too small !");
        }
        switch (periodType) {
            case PROLOGUE: {
                assert (day == 0);
                break;
            }
            case PROGRESS: 
            case EPILOGUE: {
                assert (day > 0);
                break;
            }
        }
        this.homeVillage = homeVillage;
        this.periodType = periodType;
        this.day = day;
        this.topicList = new LinkedList<Topic>();
        this.unmodList = Collections.unmodifiableList(this.topicList);
        this.countMap = new HashMap<Avatar, int[]>();
        this.topicList.clear();
        this.countMap.clear();
        this.isHot = isHot;
    }

    public Village getVillage() {
        return this.homeVillage;
    }

    public Type getType() {
        return this.periodType;
    }

    public int getDay() {
        return this.day;
    }

    public boolean isHot() {
        return this.isHot;
    }

    public void setHot(boolean isHot) {
        this.isHot = isHot;
    }

    public boolean isPrologue() {
        return this.getType() == Type.PROLOGUE;
    }

    public boolean isEpilogue() {
        return this.getType() == Type.EPILOGUE;
    }

    public boolean isProgress() {
        return this.getType() == Type.PROGRESS;
    }

    public CharSequence getCGIQuery() {
        StringBuilder result = new StringBuilder();
        Village village = this.getVillage();
        result.append(village.getCGIQuery());
        if (this.isHot()) {
            result.append("&mes=all");
            return result;
        }
        result.append("&meslog=").append(village.getVillageID());
        switch (this.getType()) {
            case PROLOGUE: {
                result.append("_ready_0");
                break;
            }
            case PROGRESS: {
                result.append("_progress_").append(this.getDay() - 1);
                break;
            }
            case EPILOGUE: {
                result.append("_party_").append(this.getDay() - 1);
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return result;
    }

    public List<Topic> getTopicList() {
        return this.unmodList;
    }

    public int getTopics() {
        return this.topicList.size();
    }

    protected void addTopic(Topic topic) throws NullPointerException {
        if (topic == null) {
            throw new NullPointerException();
        }
        this.topicList.add(topic);
    }

    public String getCaption() {
        String result;
        switch (this.getType()) {
            case PROLOGUE: {
                result = "\u30d7\u30ed\u30ed\u30fc\u30b0";
                break;
            }
            case PROGRESS: {
                result = "" + this.getDay() + "\u65e5\u76ee";
                break;
            }
            case EPILOGUE: {
                result = "\u30a8\u30d4\u30ed\u30fc\u30b0";
                break;
            }
            default: {
                assert (false);
                result = null;
            }
        }
        return result;
    }

    public boolean hasLoaded() {
        return this.getTopics() > 0;
    }

    public void reloadPeriod() throws IOException {
        this.loadPeriod(true);
    }

    public void updatePeriod() throws IOException {
        this.loadPeriod(false);
    }

    public void loadPeriod(boolean force) throws IOException {
        if (!force && this.hasLoaded()) {
            return;
        }
        Village village = this.getVillage();
        Land land = village.getParentLand();
        ServerAccess server = land.getServerAccess();
        CharSequence html = server.getHTMLPeriod(this);
        this.topicList.clear();
        this.countMap.clear();
        int lastPos = 0;
        int htmlLength = html.length();
        lastPos = this.parseDeadLine(html, lastPos, htmlLength);
        boolean wasHot = this.isHot();
        lastPos = this.parseDayLink(html, lastPos, htmlLength);
        if (wasHot && !this.isHot()) {
            this.reloadPeriod();
            return;
        }
        lastPos = this.parseTopics(html, lastPos, htmlLength);
    }

    private int parseDeadLine(CharSequence html, int startPos, int endPos) {
        int lastPos = startPos;
        Matcher matcher = villageInfoRegex.matcher(html);
        matcher.region(startPos, endPos);
        if (!matcher.find()) {
            return lastPos;
        }
        lastPos = matcher.end();
        String vName = matcher.group(1);
        String month = matcher.group(2);
        String xday = matcher.group(3);
        String ampm = matcher.group(4);
        String hh = matcher.group(5);
        String mm = matcher.group(6);
        int upMonth = Integer.parseInt(month);
        int upDay = Integer.parseInt(xday);
        int upHour = Integer.parseInt(hh);
        int upMinute = Integer.parseInt(mm);
        if (ampm.equals("\u5348\u5f8c")) {
            upHour += 12;
        }
        upHour %= 24;
        return lastPos;
    }

    private int parseDayLink(CharSequence html, int startPos, int endPos) {
        int lastPos = startPos;
        Matcher matcher = anchorRegex.matcher(html);
        matcher.region(startPos, endPos);
        while (matcher.find()) {
            lastPos = matcher.end();
            String hrefValue = matcher.group(1);
            String anchorText = matcher.group(2);
            String dayString = matcher.group(3);
            if (anchorText.equals("\u30d7\u30ed\u30ed\u30fc\u30b0")) {
                if (this.getType() != Type.PROLOGUE) continue;
                this.setHot(false);
                continue;
            }
            if (anchorText.endsWith("\u65e5\u76ee")) {
                int dayNum = Integer.parseInt(dayString);
                if (this.getType() != Type.PROGRESS || this.getDay() != dayNum) continue;
                this.setHot(false);
                continue;
            }
            if (anchorText.equals("\u30a8\u30d4\u30ed\u30fc\u30b0")) {
                if (this.getType() != Type.EPILOGUE) continue;
                this.setHot(false);
                continue;
            }
            if (!anchorText.equals("\u7d42\u4e86")) continue;
            break;
        }
        return lastPos;
    }

    private int parseTopics(CharSequence html, int startPos, int endPos) {
        int newPos;
        int lastPos = startPos;
        while ((newPos = this.findTopic(html, lastPos, endPos)) > lastPos) {
            lastPos = newPos;
        }
        return lastPos;
    }

    private int findTopic(CharSequence html, int startPos, int endPos) {
        int nextPos;
        Matcher matcher = startMessageRegex.matcher(html);
        matcher.region(startPos, endPos);
        if (!matcher.find()) {
            return startPos;
        }
        int lastPos = matcher.end();
        matcher = switchTagRegex.matcher(html);
        matcher.region(lastPos, endPos);
        if (!matcher.find()) {
            return startPos;
        }
        lastPos = matcher.end();
        String eventClassStr = matcher.group(1);
        String mesID = matcher.group(2);
        String fullName = matcher.group(3);
        if (eventClassStr != null) {
            SysEvent.EventClass eventClass = SysEvent.decodeEventClass(eventClassStr);
            nextPos = this.findSystemEvent(eventClass, html, lastPos, endPos);
        } else {
            nextPos = this.findTalk(mesID, fullName, html, lastPos, endPos);
        }
        if (lastPos >= nextPos) {
            return startPos;
        }
        return nextPos;
    }

    private int findSystemEvent(SysEvent.EventClass eventClass, CharSequence html, int startPos, int endPos) {
        Matcher matcher = eventBodyRegex.matcher(html);
        matcher.region(startPos, endPos);
        if (!matcher.find()) {
            return startPos;
        }
        int nextPos = matcher.end();
        String body = matcher.group(1);
        SysEvent event = new SysEvent(eventClass, body);
        this.addTopic(event);
        SysEvent.Type eventType = event.getType();
        if (eventType == SysEvent.Type.MURDER || eventType == SysEvent.Type.NOMURDER) {
            for (Topic topic : this.topicList) {
                Talk talk;
                if (!(topic instanceof Talk) || (talk = (Talk)topic).getTalkType() != Talk.Type.WOLFONLY || !talk.getDialog().endsWith("\uff01 \u4eca\u65e5\u304c\u304a\u524d\u306e\u547d\u65e5\u3060\uff01")) continue;
                talk.setCount(-1);
                this.countMap.clear();
            }
        }
        return nextPos;
    }

    private int findTalk(String anchorID, String fullName, CharSequence html, int startPos, int endPos) {
        Matcher matcher = talkRegex.matcher(html);
        matcher.region(startPos, endPos);
        if (!matcher.find()) {
            return startPos;
        }
        int nextPos = matcher.end();
        String ampm = matcher.group(1);
        String hh = matcher.group(2);
        String mm = matcher.group(3);
        String faceimg = matcher.group(4).intern();
        String baloonimg = matcher.group(5).intern();
        String mclass1 = matcher.group(6).intern();
        String mclass2 = matcher.group(7).intern();
        String dialog = matcher.group(8);
        int hour = Integer.parseInt(hh);
        int minute = Integer.parseInt(mm);
        if (ampm.equals("\u5348\u5f8c")) {
            hour += 12;
        }
        hour %= 24;
        assert (mclass1.equals(mclass2));
        Talk.Type type = Talk.decodeType(mclass1);
        if (type == null) {
            return startPos;
        }
        Village village = this.getVillage();
        Land land = village.getParentLand();
        Avatar avatar = village.getAvatar(fullName);
        if (avatar == null) {
            avatar = new Avatar(fullName);
            village.addAvatar(avatar);
        }
        if (type == Talk.Type.GRAVE) {
            if (village.getGraveImage() == null) {
                Image graveImage = land.getImageFromRelativeSrc(faceimg);
                village.setGraveImage(graveImage);
            }
        } else if (village.getAvatarFaceImage(avatar) == null && faceimg != null) {
            Image image = land.getImageFromRelativeSrc(faceimg);
            village.putAvatarFaceImage(avatar, image);
        }
        Talk talk = new Talk(this, type, avatar, anchorID, hour, minute, dialog);
        int[] counts = this.countMap.get(avatar);
        if (counts == null) {
            counts = new int[4];
            this.countMap.put(avatar, counts);
        }
        int n = type.ordinal();
        int n2 = counts[n] + 1;
        counts[n] = n2;
        int count = n2;
        talk.setCount(count);
        this.addTopic(talk);
        return nextPos;
    }

    static {
        String Spchar = " \\t\\n\\r";
        String Sp = "[" + Spchar + "]";
        String Sp_n = Sp + "*";
        String Sp_m = Sp + "+";
        String villageInfo = ">" + Sp_n + "([^<]+?)" + Sp_n + "<strong>" + Sp_n + "[\\(\uff08]" + Sp_n + "([1-9][0-9]?)/([1-9][0-9]?)" + Sp_n + "(\u5348\u524d|\u5348\u5f8c)" + Sp_n + "([0-9][0-9]?)\u6642" + Sp_n + "([0-9][0-9]?)\u5206" + Sp_n + "\u306b\u66f4\u65b0" + Sp_n + "[\\)\uff09]" + Sp_n + "</strong>";
        String divMessage = Sp_n + "<div class=\"message\">" + Sp_n;
        String divEvent = "<div class=\"(announce|order|extra)\">";
        String anchorTalk = "<a name=\"([^\"]+)\">([^<]+)</a>";
        String tagSwitch = Sp_n + "(?:" + divEvent + "|" + anchorTalk + ")" + Sp_n;
        String brEmpty = "<br" + Sp_n + "/>";
        String anchorStart = "<a" + Sp_m + "href=\"([^\"]*)\"" + Sp_n + ">";
        String anchorClose = "</a>";
        String anchor = anchorStart + "([^<]*)" + anchorClose;
        String textWithBR = "(?:[^<]*?|" + brEmpty + "|" + anchor + ")*?";
        String divEnd = "</div>";
        String talkPattern = Sp_n + "<span class=\"time\">" + Sp_n + "(\u5348\u524d|\u5348\u5f8c)" + Sp_n + "([0-9][0-9]?)\u6642" + Sp_n + "([0-9][0-9]?)\u5206" + Sp_n + "</span>" + Sp_n + "<table [^>]*? class=\"message_box\">" + Sp_n + "<tr>" + Sp_n + "<td width=\"[^\"]*\">" + Sp_n + "<img src=\"([^\"]+)\">" + Sp_n + "</td>" + Sp_n + "<td width=\"[^\"]*\">" + Sp_n + "<img src=\"([^\"]+)\">" + Sp_n + "</td>" + Sp_n + "<td>" + Sp_n + "<div class=\"mes_([^\"]+)_body[01]\">" + Sp_n + "<div class=\"mes_([^\"]+)_body[01]\">" + Sp_n + "(" + textWithBR + ")" + Sp_n + divEnd + Sp_n + divEnd + Sp_n + "</td>" + Sp_n + "</tr>" + Sp_n + "</table>" + Sp_n + divEnd + Sp_n;
        String eventBody = "(?:[^<]*?|" + brEmpty + "|" + anchor + ")*?";
        eventBody = "(" + eventBody + ")" + Sp_n + divEnd + Sp_n + divEnd + Sp_n;
        String prologue = "\u30d7\u30ed\u30ed\u30fc\u30b0";
        String epilogue = "\u30a8\u30d4\u30ed\u30fc\u30b0";
        String gameover = "\u7d42\u4e86";
        String progress = "([1-9][0-9]*)\u65e5\u76ee";
        String content = "(" + prologue + "|" + epilogue + "|" + progress + "|" + gameover + ")";
        String periodAnchor = anchorStart + content + anchorClose;
        villageInfoRegex = Pattern.compile(villageInfo, 32);
        startMessageRegex = Pattern.compile(divMessage, 32);
        switchTagRegex = Pattern.compile(tagSwitch, 32);
        talkRegex = Pattern.compile(talkPattern, 32);
        eventBodyRegex = Pattern.compile(eventBody, 32);
        anchorRegex = Pattern.compile(periodAnchor, 32);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PROLOGUE,
        PROGRESS,
        EPILOGUE;

    }
}

