/*
 * action manager
 * 
 * Copyright(c) 2008 olyutorskii
 * $Id: ActionManager.java 171 2008-09-08 14:44:27Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

/**
 * メニュー、ボタン、その他各種Actionを伴うイベントを生成する
 * コンポーネントの一括管理
 */
public class ActionManager{
    
    public static final String COMMAND_EXIT  = "EXIT";
    public static final String COMMAND_ABOUT = "ABOUT";
    public static final String COMMAND_LANDF = "LANDF";
    public static final String COMMAND_HELPDOC = "HELPDOC";
    public static final String COMMAND_FILTER = "FILTER";
    public static final String COMMAND_ACCOUNT = "ACCOUNT";
    public static final String COMMAND_RELOAD = "RELOAD";
    public static final String COMMAND_SEARCH = "SEARCH";
    public static final String COMMAND_COPY = "COPY";
    public static final String COMMAND_PRINT = "PRINT";
    public static final String COMMAND_SELALL = "SELALL";
    public static final String COMMAND_COPYTALK = "SELTALK";
    public static final String COMMAND_SWITCHORDER = "SWITCHORDER";
    public static final String COMMAND_VILLAGELIST = "VILLAGELIST";
    public static final String COMMAND_SHOWLOG = "SHOWLOG";
    public static final String COMMAND_FONTSELECT = "FONTSELECT";
    public static final String COMMAND_FONTSIZESEL = "FONTSIZESEL";
    public static final String COMMAND_FONTAPPLY = "FONTAPPLY";
    public static final String COMMAND_FONTCANCEL = "FONTCANCEL";
    
    private Set<AbstractButton> items = new HashSet<AbstractButton>();

    private JMenuItem itemExit;
    private JMenuItem itemAbout;
    private JMenuItem itemHelpDoc;
    private JMenuItem itemFilter;
    private JMenuItem itemAccount;
    private JMenuItem itemShowLog;
    private JMenuItem itemFontSelect;

    private ButtonGroup landfGroup = new ButtonGroup();
    private Map<ButtonModel, String> landfMap
        = new HashMap<ButtonModel, String>();
    
    public ActionManager(){
        itemExit  = new JMenuItem("終了(X)");
        itemAbout = new JMenuItem(Jindolf.title + "について...(A)");
        itemHelpDoc = new JMenuItem("ヘルプ表示(H)");
        itemFilter = new JMenuItem("発言フィルタ(F)");
        itemAccount = new JMenuItem("アカウント管理(M)");
        itemShowLog = new JMenuItem("ログ表示(S)");
        itemFontSelect = new JMenuItem("発言表示フォント選択...(F)");

        itemExit .setActionCommand(COMMAND_EXIT);
        itemAbout.setActionCommand(COMMAND_ABOUT);
        itemHelpDoc.setActionCommand(COMMAND_HELPDOC);
        itemFilter.setActionCommand(COMMAND_FILTER);
        itemAccount.setActionCommand(COMMAND_ACCOUNT);
        itemShowLog.setActionCommand(COMMAND_SHOWLOG);
        itemFontSelect.setActionCommand(COMMAND_FONTSELECT);
    
        itemExit    .setMnemonic(java.awt.event.KeyEvent.VK_X);
        itemAbout   .setMnemonic(java.awt.event.KeyEvent.VK_A);
        itemHelpDoc .setMnemonic(java.awt.event.KeyEvent.VK_H);
        itemFilter  .setMnemonic(java.awt.event.KeyEvent.VK_F);
        itemAccount .setMnemonic(java.awt.event.KeyEvent.VK_M);
        itemShowLog .setMnemonic(java.awt.event.KeyEvent.VK_S);
        itemFontSelect .setMnemonic(java.awt.event.KeyEvent.VK_F);

        items.add(itemExit);
        items.add(itemAbout);
        items.add(itemHelpDoc);
        items.add(itemFilter);
        items.add(itemAccount);
        items.add(itemShowLog);
        items.add(itemFontSelect);

        createLookAndFeelMenuItems();

        return;
    }
    
    /**
     * L&F 一覧メニューを作成する。
     */
    private void createLookAndFeelMenuItems(){
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        String currentName = currentLookAndFeel.getClass().getName();
        AbstractButton matchedButton = null;

        UIManager.LookAndFeelInfo[] landfs =
                UIManager.getInstalledLookAndFeels();
        for(UIManager.LookAndFeelInfo lafInfo : landfs){
            String name      = lafInfo.getName();
            String className = lafInfo.getClassName();

            JRadioButtonMenuItem button = new JRadioButtonMenuItem(name);
            button.setActionCommand(COMMAND_LANDF);

            if(className.equals(currentName)) matchedButton = button;

            items.add(button);
            landfGroup.add(button);
            landfMap.put(button.getModel(), className);
        }

        if(matchedButton != null) matchedButton.setSelected(true);

        return;
    }
    
    /**
     * 現在メニューで選択中のL&Fのクラス名を返す。
     * @return L&F クラス名
     */
    public String getSelectedLookAndFeel(){
        ButtonModel selected = landfGroup.getSelection();
        if(selected == null) return null;
        String className = landfMap.get(selected);
        return className;
    }
    
    /**
     * 全てのボタンにリスナー登録する。
     * @param listener リスナー
     */
    public void addActionListener(ActionListener listener){
        for(AbstractButton button : items){
            button.addActionListener(listener);
        }
        return;
    }
    
    /**
     * メニューバーを生成する。
     * @return メニューバー
     */
    public JMenuBar createMenuBar(){
        JMenuBar bar;

        JMenu menuFile;
        JMenu menuLook;
        JMenu menuPreference;
        JMenu menuWindow;
        JMenu menuHelp;
        
        menuFile = new JMenu("ファイル(F)");
        menuPreference = new JMenu("設定(P)");
        menuWindow = new JMenu("ウィンドウ(W)");
        menuHelp = new JMenu("ヘルプ(H)");

        menuFile.setMnemonic(java.awt.event.KeyEvent.VK_F);
        menuPreference.setMnemonic(java.awt.event.KeyEvent.VK_P);
        menuWindow.setMnemonic(java.awt.event.KeyEvent.VK_W);
        menuHelp.setMnemonic(java.awt.event.KeyEvent.VK_H);

        menuFile.add(itemExit);
        menuWindow.add(itemFilter);
        menuWindow.add(itemAccount);
        menuWindow.add(itemShowLog);
        menuHelp.add(itemHelpDoc);
        menuHelp.addSeparator();
        menuHelp.add(itemAbout);

        menuLook = new JMenu("ルック&フィール(L)");
        menuLook.setMnemonic(java.awt.event.KeyEvent.VK_L);
        Enumeration<AbstractButton> landfButtons = landfGroup.getElements();
        while(landfButtons.hasMoreElements()){
            JMenuItem item = (JMenuItem)( landfButtons.nextElement() );
            menuLook.add(item);
        }

        menuPreference.add(itemFontSelect);
        menuPreference.addSeparator();
        menuPreference.add(menuLook);
        
        bar = new JMenuBar();
        bar.add(menuFile);
        bar.add(menuPreference);
        bar.add(menuWindow);
        bar.add(menuHelp);
         
        return bar;
    }
}
