/*
 * browser scroller 
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: JdfScroller.java 177 2008-09-09 16:16:07Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EmptyBorder;

/**
 * 内部ブラウザを内包するスクロールペイン。
 */
@SuppressWarnings("serial")
public class JdfScroller extends JScrollPane{

    private final Discussion browser;
    
    /**
     * 内部ブラウザを内包するスクロールペインを生成する。
     * @param period 日
     */
    public JdfScroller(Period period,
                        Font font,
                        FontRenderContext renderContext){
        super();
        
        this.browser = new Discussion(period, font, renderContext);
        this.browser.setBorder(new EmptyBorder(0, 0, 0, 0));
 
        JViewport viewPort = getViewport();
        viewPort.setBackground(Color.BLACK);
        viewPort.setView(this.browser);
        
        setHorizontalScrollBarPolicy(
                ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        setVerticalScrollBarPolicy(
                ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        
        return;
    }
    
    /**
     * フォント描画設定を変更する。
     * @param font フォント
     * @param renderContext フォント描画設定
     */
    public void setFontInfo(Font font, FontRenderContext renderContext){
        // TODO スクロール位置の復元
        this.browser.setFontInfo(font, renderContext);
        return;
    }
    
    /**
     * ビューポート内の内部ブラウザを返す。
     * @return 内部ブラウザ
     */
    public Discussion getDiscussion(){
        return this.browser;
    }
    
    /**
     * スクロール位置を返す。
     * @return スクロール位置
     */
    public int getVerticalPosition(){
        JScrollBar vt = getVerticalScrollBar();
        int pos = vt.getValue();
        return pos;
    }
    
    /**
     * スクロール位置を設定する。
     * @param pos スクロール位置
     */
    public void setVerticalPosition(int pos){
        JScrollBar vt = getVerticalScrollBar();
        vt.setValue(pos);
        return;
    }
}
