/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import jp.sourceforge.jindolf.Jindolf;

public class ActionManager {
    public static final String COMMAND_EXIT = "EXIT";
    public static final String COMMAND_ABOUT = "ABOUT";
    public static final String COMMAND_LANDF = "LANDF";
    public static final String COMMAND_HELPDOC = "HELPDOC";
    public static final String COMMAND_FILTER = "FILTER";
    public static final String COMMAND_ACCOUNT = "ACCOUNT";
    public static final String COMMAND_RELOAD = "RELOAD";
    public static final String COMMAND_COPY = "COPY";
    public static final String COMMAND_PRINT = "PRINT";
    public static final String COMMAND_SELALL = "SELALL";
    public static final String COMMAND_COPYTALK = "SELTALK";
    public static final String COMMAND_SWITCHORDER = "SWITCHORDER";
    public static final String COMMAND_VILLAGELIST = "VILLAGELIST";
    public static final String COMMAND_SHOWLOG = "SHOWLOG";
    public static final String COMMAND_FONTSELECT = "FONTSELECT";
    public static final String COMMAND_FONTSIZESEL = "FONTSIZESEL";
    public static final String COMMAND_FONTAPPLY = "FONTAPPLY";
    public static final String COMMAND_FONTCANCEL = "FONTCANCEL";
    public static final String COMMAND_SEARCHNEXT = "SEARCHNEXT";
    public static final String COMMAND_SEARCHPREV = "SEARCHPREV";
    public static final String COMMAND_SHOWFIND = "FIND";
    private Set<AbstractButton> items = new HashSet<AbstractButton>();
    private JMenuItem itemExit;
    private JMenuItem itemAbout;
    private JMenuItem itemHelpDoc;
    private JMenuItem itemFilter;
    private JMenuItem itemAccount;
    private JMenuItem itemShowLog;
    private JMenuItem itemFontSelect;
    private JMenuItem itemCopy;
    private JMenuItem itemFind;
    private ButtonGroup landfGroup = new ButtonGroup();
    private Map<ButtonModel, String> landfMap = new HashMap<ButtonModel, String>();

    public ActionManager() {
        this.itemExit = new JMenuItem("\u7d42\u4e86(X)");
        this.itemAbout = new JMenuItem(Jindolf.TITLE + "\u306b\u3064\u3044\u3066...(A)");
        this.itemHelpDoc = new JMenuItem("\u30d8\u30eb\u30d7\u8868\u793a(H)");
        this.itemFilter = new JMenuItem("\u767a\u8a00\u30d5\u30a3\u30eb\u30bf(F)");
        this.itemAccount = new JMenuItem("\u30a2\u30ab\u30a6\u30f3\u30c8\u7ba1\u7406(M)");
        this.itemShowLog = new JMenuItem("\u30ed\u30b0\u8868\u793a(S)");
        this.itemFontSelect = new JMenuItem("\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u9078\u629e...(F)");
        this.itemCopy = new JMenuItem("\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc(C)");
        this.itemFind = new JMenuItem("\u691c\u7d22...(F)");
        this.itemExit.setActionCommand(COMMAND_EXIT);
        this.itemAbout.setActionCommand(COMMAND_ABOUT);
        this.itemHelpDoc.setActionCommand(COMMAND_HELPDOC);
        this.itemFilter.setActionCommand(COMMAND_FILTER);
        this.itemAccount.setActionCommand(COMMAND_ACCOUNT);
        this.itemShowLog.setActionCommand(COMMAND_SHOWLOG);
        this.itemFontSelect.setActionCommand(COMMAND_FONTSELECT);
        this.itemCopy.setActionCommand(COMMAND_COPY);
        this.itemFind.setActionCommand(COMMAND_SHOWFIND);
        this.itemExit.setMnemonic(88);
        this.itemAbout.setMnemonic(65);
        this.itemHelpDoc.setMnemonic(72);
        this.itemFilter.setMnemonic(70);
        this.itemAccount.setMnemonic(77);
        this.itemShowLog.setMnemonic(83);
        this.itemFontSelect.setMnemonic(70);
        this.itemCopy.setMnemonic(67);
        this.itemFind.setMnemonic(70);
        this.items.add(this.itemExit);
        this.items.add(this.itemAbout);
        this.items.add(this.itemHelpDoc);
        this.items.add(this.itemFilter);
        this.items.add(this.itemAccount);
        this.items.add(this.itemShowLog);
        this.items.add(this.itemFontSelect);
        this.items.add(this.itemCopy);
        this.items.add(this.itemFind);
        this.createLookAndFeelMenuItems();
    }

    private void createLookAndFeelMenuItems() {
        UIManager.LookAndFeelInfo[] landfs;
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        String currentName = currentLookAndFeel.getClass().getName();
        AbstractButton matchedButton = null;
        for (UIManager.LookAndFeelInfo lafInfo : landfs = UIManager.getInstalledLookAndFeels()) {
            String name = lafInfo.getName();
            String className = lafInfo.getClassName();
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(name);
            button.setActionCommand(COMMAND_LANDF);
            if (className.equals(currentName)) {
                matchedButton = button;
            }
            this.items.add(button);
            this.landfGroup.add(button);
            this.landfMap.put(button.getModel(), className);
        }
        if (matchedButton != null) {
            matchedButton.setSelected(true);
        }
    }

    public String getSelectedLookAndFeel() {
        ButtonModel selected = this.landfGroup.getSelection();
        if (selected == null) {
            return null;
        }
        String className = this.landfMap.get(selected);
        return className;
    }

    public void addActionListener(ActionListener listener) {
        for (AbstractButton button : this.items) {
            button.addActionListener(listener);
        }
    }

    public JMenuBar createMenuBar() {
        JMenu menuFile = new JMenu("\u30d5\u30a1\u30a4\u30eb(F)");
        JMenu menuEdit = new JMenu("\u7de8\u96c6(E)");
        JMenu menuPreference = new JMenu("\u8a2d\u5b9a(P)");
        JMenu menuWindow = new JMenu("\u30a6\u30a3\u30f3\u30c9\u30a6(W)");
        JMenu menuHelp = new JMenu("\u30d8\u30eb\u30d7(H)");
        menuFile.setMnemonic(70);
        menuEdit.setMnemonic(69);
        menuPreference.setMnemonic(80);
        menuWindow.setMnemonic(87);
        menuHelp.setMnemonic(72);
        menuFile.add(this.itemExit);
        menuEdit.add(this.itemCopy);
        menuEdit.addSeparator();
        menuEdit.add(this.itemFind);
        menuWindow.add(this.itemFilter);
        menuWindow.add(this.itemAccount);
        menuWindow.add(this.itemShowLog);
        menuHelp.add(this.itemHelpDoc);
        menuHelp.addSeparator();
        menuHelp.add(this.itemAbout);
        JMenu menuLook = new JMenu("\u30eb\u30c3\u30af&\u30d5\u30a3\u30fc\u30eb(L)");
        menuLook.setMnemonic(76);
        Enumeration<AbstractButton> landfButtons = this.landfGroup.getElements();
        while (landfButtons.hasMoreElements()) {
            JMenuItem item = (JMenuItem)landfButtons.nextElement();
            menuLook.add(item);
        }
        menuPreference.add(this.itemFontSelect);
        menuPreference.addSeparator();
        menuPreference.add(menuLook);
        JMenuBar bar = new JMenuBar();
        bar.add(menuFile);
        bar.add(menuEdit);
        bar.add(menuPreference);
        bar.add(menuWindow);
        bar.add(menuHelp);
        return bar;
    }
}

