/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Avatar {
    private static final List<Avatar> predefinedAvatars = Collections.unmodifiableList(Arrays.asList(new Avatar("\u697d\u5929\u5bb6 \u30b2\u30eb\u30c8", 1), new Avatar("\u6751\u9577 \u30f4\u30a1\u30eb\u30bf\u30fc", 2), new Avatar("\u8001\u4eba \u30e2\u30fc\u30ea\u30c3\u30c4", 3), new Avatar("\u795e\u7236 \u30b8\u30e0\u30be\u30f3", 4), new Avatar("\u6728\u3053\u308a \u30c8\u30fc\u30de\u30b9", 5), new Avatar("\u65c5\u4eba \u30cb\u30b3\u30e9\u30b9", 6), new Avatar("\u306a\u3089\u305a\u8005 \u30c7\u30a3\u30fc\u30bf\u30fc", 7), new Avatar("\u5c11\u5e74 \u30da\u30fc\u30bf\u30fc", 8), new Avatar("\u5c11\u5973 \u30ea\u30fc\u30b6", 9), new Avatar("\u884c\u5546\u4eba \u30a2\u30eb\u30d3\u30f3", 10), new Avatar("\u7f8a\u98fc\u3044 \u30ab\u30bf\u30ea\u30ca", 11), new Avatar("\u30d1\u30f3\u5c4b \u30aa\u30c3\u30c8\u30fc", 12), new Avatar("\u9752\u5e74 \u30e8\u30a2\u30d2\u30e0", 13), new Avatar("\u6751\u5a18 \u30d1\u30e1\u30e9", 14), new Avatar("\u8fb2\u592b \u30e4\u30b3\u30d6", 15), new Avatar("\u5bbf\u5c4b\u306e\u5973\u4e3b\u4eba \u30ec\u30b8\u30fc\u30ca", 16), new Avatar("\u30b7\u30b9\u30bf\u30fc \u30d5\u30ea\u30fc\u30c7\u30eb", 17), new Avatar("\u4ed5\u7acb\u3066\u5c4b \u30a8\u30eb\u30ca", 18), new Avatar("\u53f8\u66f8 \u30af\u30e9\u30e9", 19), new Avatar("\u8ca0\u50b7\u5175 \u30b7\u30e2\u30f3", 20)));
    private static final Map<String, Avatar> avatarMap;
    private final String fullName;
    private final String jobTitle;
    private final String name;
    private final int idNum;

    public static List<Avatar> getPredefinedAvatars() {
        return predefinedAvatars;
    }

    public static Avatar getPredefinedAvatar(String fullName) {
        return avatarMap.get(fullName);
    }

    private Avatar(String fullName, int idNum) {
        if (fullName == null) {
            throw new NullPointerException();
        }
        this.fullName = fullName.intern();
        this.idNum = idNum;
        String[] tokens = this.fullName.split("\\p{Blank}+", 2);
        if (tokens.length == 1) {
            this.jobTitle = null;
            this.name = this.fullName;
        } else if (tokens.length == 2) {
            this.jobTitle = tokens[0].intern();
            this.name = tokens[1].intern();
        } else {
            this.jobTitle = null;
            this.name = null;
            assert (false);
        }
    }

    public Avatar(String fullName) {
        this(fullName, -1);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Avatar)) {
            return false;
        }
        Avatar other = (Avatar)obj;
        return this.fullName.equals(other.fullName);
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    static {
        HashMap<String, Avatar> map = new HashMap<String, Avatar>();
        for (Avatar avatar : predefinedAvatars) {
            String fullName = avatar.getFullName();
            map.put(fullName, avatar);
        }
        avatarMap = Collections.unmodifiableMap(map);
    }
}

