/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Container;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;
import jp.sourceforge.jindolf.AccountPanel;
import jp.sourceforge.jindolf.ActionManager;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.AnchorHitEvent;
import jp.sourceforge.jindolf.AnchorHitListener;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.Discussion;
import jp.sourceforge.jindolf.FilterPanel;
import jp.sourceforge.jindolf.FindPanel;
import jp.sourceforge.jindolf.FontChooser;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.JdfScroller;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.LandsModel;
import jp.sourceforge.jindolf.LandsTree;
import jp.sourceforge.jindolf.LogFrame;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.PileHandler;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.StringUtils;
import jp.sourceforge.jindolf.TabBrowser;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.TalkDraw;
import jp.sourceforge.jindolf.TopFrameView;
import jp.sourceforge.jindolf.Village;

public class Controller
implements ActionListener,
TreeWillExpandListener,
TreeSelectionListener,
ChangeListener,
AnchorHitListener {
    private static final String HELP_HTML = "resources/help.html";
    private ActionManager actionManager;
    private TopFrameView topFrame;
    private LandsModel model;
    private JFrame helpFrame;
    private FilterPanel filterFrame;
    private AccountPanel accountFrame;
    private LogFrame showlogFrame;
    private FontChooser fontChooser;
    private FindPanel findPanel;

    public Controller(ActionManager actionManager, TopFrameView topFrame, LandsModel model) {
        Handler[] handlers;
        this.actionManager = actionManager;
        this.topFrame = topFrame;
        this.model = model;
        this.actionManager.addActionListener(this);
        JTree treeView = this.topFrame.getTreeView();
        treeView.setModel(this.model);
        treeView.addTreeWillExpandListener(this);
        treeView.addTreeSelectionListener(this);
        this.topFrame.getTabBrowser().addChangeListener(this);
        this.topFrame.getTabBrowser().addActionListener(this);
        this.topFrame.getTabBrowser().addAnchorHitListener(this);
        this.topFrame.getReloadButton().addActionListener(this);
        this.topFrame.getShowFindButton().addActionListener(this);
        this.topFrame.getSearchNextButton().addActionListener(this);
        this.topFrame.getSearchPrevButton().addActionListener(this);
        JButton reloadVillageListButton = this.topFrame.getLandsTree().getReloadVillageListButton();
        reloadVillageListButton.addActionListener(this);
        reloadVillageListButton.setEnabled(false);
        this.filterFrame = new FilterPanel();
        this.filterFrame.addChangeListener(this);
        this.filterFrame.pack();
        this.filterFrame.setVisible(false);
        this.showlogFrame = new LogFrame();
        this.showlogFrame.pack();
        this.showlogFrame.setSize(600, 250);
        this.showlogFrame.setLocationByPlatform(true);
        this.showlogFrame.setVisible(false);
        Handler newHandler = this.showlogFrame.getHandler();
        Jindolf.logger.addHandler(newHandler);
        for (Handler handler : handlers = Jindolf.logger.getHandlers()) {
            if (!(handler instanceof PileHandler)) continue;
            PileHandler pile = (PileHandler)handler;
            pile.delegate(newHandler);
            pile.close();
        }
        this.fontChooser = new FontChooser(this.topFrame);
        this.fontChooser.pack();
        this.fontChooser.setSize(600, 500);
        this.fontChooser.setVisible(false);
        this.initFontChooser();
        this.topFrame.getTabBrowser().setFontInfo(this.fontChooser.getSelectedFont(), this.fontChooser.getFontRenderContext());
        this.findPanel = new FindPanel(this.topFrame);
        this.findPanel.pack();
        this.findPanel.setVisible(false);
    }

    private void initFontChooser() {
        FontRenderContext oldContext = this.fontChooser.getFontRenderContext();
        boolean isAntiAliased = oldContext.isAntiAliased();
        boolean usesFractionalMetrics = oldContext.usesFractionalMetrics();
        if (AppSetting.initfont != null) {
            Font newFont = Font.decode(AppSetting.initfont);
            if (!newFont.equals(this.fontChooser.getSelectedFont())) {
                this.fontChooser.setSelectedFont(newFont);
            }
            if (FontChooser.guessBitmapFont(newFont)) {
                isAntiAliased = false;
                usesFractionalMetrics = false;
            } else {
                isAntiAliased = true;
                usesFractionalMetrics = true;
            }
        }
        if (AppSetting.antialias != null) {
            isAntiAliased = AppSetting.antialias;
        }
        if (AppSetting.fractional != null) {
            usesFractionalMetrics = AppSetting.fractional;
        }
        FontRenderContext renderContext = new FontRenderContext(oldContext.getTransform(), isAntiAliased, usesFractionalMetrics);
        this.fontChooser.setFontRenderContext(renderContext);
    }

    private void actionAbout() {
        String message = Jindolf.TITLE + "   Version " + "2.9.4" + "\n" + Jindolf.COPYRIGHT + "\n" + "\u30e9\u30a4\u30bb\u30f3\u30b9: " + "The MIT License" + "\n" + "\u9023\u7d61\u5148: " + "http://jindolf.sourceforge.jp/";
        JOptionPane pane = new JOptionPane(message, 1, -1, GUIUtils.getLogoIcon());
        JDialog dialog = pane.createDialog(this.topFrame, Jindolf.TITLE + "\u306b\u3064\u3044\u3066");
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    private void actionExit() {
        Jindolf.exit(0);
    }

    private void actionHelp() {
        if (this.helpFrame != null) {
            this.toggleFrame(this.helpFrame);
            return;
        }
        this.helpFrame = new JFrame(Jindolf.TITLE + " \u30d8\u30eb\u30d7");
        this.helpFrame.setResizable(true);
        Toolkit kit = this.helpFrame.getToolkit();
        kit.setDynamicLayout(false);
        this.helpFrame.setIconImage(GUIUtils.getWindowIconImage());
        this.helpFrame.setLocationByPlatform(true);
        JEditorPane edit = new JEditorPane();
        edit.setEditable(false);
        edit.setContentType("text/html");
        edit.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        edit.setBorder(new EmptyBorder(0, 0, 0, 0));
        URL htmlurl = Jindolf.getResource(HELP_HTML);
        try {
            edit.setPage(htmlurl);
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "\u30d8\u30eb\u30d7\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093", e);
            this.helpFrame = null;
            return;
        }
        JScrollPane sc = new JScrollPane(edit);
        Container content = this.helpFrame.getContentPane();
        content.add(sc);
        this.helpFrame.pack();
        this.helpFrame.setSize(450, 450);
        this.helpFrame.setVisible(true);
    }

    private void actionChangeLaF() {
        LookAndFeel lnf;
        String className = this.actionManager.getSelectedLookAndFeel();
        try {
            Class<?> lnfClass = Class.forName(className);
            lnf = (LookAndFeel)lnfClass.newInstance();
        }
        catch (Exception e) {
            String message = "\u3053\u306eLook&Feel[" + className + "]\u3092\u8aad\u307f\u8fbc\u3080\u4e8b\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
            Jindolf.logger.log(Level.WARNING, message, e);
            JOptionPane.showMessageDialog(this.topFrame, message, "Look&Feel - " + Jindolf.TITLE, 2);
            return;
        }
        try {
            UIManager.setLookAndFeel(lnf);
        }
        catch (UnsupportedLookAndFeelException e) {
            String message = "\u3053\u306eLook&Feel[" + lnf.getName() + "]\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            Jindolf.logger.log(Level.WARNING, message, e);
            JOptionPane.showMessageDialog(this.topFrame, message, "Look&Feel - " + Jindolf.TITLE, 2);
            return;
        }
        Jindolf.logger.info("Look&Feel\u304c[" + lnf.getName() + "]\u306b\u5909\u66f4\u3055\u308c\u307e\u3057\u305f\u3002");
        final Runnable updateUITask = new Runnable(){

            public void run() {
                SwingUtilities.updateComponentTreeUI(Controller.this.topFrame);
                Controller.this.topFrame.validate();
                if (Controller.this.helpFrame != null) {
                    SwingUtilities.updateComponentTreeUI(Controller.this.helpFrame);
                    Controller.this.helpFrame.validate();
                }
                if (Controller.this.showlogFrame != null) {
                    SwingUtilities.updateComponentTreeUI(Controller.this.showlogFrame);
                    Controller.this.showlogFrame.validate();
                }
                if (Controller.this.filterFrame != null) {
                    SwingUtilities.updateComponentTreeUI(Controller.this.filterFrame);
                    Controller.this.filterFrame.validate();
                    Controller.this.filterFrame.pack();
                }
                if (Controller.this.accountFrame != null) {
                    SwingUtilities.updateComponentTreeUI(Controller.this.accountFrame);
                    Controller.this.accountFrame.validate();
                    Controller.this.accountFrame.pack();
                }
                if (Controller.this.fontChooser != null) {
                    SwingUtilities.updateComponentTreeUI(Controller.this.fontChooser);
                    Controller.this.fontChooser.validate();
                }
                if (Controller.this.findPanel != null) {
                    SwingUtilities.updateComponentTreeUI(Controller.this.findPanel);
                    Controller.this.findPanel.validate();
                    Controller.this.findPanel.pack();
                }
            }
        };
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setBusy(true);
                Controller.this.topFrame.updateSysMessage("Look&Feel\u3092\u66f4\u65b0\u4e2d\u2026");
                try {
                    SwingUtilities.invokeAndWait(updateUITask);
                }
                catch (Exception e) {
                    Jindolf.logger.log(Level.WARNING, "Look&Feel\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                }
                finally {
                    Controller.this.topFrame.updateSysMessage("Look&Feel\u304c\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f");
                    Controller.this.topFrame.setBusy(false);
                }
            }
        });
    }

    private void actionShowFilter() {
        this.toggleFrame(this.filterFrame);
    }

    private void actionShowAccount() {
        if (this.accountFrame != null) {
            this.toggleFrame(this.accountFrame);
            return;
        }
        this.accountFrame = new AccountPanel(this.model);
        this.accountFrame.pack();
        this.accountFrame.setVisible(true);
    }

    private void actionShowLog() {
        this.toggleFrame(this.showlogFrame);
    }

    private void actionShowFind() {
        this.findPanel.setVisible(true);
        if (this.findPanel.isCanceled()) {
            return;
        }
        if (this.findPanel.currentPattern() == null) {
            this.topFrame.updateSysMessage("\u6b63\u3057\u3044\u6b63\u898f\u8868\u73fe\u304c\u5f97\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f");
            return;
        }
        this.regexSearch();
    }

    private void actionFontSelect() {
        this.fontChooser.setVisible(true);
        if (this.fontChooser.isCanceled()) {
            return;
        }
        final Font newFont = this.fontChooser.getSelectedFont();
        final FontRenderContext newContext = this.fontChooser.getFontRenderContext();
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setBusy(true);
                Controller.this.topFrame.updateSysMessage("\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u3092\u5909\u66f4\u4e2d\u2026");
                try {
                    TabBrowser tabBrowser = Controller.this.topFrame.getTabBrowser();
                    tabBrowser.setFontInfo(newFont, newContext);
                }
                catch (Exception e) {
                    Jindolf.logger.log(Level.WARNING, "\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                }
                finally {
                    Controller.this.topFrame.updateSysMessage("\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u304c\u5909\u66f4\u3055\u308c\u307e\u3057\u305f");
                    Controller.this.topFrame.setBusy(false);
                }
            }
        });
    }

    private void regexSearch() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        Pattern searchRegex = this.currentPattern();
        discussion.setSearchRegex(searchRegex);
        int hits = discussion.highlightRegex();
        this.topFrame.updateSysMessage("\uff3b" + hits + "\uff3d\u4ef6\u30d2\u30c3\u30c8\u3057\u307e\u3057\u305f");
    }

    private void actionSearchNext() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.nextHotTarget();
    }

    private void actionSearchPrev() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.prevHotTarget();
    }

    private void actionReloadPeriod() {
        this.updatePeriod(true);
    }

    private void actionReloadVillageList() {
        JTree tree = this.topFrame.getTreeView();
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Land land = null;
        for (int ct = 0; ct < path.getPathCount(); ++ct) {
            Object obj = path.getPathComponent(ct);
            if (!(obj instanceof Land)) continue;
            land = (Land)obj;
            break;
        }
        if (land == null) {
            return;
        }
        this.topFrame.showInitPanel();
        this.execReloadVillageList(land);
    }

    private void actionCopySelected() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        CharSequence copied = discussion.copySelected();
        if (copied == null) {
            return;
        }
        copied = StringUtils.suppressString(copied);
        this.topFrame.updateSysMessage("[" + copied + "]\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f");
    }

    private void actionCopyTalk() {
        Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        CharSequence copied = discussion.copyTalk();
        if (copied == null) {
            return;
        }
        copied = StringUtils.suppressString(copied);
        this.topFrame.updateSysMessage("[" + copied + "]\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f");
    }

    private void execReloadVillageList(final Land land) {
        final LandsTree treePanel = this.topFrame.getLandsTree();
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setBusy(true);
                Controller.this.topFrame.updateSysMessage("\u6751\u4e00\u89a7\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                try {
                    try {
                        Controller.this.model.loadVillageList(land);
                    }
                    catch (IOException e) {
                        Controller.this.showNetworkError(land, e);
                    }
                    treePanel.expandLand(land);
                }
                finally {
                    Controller.this.topFrame.updateSysMessage("\u6751\u4e00\u89a7\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                    Controller.this.topFrame.setBusy(false);
                }
            }
        });
    }

    private Pattern currentPattern() {
        return this.findPanel.currentPattern();
    }

    private void updatePeriod(final boolean force) {
        final TabBrowser tabBrowser = this.topFrame.getTabBrowser();
        final Village village = tabBrowser.getVillage();
        if (village == null) {
            return;
        }
        this.topFrame.setFrameTitle(village.getVillageName());
        final JdfScroller scroller = this.currentJdfScroller();
        final Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.setTopicFilter(this.filterFrame);
        final Period period = discussion.getPeriod();
        if (period == null) {
            return;
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setBusy(true);
                try {
                    boolean wasHot = this.loadPeriod();
                    if (wasHot && !period.isHot() && !this.updatePeriodList()) {
                        return;
                    }
                    this.renderBrowser();
                }
                finally {
                    Controller.this.topFrame.setBusy(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean loadPeriod() {
                boolean wasHot;
                Controller.this.topFrame.updateSysMessage("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u8fbc\u3093\u3067\u3044\u307e\u3059\u2026");
                try {
                    wasHot = period.isHot();
                    try {
                        period.loadPeriod(force);
                    }
                    catch (IOException e) {
                        Controller.this.showNetworkError(village, e);
                    }
                }
                finally {
                    Controller.this.topFrame.updateSysMessage("1\u65e5\u5206\u306e\u30c7\u30fc\u30bf\u3092\u8aad\u307f\u7d42\u308f\u308a\u307e\u3057\u305f");
                }
                return wasHot;
            }

            private boolean updatePeriodList() {
                Controller.this.topFrame.updateSysMessage("\u6751\u60c5\u5831\u3092\u8aad\u307f\u76f4\u3057\u3066\u3044\u307e\u3059\u2026");
                try {
                    village.updatePeriodList();
                }
                catch (IOException e) {
                    Controller.this.showNetworkError(village, e);
                    return false;
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            tabBrowser.setVillage(village);
                        }
                    });
                }
                catch (Exception e) {
                    Jindolf.logger.log(Level.SEVERE, "\u30bf\u30d6\u64cd\u4f5c\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                }
                Controller.this.topFrame.updateSysMessage("\u6751\u60c5\u5831\u3092\u8aad\u307f\u76f4\u3057\u307e\u3057\u305f\u2026");
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void renderBrowser() {
                Controller.this.topFrame.updateSysMessage("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u4e2d\u2026");
                try {
                    final int lastPos = scroller.getVerticalPosition();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                discussion.showTopics(force);
                            }
                        });
                    }
                    catch (Exception e) {
                        Jindolf.logger.log(Level.SEVERE, "\u30d6\u30e9\u30a6\u30b6\u8868\u793a\u3067\u81f4\u547d\u7684\u306a\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            scroller.setVerticalPosition(lastPos);
                        }
                    });
                }
                finally {
                    Controller.this.topFrame.updateSysMessage("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u5b8c\u4e86");
                }
            }
        });
    }

    private void filterChanged() {
        final Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        discussion.setTopicFilter(this.filterFrame);
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setBusy(true);
                Controller.this.topFrame.updateSysMessage("\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u4e2d\u2026");
                try {
                    discussion.filtering();
                }
                finally {
                    Controller.this.topFrame.updateSysMessage("\u30d5\u30a3\u30eb\u30bf\u30ea\u30f3\u30b0\u5b8c\u4e86");
                    Controller.this.topFrame.setBusy(false);
                }
            }
        });
    }

    private JdfScroller currentJdfScroller() {
        TabBrowser tb = this.topFrame.getTabBrowser();
        JdfScroller result = tb.currentJdfScroller();
        return result;
    }

    private Discussion currentDiscussion() {
        JdfScroller scroller = this.currentJdfScroller();
        if (scroller == null) {
            return null;
        }
        Discussion result = scroller.getDiscussion();
        return result;
    }

    private void toggleFrame(JFrame frame) {
        if (frame == null) {
            return;
        }
        if (frame.isVisible()) {
            frame.setVisible(false);
            frame.dispose();
        } else {
            frame.setVisible(true);
        }
    }

    public void showNetworkError(Village village, IOException e) {
        Land land = village.getParentLand();
        this.showNetworkError(land, e);
    }

    public void showNetworkError(Land land, IOException e) {
        Jindolf.logger.log(Level.WARNING, "\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u3067\u969c\u5bb3\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        ServerAccess server = land.getServerAccess();
        String message = land.getLandName() + "\u3092\u904b\u55b6\u3059\u308b\u30b5\u30fc\u30d0\u3068\u306e\u9593\u306e\u901a\u4fe1\u3067" + "\u4f55\u3089\u304b\u306e\u30c8\u30e9\u30d6\u30eb\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n" + "\u76f8\u624b\u30b5\u30fc\u30d0\u306eURL\u306f [ " + server.getBaseURL() + " ] \u3060\u3088\u3002\n" + "Web\u30d6\u30e9\u30a6\u30b6\u3067\u3082\u904a\u3079\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u307f\u3066\u306d!\n";
        JOptionPane pane = new JOptionPane(message, 2, -1);
        JDialog dialog = pane.createDialog(this.topFrame, "\u901a\u4fe1\u7570\u5e38\u767a\u751f - " + Jindolf.TITLE);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath path = event.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        Object selObj = path.getLastPathComponent();
        if (selObj instanceof Land) {
            Land land = (Land)selObj;
            this.topFrame.showLandInfo(land);
        } else if (selObj instanceof Village) {
            final Village village = (Village)selObj;
            ExecutorService executor = Executors.newCachedThreadPool();
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Controller.this.topFrame.setBusy(true);
                    Controller.this.topFrame.updateSysMessage("\u6751\u60c5\u5831\u3092\u8aad\u307f\u8fbc\u307f\u4e2d\u2026");
                    try {
                        village.updatePeriodList();
                    }
                    catch (IOException e) {
                        Controller.this.showNetworkError(village, e);
                        return;
                    }
                    finally {
                        Controller.this.topFrame.updateSysMessage("\u6751\u60c5\u5831\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86");
                        Controller.this.topFrame.setBusy(false);
                    }
                    Controller.this.topFrame.showVillageInfo(village);
                }
            });
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source == this.filterFrame) {
            this.filterChanged();
        } else if (source instanceof TabBrowser) {
            Discussion discussion = this.currentDiscussion();
            if (discussion == null) {
                return;
            }
            Pattern searchRegex = this.currentPattern();
            discussion.setSearchRegex(searchRegex);
            this.updatePeriod(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ABOUT")) {
            this.actionAbout();
        } else if (cmd.equals("EXIT")) {
            this.actionExit();
        } else if (cmd.equals("HELPDOC")) {
            this.actionHelp();
        } else if (cmd.equals("LANDF")) {
            this.actionChangeLaF();
        } else if (cmd.equals("FILTER")) {
            this.actionShowFilter();
        } else if (cmd.equals("ACCOUNT")) {
            this.actionShowAccount();
        } else if (cmd.equals("SHOWLOG")) {
            this.actionShowLog();
        } else if (cmd.equals("FONTSELECT")) {
            this.actionFontSelect();
        } else if (cmd.equals("RELOAD")) {
            this.actionReloadPeriod();
        } else if (cmd.equals("VILLAGELIST")) {
            this.actionReloadVillageList();
        } else if (cmd.equals("COPY")) {
            this.actionCopySelected();
        } else if (cmd.equals("SELTALK")) {
            this.actionCopyTalk();
        } else if (cmd.equals("SEARCHNEXT")) {
            this.actionSearchNext();
        } else if (cmd.equals("SEARCHPREV")) {
            this.actionSearchPrev();
        } else if (cmd.equals("FIND")) {
            this.actionShowFind();
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) {
    }

    public void treeWillExpand(TreeExpansionEvent event) {
        if (!(event.getSource() instanceof JTree)) {
            return;
        }
        TreePath path = event.getPath();
        Object lastObj = path.getLastPathComponent();
        if (!(lastObj instanceof Land)) {
            return;
        }
        Land land = (Land)lastObj;
        if (land.getVillageCount() > 0) {
            return;
        }
        this.execReloadVillageList(land);
    }

    public void anchorHitted(AnchorHitEvent event) {
        final Discussion discussion = this.currentDiscussion();
        if (discussion == null) {
            return;
        }
        Period period = discussion.getPeriod();
        if (period == null) {
            return;
        }
        final Village village = period.getVillage();
        final TalkDraw talkDraw = event.getTalkDraw();
        final Anchor anchor = event.getAnchor();
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Controller.this.topFrame.setBusy(true);
                Controller.this.topFrame.updateSysMessage("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u2026");
                try {
                    final List<Talk> talkList = village.getTalkListFromAnchor(anchor);
                    if (talkList.size() <= 0) {
                        Controller.this.topFrame.updateSysMessage("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u5148[" + anchor.toString() + "]\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            talkDraw.showAnchorTalks(anchor, talkList);
                            discussion.layoutRows();
                        }
                    });
                    Controller.this.topFrame.updateSysMessage("\u30a2\u30f3\u30ab\u30fc[" + anchor.toString() + "]\u306e\u5c55\u958b\u5b8c\u4e86");
                }
                catch (IOException e) {
                    Controller.this.topFrame.updateSysMessage("\u30a2\u30f3\u30ab\u30fc\u306e\u5c55\u958b\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u8d77\u304d\u307e\u3057\u305f");
                }
                finally {
                    Controller.this.topFrame.setBusy(false);
                }
            }
        });
    }
}

