/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import jp.sourceforge.jindolf.Jindolf;

public class FindPanel
extends JDialog
implements ActionListener,
WindowListener {
    private static final String FRAMETITLE = "\u767a\u8a00\u691c\u7d22 - " + Jindolf.TITLE;
    private final JComboBox findBox = new JComboBox();
    private final JButton searchButton = new JButton("\u691c\u7d22");
    private final JCheckBox capitalSwitch = new JCheckBox("\u5927\u6587\u5b57/\u5c0f\u6587\u5b57\u3092\u533a\u5225\u3059\u308b");
    private final JCheckBox dotallSwitch = new JCheckBox("\u6b63\u898f\u8868\u73fe \".\" \u304c\u884c\u672b\u8a18\u53f7\u306b\u3082\u30de\u30c3\u30c1\u3059\u308b");
    private final JCheckBox multilineSwitch = new JCheckBox("\u6b63\u898f\u8868\u73fe \"^\" \u3084 \"$\" \u304c\u884c\u672b\u8a18\u53f7\u306e\u524d\u5f8c\u306b\u53cd\u5fdc\u3059\u308b");
    private final JButton closeButton = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
    private boolean isCanceled = false;

    public FindPanel(Frame owner) {
        super(owner, FRAMETITLE, true);
        this.setResizable(true);
        Toolkit kit = this.getToolkit();
        kit.setDynamicLayout(false);
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.findBox.setToolTipText("\u691c\u7d22\u6587\u5b57\u5217\u3092\u6b63\u898f\u8868\u73fe\u3067\u5165\u529b\u3057\u3066\u306d");
        this.findBox.setEditable(true);
        this.findBox.addItem("");
        this.findBox.addItem("\u3010[^\u3011]*\u3011");
        this.findBox.addItem("[\u25a0\u25cf\u25bc\u2605\u25a1\u25cb\u25bd\u2606\u3007\u25ef\u2207]");
        this.findBox.addItem("(J|j)indolf");
        this.searchButton.setToolTipText("\u767a\u8a00\u5185\u5bb9\u3092\u691c\u7d22\u3059\u308b");
        this.capitalSwitch.setSelected(true);
        this.dotallSwitch.setSelected(true);
        this.multilineSwitch.setSelected(false);
        this.searchButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.design();
    }

    private void design() {
        Container content = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.weightx = 1.0;
        constraints.fill = 2;
        TitledBorder border = BorderFactory.createTitledBorder("\u6b63\u898f\u8868\u73fe\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.findBox, "Center");
        panel.setBorder(border);
        content.add((Component)panel, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.gridwidth = 0;
        content.add((Component)this.searchButton, constraints);
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        content.add((Component)this.capitalSwitch, constraints);
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        content.add((Component)this.dotallSwitch, constraints);
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        content.add((Component)this.multilineSwitch, constraints);
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        content.add((Component)new JSeparator(), constraints);
        constraints.weightx = 0.0;
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        constraints.fill = 0;
        content.add((Component)this.closeButton, constraints);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    private void actionCancel() {
        this.isCanceled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void actionSubmit() {
        this.isCanceled = false;
        this.setVisible(false);
        this.dispose();
    }

    public Pattern currentPattern() {
        Pattern pattern;
        Object selected = this.findBox.getSelectedItem();
        if (selected == null) {
            return null;
        }
        String searchString = selected.toString();
        if (searchString.length() <= 0) {
            return null;
        }
        int flag = 0;
        if (!this.capitalSwitch.isSelected()) {
            flag |= 0x40;
            flag |= 2;
        }
        if (this.dotallSwitch.isSelected()) {
            flag |= 0x20;
        }
        if (this.multilineSwitch.isSelected()) {
            flag |= 8;
        }
        try {
            pattern = Pattern.compile(searchString, flag);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        return pattern;
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.actionCancel();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.closeButton) {
            this.actionCancel();
        } else if (source == this.searchButton) {
            this.actionSubmit();
        }
    }
}

