/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.RowsLtoR;
import jp.sourceforge.jindolf.SysEvent;

public class SysEventDraw
implements RowsLtoR {
    public static final Color COLOR_ANNOUNCE = new Color(0xFFFFFF);
    public static final Color COLOR_ORDER = new Color(0xF04040);
    public static final Color COLOR_EXTRA = new Color(0x808080);
    private static final int INSET = 10;
    private static final int UNDER_MARGIN = 15;
    private final Rectangle bounds = new Rectangle();
    private final SysEvent sysEvent;
    private final GlyphDraw sysMessage;

    public SysEventDraw(SysEvent sysEvent, Font font, FontRenderContext frc) {
        this.sysEvent = sysEvent;
        this.sysMessage = new GlyphDraw(font, frc, this.sysEvent.getMessage());
        this.sysMessage.setColor(this.getEventColor());
    }

    public SysEvent getSysEvent() {
        return this.sysEvent;
    }

    protected Color getEventColor() {
        Color result;
        switch (this.sysEvent.getEventClass()) {
            case ANNOUNCE: {
                result = COLOR_ANNOUNCE;
                break;
            }
            case ORDER: {
                result = COLOR_ORDER;
                break;
            }
            case EXTRA: {
                result = COLOR_EXTRA;
                break;
            }
            default: {
                assert (false);
                result = null;
            }
        }
        return result;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public void setPos(int xPos, int yPos) {
        this.bounds.x = xPos;
        this.bounds.y = yPos;
    }

    public Rectangle setWidth(int newWidth) {
        Rectangle child = this.sysMessage.setWidth(newWidth - 10 - 10);
        this.bounds.width = newWidth;
        this.bounds.height = child.height + 10 + 10 + 15;
        return this.bounds;
    }

    public void setFontInfo(Font font, FontRenderContext frc) {
        this.sysMessage.setFontInfo(font, frc);
        int width = this.getWidth();
        this.setWidth(width);
    }

    public void drag(Point from, Point to) {
        this.sysMessage.drag(from, to);
    }

    public Appendable appendSelected(Appendable appendable) throws IOException {
        this.sysMessage.appendSelected(appendable);
        return appendable;
    }

    public void clearSelect() {
        this.sysMessage.clearSelect();
    }

    public void paint(Graphics2D g) {
        g.setColor(this.getEventColor());
        g.drawRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height - 15);
        this.sysMessage.setPos(this.bounds.x + 10, this.bounds.y + 10);
        this.sysMessage.paint(g);
    }
}

