/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.AnchorDraw;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.RowsLtoR;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TalkDraw
implements RowsLtoR {
    public static final Color COLOR_PUBLIC = new Color(0xFFFFFF);
    public static final Color COLOR_WOLFONLY = new Color(0xFF7777);
    public static final Color COLOR_PRIVATE = new Color(0x939393);
    public static final Color COLOR_GRAVE = new Color(10467279);
    private static final int BALOONTIP_WIDTH = 16;
    private static final int BALOONTIP_HEIGHT = 8;
    private static final int UNDER_MARGIN = 15;
    private static final int OFFSET_ANCHOR = 36;
    private static Color COLOR_TRANS = new Color(0, 0, 0, 0);
    private static int BALOON_R = 10;
    private static BufferedImage BALOON_PUBLIC;
    private static BufferedImage BALOON_WOLFONLY;
    private static BufferedImage BALOON_GRAVE;
    private static BufferedImage BALOON_PRIVATE;
    private static float ANCHOR_FONT_RATIO;
    private final Talk talk;
    private Anchor showingAnchor;
    private GlyphDraw caption;
    private GlyphDraw dialog;
    private List<AnchorDraw> anchorTalks = new LinkedList<AnchorDraw>();
    private Image faceImage;
    private Point imageOrigin;
    private Point dialogOrigin;
    private Point tipOrigin;
    private final Rectangle bounds = new Rectangle();
    private Font font;
    private Font anchorFont;
    private FontRenderContext frc;

    private static BufferedImage createWedgeImage(Color color) {
        BufferedImage image = new BufferedImage(16, 8, 2);
        Graphics2D g2 = image.createGraphics();
        RenderingHints renderHints = GUIUtils.getQualityHints();
        g2.addRenderingHints(renderHints);
        g2.setColor(COLOR_TRANS);
        g2.fillRect(0, 0, 16, 8);
        g2.setColor(color);
        Polygon poly = new Polygon();
        poly.addPoint(8, 8);
        poly.addPoint(16, 8);
        poly.addPoint(16, 0);
        g2.fillPolygon(poly);
        return image;
    }

    private static BufferedImage createBubbleImage(Color color) {
        BufferedImage image = new BufferedImage(16, 8, 2);
        Graphics2D g2 = image.createGraphics();
        RenderingHints renderHints = GUIUtils.getQualityHints();
        g2.addRenderingHints(renderHints);
        g2.setColor(COLOR_TRANS);
        g2.fillRect(0, 0, 16, 8);
        g2.setColor(color);
        g2.fillOval(2, 4, 4, 4);
        g2.fillOval(8, 2, 6, 6);
        return image;
    }

    private static Font getAnchorFont(Font font) {
        float fontSize = font.getSize2D();
        float newSize = fontSize * ANCHOR_FONT_RATIO;
        return font.deriveFont(newSize);
    }

    public TalkDraw(Talk talk, Font font, FontRenderContext frc) {
        this.talk = talk;
        this.font = font;
        this.frc = frc;
        this.anchorFont = TalkDraw.getAnchorFont(this.font);
        Village village = this.talk.getPeriod().getVillage();
        Avatar avatar = this.talk.getAvatar();
        Image image = talk.getTalkType() == Talk.Type.GRAVE ? village.getGraveImage() : village.getAvatarFaceImage(avatar);
        this.faceImage = image;
        this.caption = new GlyphDraw(this.font, this.frc, this.getCaptionString());
        this.dialog = new GlyphDraw(this.font, this.frc, this.talk.getDialog());
        this.caption.setColor(Color.WHITE);
        this.dialog.setColor(Color.BLACK);
        Period period = this.talk.getPeriod();
        List<Anchor> anchorList = Anchor.getAnchorList(this.talk.getDialog(), period.getDay());
        this.dialog.setAnchorSet(anchorList);
    }

    public Talk getTalk() {
        return this.talk;
    }

    private CharSequence getCaptionString() {
        int charNum;
        StringBuilder result = new StringBuilder();
        Avatar avatar = this.talk.getAvatar();
        result.append(avatar.getFullName()).append(' ');
        int hour = this.talk.getHour();
        if (hour <= 11) {
            result.append("\u5348\u524d ").append(hour);
        } else {
            result.append("\u5348\u5f8c ").append(hour - 12);
        }
        result.append("\u6642").append(' ');
        int minute = this.talk.getMinute();
        result.append(minute).append("\u5206").append(' ');
        result.append(this.talk.getAnchorNotation()).append('\n');
        DateFormat dform = DateFormat.getDateTimeInstance(2, 2);
        long epoch = this.talk.getTimeFromID();
        String decoded = dform.format(epoch);
        result.append(decoded);
        int count = this.talk.getTalkCount();
        if (count > 0) {
            Talk.Type type = this.talk.getTalkType();
            result.append(" (").append(Talk.encodeColorName(type));
            result.append('#').append(count).append(')');
        }
        if ((charNum = this.talk.getTotalChars()) > 0) {
            result.append(' ').append(charNum).append('\u5b57');
        }
        return result;
    }

    protected Color getTalkColor() {
        Color result;
        switch (this.talk.getTalkType()) {
            case PUBLIC: {
                result = COLOR_PUBLIC;
                break;
            }
            case WOLFONLY: {
                result = COLOR_WOLFONLY;
                break;
            }
            case PRIVATE: {
                result = COLOR_PRIVATE;
                break;
            }
            case GRAVE: {
                result = COLOR_GRAVE;
                break;
            }
            default: {
                assert (false);
                result = null;
            }
        }
        return result;
    }

    @Override
    public Rectangle setWidth(int newWidth) {
        int imageWidth = this.faceImage.getWidth(null);
        int imageHeight = this.faceImage.getHeight(null);
        int tipWidth = BALOON_WOLFONLY.getWidth();
        int minWidth = imageWidth + tipWidth + BALOON_R * 2;
        if (newWidth < minWidth) {
            newWidth = minWidth;
        }
        this.caption.setWidth(newWidth);
        int captionWidth = this.caption.getWidth();
        int captionHeight = this.caption.getHeight();
        this.dialog.setWidth(newWidth - minWidth);
        int dialogWidth = this.dialog.getWidth();
        int dialogHeight = this.dialog.getHeight();
        int baloonWidth = dialogWidth + BALOON_R * 2;
        int baloonHeight = dialogHeight + BALOON_R * 2;
        int imageAndDialogWidth = imageWidth + tipWidth + baloonWidth;
        int totalWidth = Math.max(captionWidth, imageAndDialogWidth);
        int totalHeight = captionHeight;
        totalHeight += Math.max(imageHeight, baloonHeight);
        int imageYpos = captionHeight;
        int dialogYpos = captionHeight;
        int tipYpos = captionHeight;
        if (imageHeight < baloonHeight) {
            imageYpos += (baloonHeight - imageHeight) / 2;
            tipYpos += (baloonHeight - BALOON_WOLFONLY.getHeight()) / 2;
            dialogYpos += BALOON_R;
        } else {
            dialogYpos += (imageHeight - baloonHeight) / 2 + BALOON_R;
            tipYpos += (imageHeight - BALOON_WOLFONLY.getHeight()) / 2;
        }
        this.imageOrigin = new Point(0, imageYpos);
        this.caption.setPos(this.bounds.x + 0, this.bounds.y + 0);
        this.dialogOrigin = new Point(imageWidth + tipWidth + BALOON_R, dialogYpos);
        this.dialog.setPos(this.bounds.x + imageWidth + tipWidth + BALOON_R, this.bounds.y + dialogYpos);
        this.tipOrigin = new Point(imageWidth, tipYpos);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.setWidth(newWidth - 36);
            totalHeight += anchorDraw.getHeight();
        }
        this.bounds.width = totalWidth;
        this.bounds.height = totalHeight + 15;
        return this.bounds;
    }

    @Override
    public void paint(Graphics2D g) {
        BufferedImage tip;
        int xPos = this.bounds.x;
        int yPos = this.bounds.y;
        this.caption.paint(g);
        g.drawImage(this.faceImage, xPos + this.imageOrigin.x, yPos + this.imageOrigin.y, null);
        switch (this.talk.getTalkType()) {
            case WOLFONLY: {
                tip = BALOON_WOLFONLY;
                break;
            }
            case PUBLIC: {
                tip = BALOON_PUBLIC;
                break;
            }
            case GRAVE: {
                tip = BALOON_GRAVE;
                break;
            }
            case PRIVATE: {
                tip = BALOON_PRIVATE;
                break;
            }
            default: {
                tip = null;
                assert (false);
                break;
            }
        }
        g.drawImage((Image)tip, xPos + this.tipOrigin.x, yPos + this.tipOrigin.y, null);
        int baloonWidth = this.dialog.getWidth() + BALOON_R * 2;
        int baloonHeight = this.dialog.getHeight() + BALOON_R * 2;
        g.setColor(this.getTalkColor());
        g.fillRoundRect(xPos + this.dialogOrigin.x - BALOON_R, yPos + this.dialogOrigin.y - BALOON_R, baloonWidth, baloonHeight, BALOON_R, BALOON_R);
        this.dialog.paint(g);
        int anchorX = xPos + 36;
        int anchorY = yPos + this.dialogOrigin.y + baloonHeight;
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.setPos(anchorX, anchorY);
            anchorDraw.paint(g);
            anchorY += anchorDraw.getHeight();
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setPos(int xPos, int yPos) {
        this.bounds.x = xPos;
        this.bounds.y = yPos;
    }

    @Override
    public int getWidth() {
        return this.bounds.width;
    }

    @Override
    public int getHeight() {
        return this.bounds.height;
    }

    @Override
    public void setFontInfo(Font font, FontRenderContext frc) {
        this.font = font;
        this.frc = frc;
        this.anchorFont = TalkDraw.getAnchorFont(this.font);
        this.caption.setFontInfo(this.font, this.frc);
        this.dialog.setFontInfo(this.font, this.frc);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.setFontInfo(this.anchorFont, this.frc);
        }
        int width = this.getWidth();
        this.setWidth(width);
    }

    @Override
    public void drag(Point from, Point to) {
        this.caption.drag(from, to);
        this.dialog.drag(from, to);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.drag(from, to);
        }
    }

    @Override
    public Appendable appendSelected(Appendable appendable) throws IOException {
        this.caption.appendSelected(appendable);
        this.dialog.appendSelected(appendable);
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.appendSelected(appendable);
        }
        return appendable;
    }

    @Override
    public void clearSelect() {
        this.caption.clearSelect();
        this.dialog.clearSelect();
        for (AnchorDraw anchorDraw : this.anchorTalks) {
            anchorDraw.clearSelect();
        }
    }

    public Anchor getAnchor(Point pt) {
        Anchor result = this.dialog.getAnchor(pt);
        return result;
    }

    public void showAnchorTalks(Anchor anchor, List<Talk> talkList) {
        if (anchor == null || this.showingAnchor == anchor) {
            this.showingAnchor = null;
            this.anchorTalks.clear();
            int width = this.getWidth();
            this.setWidth(width);
            return;
        }
        this.showingAnchor = anchor;
        this.anchorTalks.clear();
        for (Talk anchorTalk : talkList) {
            AnchorDraw anchorDraw = new AnchorDraw(anchorTalk, this.anchorFont, this.frc);
            anchorDraw.setFontInfo(this.anchorFont, this.frc);
            this.anchorTalks.add(anchorDraw);
        }
        int width = this.getWidth();
        this.setWidth(width);
    }

    public int setRegex(Pattern searchRegex) {
        int total = 0;
        return total += this.dialog.setRegex(searchRegex);
    }

    public int getHotTargetIndex() {
        return this.dialog.getHotTargetIndex();
    }

    public void setHotTargetIndex(int index) {
        this.dialog.setHotTargetIndex(index);
    }

    public int getRegexMatches() {
        return this.dialog.getRegexMatches();
    }

    public void clearHotTarget() {
        this.dialog.clearHotTarget();
    }

    public Rectangle getHotTargetRectangle() {
        return this.dialog.getHotTargetRectangle();
    }

    static {
        ANCHOR_FONT_RATIO = 0.9f;
        BALOON_PUBLIC = TalkDraw.createWedgeImage(COLOR_PUBLIC);
        BALOON_WOLFONLY = TalkDraw.createBubbleImage(COLOR_WOLFONLY);
        BALOON_PRIVATE = TalkDraw.createBubbleImage(COLOR_PRIVATE);
        BALOON_GRAVE = TalkDraw.createBubbleImage(COLOR_GRAVE);
    }
}

