/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Image;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Village
implements Comparable<Village> {
    private static final Comparator<Village> vComparator = new VillageComparator();
    private static final Pattern anchorRegex;
    private static final Pattern titleRegex;
    private static final Pattern villageInfoRegex;
    private final Land parentLand;
    private final String villageID;
    private final int villageIDNum;
    private String villageName;
    private State state = State.UNKNOWN;
    private LinkedList<Period> periodList = new LinkedList();
    private List<Period> unmodList = Collections.unmodifiableList(this.periodList);
    private Image tombImage = null;
    private Map<String, Avatar> avatarMap = new HashMap<String, Avatar>();
    private Map<Avatar, Image> faceImageMap = new HashMap<Avatar, Image>();

    public static Comparator<Village> comparator() {
        return vComparator;
    }

    public Village(Land parentLand, String villageID, String villageName) {
        this.parentLand = parentLand;
        this.villageID = villageID.intern();
        this.villageIDNum = Integer.parseInt(this.villageID);
        this.villageName = villageName.intern();
    }

    public Land getParentLand() {
        return this.parentLand;
    }

    public String getVillageID() {
        return this.villageID;
    }

    public int getVillageIDNum() {
        return this.villageIDNum;
    }

    public String getVillageName() {
        return this.villageName;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Period getPrologue() {
        for (Period period : this.periodList) {
            if (!period.isPrologue()) continue;
            return period;
        }
        return null;
    }

    public Period getEpilogue() {
        for (Period period : this.periodList) {
            if (!period.isEpilogue()) continue;
            return period;
        }
        return null;
    }

    public Period getProgress(int day) {
        for (Period period : this.periodList) {
            if (!period.isProgress() || period.getDay() != day) continue;
            return period;
        }
        return null;
    }

    public int getProgressDays() {
        int result = 0;
        for (Period period : this.periodList) {
            if (!period.isProgress()) continue;
            ++result;
        }
        return result;
    }

    public Period getPeriod(int day) {
        return this.periodList.get(day);
    }

    public int getPeriodSize() {
        return this.periodList.size();
    }

    public List<Period> getPeriodList() {
        return this.unmodList;
    }

    public Avatar getAvatar(String fullName) {
        Avatar avatar = Avatar.getPredefinedAvatar(fullName);
        if (avatar != null) {
            return avatar;
        }
        avatar = this.avatarMap.get(fullName);
        if (avatar != null) {
            return avatar;
        }
        return null;
    }

    public void addAvatar(Avatar avatar) {
        if (avatar == null) {
            return;
        }
        String fullName = avatar.getFullName();
        this.avatarMap.put(fullName, avatar);
    }

    public void putAvatarFaceImage(Avatar avatar, Image faceImage) {
        this.faceImageMap.put(avatar, faceImage);
    }

    public Image getAvatarFaceImage(Avatar avatar) {
        return this.faceImageMap.get(avatar);
    }

    public Image getGraveImage() {
        return this.tombImage;
    }

    public void setGraveImage(Image image) throws NullPointerException {
        if (image == null) {
            throw new NullPointerException();
        }
        this.tombImage = image;
    }

    public CharSequence getCGIQuery() {
        StringBuilder result = new StringBuilder();
        result.append("?vid=").append(this.getVillageID());
        return result;
    }

    public void updatePeriodList() throws IOException {
        CharSequence html = null;
        Land land = this.getParentLand();
        ServerAccess server = land.getServerAccess();
        html = land.getType() == Land.Type.ACTIVE ? server.getHTMLBoneHead(this) : server.getHTMLVillage(this);
        this.parseTitle(html);
        this.updatePeriodList(html);
    }

    private void updatePeriodList(CharSequence html) {
        boolean hasPrologue = false;
        boolean hasEpilogue = false;
        boolean hasProgress = false;
        boolean hasDone = false;
        int maxProgress = 0;
        Matcher matcher = anchorRegex.matcher(html);
        while (matcher.find()) {
            String hrefValue = matcher.group(1);
            String anchorText = matcher.group(2);
            String dayString = matcher.group(3);
            if (anchorText.equals("\u30d7\u30ed\u30ed\u30fc\u30b0")) {
                hasPrologue = true;
                continue;
            }
            if (anchorText.endsWith("\u65e5\u76ee")) {
                int day;
                hasProgress = true;
                maxProgress = day = Integer.parseInt(dayString);
                continue;
            }
            if (anchorText.equals("\u30a8\u30d4\u30ed\u30fc\u30b0")) {
                hasEpilogue = true;
                continue;
            }
            if (!anchorText.equals("\u7d42\u4e86")) continue;
            hasDone = true;
            break;
        }
        if (this.getParentLand().getType() != Land.Type.ACTIVE) {
            this.setState(State.GAMEOVER);
        } else if (hasDone) {
            this.setState(State.GAMEOVER);
        } else if (hasEpilogue) {
            this.setState(State.EPILOGUE);
        } else if (hasProgress) {
            this.setState(State.PROGRESS);
        } else if (hasPrologue) {
            this.setState(State.PROLOGUE);
        } else {
            this.setState(State.UNKNOWN);
            this.periodList.clear();
            assert (false);
            return;
        }
        Period lastPeriod = null;
        if (hasPrologue) {
            Period prologue = this.getPrologue();
            if (prologue == null) {
                lastPeriod = new Period(this, Period.Type.PROLOGUE, 0);
                this.setPeriod(0, lastPeriod);
            } else {
                lastPeriod = prologue;
            }
        }
        if (hasProgress) {
            for (int day = 1; day <= maxProgress; ++day) {
                Period progress = this.getProgress(day);
                if (progress == null) {
                    lastPeriod = new Period(this, Period.Type.PROGRESS, day);
                    this.setPeriod(day, lastPeriod);
                    continue;
                }
                lastPeriod = progress;
            }
        }
        if (hasEpilogue) {
            Period epilogue = this.getEpilogue();
            if (epilogue == null) {
                lastPeriod = new Period(this, Period.Type.EPILOGUE, maxProgress + 1);
                this.setPeriod(maxProgress + 1, lastPeriod);
            } else {
                lastPeriod = epilogue;
            }
        }
        assert (this.getPeriodSize() > 0);
        assert (lastPeriod != null);
        while (this.periodList.getLast() != lastPeriod) {
            this.periodList.removeLast();
        }
        if (this.getState() != State.GAMEOVER) {
            lastPeriod.setHot(true);
        }
    }

    private void setPeriod(int index, Period period) throws IndexOutOfBoundsException {
        int listSize = this.periodList.size();
        if (index == listSize) {
            this.periodList.add(period);
        } else if (index < listSize) {
            this.periodList.set(index, period);
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    private void parseTitle(CharSequence html) {
        Matcher matcher = titleRegex.matcher(html);
        if (matcher.find()) {
            String title = matcher.group(1);
        }
        if ((matcher = villageInfoRegex.matcher(html)).find()) {
            String vName = matcher.group(1);
            String month = matcher.group(2);
            String day = matcher.group(3);
            String ampm = matcher.group(4);
            String hh = matcher.group(5);
            String mm = matcher.group(6);
            int upMonth = Integer.parseInt(month);
            int upDay = Integer.parseInt(day);
            int upHour = Integer.parseInt(hh);
            int upMinute = Integer.parseInt(mm);
            if (ampm.equals("\u5348\u5f8c")) {
                upHour += 12;
            }
            upHour %= 24;
        }
    }

    public List<Talk> getTalkListFromAnchor(Anchor anchor) throws IOException {
        LinkedList<Talk> result = new LinkedList<Talk>();
        Period anchorPeriod = this.getPeriod(anchor.getDay());
        if (anchorPeriod == null) {
            return result;
        }
        anchorPeriod.updatePeriod();
        for (Topic topic : anchorPeriod.getTopicList()) {
            Talk talk;
            if (!(topic instanceof Talk) || (talk = (Talk)topic).getHour() != anchor.getHour() || talk.getMinute() != anchor.getMinute()) continue;
            result.add(talk);
        }
        return result;
    }

    @Override
    public int compareTo(Village village) {
        int cmpResult = vComparator.compare(this, village);
        return cmpResult;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Village)) {
            return false;
        }
        Village village = (Village)obj;
        if (this.getParentLand() != village.getParentLand()) {
            return false;
        }
        int cmpResult = this.compareTo(village);
        return cmpResult == 0;
    }

    public int hashCode() {
        int homeHash = this.getParentLand().hashCode();
        int vidHash = this.getVillageID().hashCode();
        int result = homeHash ^ vidHash;
        return result;
    }

    public String toString() {
        return this.getVillageName();
    }

    static {
        String Spchar = " \\t\\n\\r";
        String Sp = "[" + Spchar + "]";
        String Sp_n = Sp + "*";
        String Sp_m = Sp + "+";
        String prologue = "\u30d7\u30ed\u30ed\u30fc\u30b0";
        String epilogue = "\u30a8\u30d4\u30ed\u30fc\u30b0";
        String gameover = "\u7d42\u4e86";
        String progress = "([1-9][0-9]*)\u65e5\u76ee";
        String anchorStart = "<a" + Sp_m + "href=\"([^\"]*)\"" + Sp_n + ">" + Sp_n;
        String anchorClose = Sp_n + "</a>";
        String content = "(" + prologue + "|" + epilogue + "|" + progress + "|" + gameover + ")";
        String anchor = anchorStart + content + anchorClose;
        String title = "<title>" + Sp_n + "([^<]*)" + Sp_n + "</title>";
        String villageInfo = ">" + Sp_n + "([^<]+?)" + Sp_n + "<strong>" + Sp_n + "[\\(\uff08]" + Sp_n + "([1-9][0-9]?)/([1-9][0-9]?)" + Sp_n + "(\u5348\u524d|\u5348\u5f8c)" + Sp_n + "([0-9][0-9]?)\u6642" + Sp_n + "([0-9][0-9]?)\u5206" + Sp_n + "\u306b\u66f4\u65b0" + Sp_n + "[\\)\uff09]" + Sp_n + "</strong>";
        anchorRegex = Pattern.compile(anchor, 32);
        titleRegex = Pattern.compile(title, 32);
        villageInfoRegex = Pattern.compile(villageInfo, 32);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        PROLOGUE,
        PROGRESS,
        EPILOGUE,
        GAMEOVER,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VillageComparator
    implements Comparator<Village> {
        private VillageComparator() {
        }

        @Override
        public int compare(Village v1, Village v2) {
            if (v1 == null && v2 == null) {
                return 0;
            }
            if (v1 == null && v2 != null) {
                return -1;
            }
            if (v1 != null && v2 == null) {
                return 1;
            }
            int v1Num = v1.getVillageIDNum();
            int v2Num = v2.getVillageIDNum();
            return v1Num - v2Num;
        }
    }
}

