/*
 * 矩形領域テキスト描画基本インタフェース
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: RowsLtoR.java 164 2008-09-05 11:53:41Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;

/**
 * 矩形に複数行のテキストを配置・描画する「なにものか」を表すインタフェース。
 * この場合、「行」とは左から右へ水平方向にグリフを並べたもの。
 */
public interface RowsLtoR extends Selectable{
    
    /**
     * 新しい幅を指定し、寸法の再計算、内部の再レイアウトを促す。
     * @param newWidth 新しいピクセル幅
     * @return 新しい寸法
     */
    public Rectangle setWidth(int newWidth);

    /**
     * 描画領域の寸法を返す。
     * @return 描画領域の寸法
     */
    public Rectangle getBounds();

    /**
     * 描画開始位置の指定。
     * @param xPos 描画開始位置のx座標
     * @param yPos 描画開始位置のy座標
     */
    public void setPos(int xPos, int yPos);

    /**
     * 描画領域の寸法幅を返す。
     * @return 描画領域の寸法幅
     */
    public int getWidth();

    /**
     * 描画領域の寸法高を返す。
     * @return 描画領域の寸法高
     */
    public int getHeight();

    /**
     * フォント描画設定を変更する。
     * @param font フォント
     * @param frc フォント描画設定
     */
    public void setFontInfo(Font font, FontRenderContext frc);
    
    /**
     * 描画を行う。
     * @param g グラフィックコンテキスト
     */
    public void paint(Graphics2D g);

}
