/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.io.IOException;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputListener;
import jp.sourceforge.jindolf.Anchor;
import jp.sourceforge.jindolf.AnchorHitEvent;
import jp.sourceforge.jindolf.AnchorHitListener;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.RegexPattern;
import jp.sourceforge.jindolf.RowsLtoR;
import jp.sourceforge.jindolf.SysEvent;
import jp.sourceforge.jindolf.SysEventDraw;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.TalkDraw;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.TopicFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Discussion
extends JComponent
implements Scrollable,
MouseInputListener {
    private static final Insets insets = new Insets(15, 15, 15, 15);
    private static final int horizontalGap = Discussion.insets.left + Discussion.insets.right;
    private static final int verticalGap = Discussion.insets.top + Discussion.insets.bottom;
    private Period period;
    private final List<RowsLtoR> rowList = new LinkedList<RowsLtoR>();
    private TopicFilter topicFilter = null;
    private TopicFilter.FilterContext filterContext;
    private RegexPattern regexPattern = null;
    private Point lastPressedPoint;
    private Point dragFrom;
    private Font font;
    private FontRenderContext renderContext;
    private final RenderingHints hints = new RenderingHints(null);
    private Dimension idealSize;
    private int lastWidth = -1;
    private final DiscussionPopup popup = new DiscussionPopup();
    private final EventListenerList thisListenerList = new EventListenerList();
    private final Action copySelectedAction = new ProxyAction("COPY");

    public Discussion(Period period, Font font, FontRenderContext renderContext) {
        this.font = font;
        this.renderContext = renderContext;
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.updateRenderingHints();
        this.setPeriod(period);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setComponentPopupMenu(this.popup);
        this.updateInputMap();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", this.copySelectedAction);
    }

    private void updateRenderingHints() {
        boolean isAntiAliased = this.renderContext.isAntiAliased();
        boolean usesFractionalMetrics = this.renderContext.usesFractionalMetrics();
        Object textAliaseValue = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        Object textFractionalValue = RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        if (isAntiAliased) {
            textAliaseValue = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        }
        if (usesFractionalMetrics) {
            textFractionalValue = RenderingHints.VALUE_FRACTIONALMETRICS_ON;
        }
        this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, textAliaseValue);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, textFractionalValue);
    }

    public void setFontInfo(Font font, FontRenderContext renderContext) {
        this.font = font;
        this.renderContext = renderContext;
        this.updateRenderingHints();
        for (RowsLtoR row : this.rowList) {
            row.setFontInfo(this.font, this.renderContext);
        }
        this.layoutRows();
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        if (period == null) {
            this.period = null;
            this.rowList.clear();
            return;
        }
        if (this.period == period && period.getTopics() == this.rowList.size()) {
            return;
        }
        this.period = period;
        this.filterContext = null;
        this.rowList.clear();
        for (Topic topic : this.period.getTopicList()) {
            RowsLtoR row;
            if (topic instanceof Talk) {
                Talk talk = (Talk)topic;
                row = new TalkDraw(talk, this.font, this.renderContext);
            } else if (topic instanceof SysEvent) {
                SysEvent sysEvent = (SysEvent)topic;
                row = new SysEventDraw(sysEvent, this.font, this.renderContext);
            } else {
                assert (false);
                continue;
            }
            this.rowList.add(row);
        }
        this.clearSizeCache();
        int width = this.getWidth();
        this.calcIdealSize(width);
        this.repaint();
        this.revalidate();
    }

    @Override
    public Insets getInsets() {
        return insets;
    }

    public void setTopicFilter(TopicFilter filter) {
        this.topicFilter = filter;
        this.filtering();
    }

    public void filtering() {
        if (this.topicFilter != null && this.topicFilter.isSame(this.filterContext)) {
            return;
        }
        this.filterContext = this.topicFilter != null ? this.topicFilter.getFilterContext() : null;
        this.layoutRows();
        this.clearSelect();
    }

    public RegexPattern getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(RegexPattern regexPattern) {
        this.regexPattern = regexPattern;
    }

    public int highlightRegex() {
        int total = 0;
        this.clearHotTarget();
        Pattern pattern = null;
        if (this.regexPattern != null) {
            pattern = this.regexPattern.getPattern();
        }
        for (RowsLtoR row : this.rowList) {
            if (!(row instanceof TalkDraw)) continue;
            TalkDraw talkDraw = (TalkDraw)row;
            total += talkDraw.setRegex(pattern);
        }
        this.repaint();
        return total;
    }

    public void nextHotTarget() {
        TalkDraw oldTalk = null;
        int oldIndex = -1;
        TalkDraw newTalk = null;
        int newIndex = -1;
        TalkDraw firstTalk = null;
        boolean findOld = true;
        for (RowsLtoR row : this.rowList) {
            if (!(row instanceof TalkDraw)) continue;
            TalkDraw talkDraw = (TalkDraw)row;
            int matches = talkDraw.getRegexMatches();
            if (firstTalk == null && matches > 0) {
                firstTalk = talkDraw;
            }
            if (findOld) {
                int index = talkDraw.getHotTargetIndex();
                if (index < 0) continue;
                oldTalk = talkDraw;
                oldIndex = index;
                this.scrollRectWithMargin(talkDraw.getHotTargetRectangle());
                if (oldIndex < matches - 1 && !this.isFiltered(row)) {
                    newTalk = talkDraw;
                    newIndex = oldIndex + 1;
                    break;
                }
                findOld = false;
                continue;
            }
            if (this.isFiltered(row) || matches <= 0) continue;
            newTalk = talkDraw;
            newIndex = 0;
            break;
        }
        Rectangle showRect = null;
        if (oldTalk == null && firstTalk != null) {
            firstTalk.setHotTargetIndex(0);
            showRect = firstTalk.getHotTargetRectangle();
        } else if (oldTalk != null && newTalk != null) {
            oldTalk.clearHotTarget();
            newTalk.setHotTargetIndex(newIndex);
            showRect = newTalk.getHotTargetRectangle();
        }
        if (showRect != null) {
            this.scrollRectWithMargin(showRect);
        }
        this.repaint();
    }

    public void prevHotTarget() {
        TalkDraw oldTalk = null;
        int oldIndex = -1;
        TalkDraw newTalk = null;
        int newIndex = -1;
        TalkDraw firstTalk = null;
        boolean findOld = true;
        int size = this.rowList.size();
        ListIterator<RowsLtoR> iterator = this.rowList.listIterator(size);
        while (iterator.hasPrevious()) {
            RowsLtoR row = iterator.previous();
            if (!(row instanceof TalkDraw)) continue;
            TalkDraw talkDraw = (TalkDraw)row;
            int matches = talkDraw.getRegexMatches();
            if (firstTalk == null && matches > 0) {
                firstTalk = talkDraw;
            }
            if (findOld) {
                int index = talkDraw.getHotTargetIndex();
                if (index < 0) continue;
                oldTalk = talkDraw;
                oldIndex = index;
                this.scrollRectWithMargin(talkDraw.getHotTargetRectangle());
                if (oldIndex > 0 && !this.isFiltered(row)) {
                    newTalk = talkDraw;
                    newIndex = oldIndex - 1;
                    break;
                }
                findOld = false;
                continue;
            }
            if (this.isFiltered(row) || matches <= 0) continue;
            newTalk = talkDraw;
            newIndex = matches - 1;
            break;
        }
        Rectangle showRect = null;
        if (oldTalk == null && firstTalk != null) {
            int matches = firstTalk.getRegexMatches();
            firstTalk.setHotTargetIndex(matches - 1);
            showRect = firstTalk.getHotTargetRectangle();
        } else if (oldTalk != null && newTalk != null) {
            oldTalk.clearHotTarget();
            newTalk.setHotTargetIndex(newIndex);
            showRect = newTalk.getHotTargetRectangle();
        }
        if (showRect != null) {
            this.scrollRectWithMargin(showRect);
        }
        this.repaint();
    }

    public void clearHotTarget() {
        for (RowsLtoR row : this.rowList) {
            if (!(row instanceof TalkDraw)) continue;
            TalkDraw talkDraw = (TalkDraw)row;
            talkDraw.clearHotTarget();
        }
        this.repaint();
    }

    private void scrollRectWithMargin(Rectangle rectangle) {
        int MARGINTOP = 50;
        int MARGINBOTTOM = 100;
        Rectangle show = new Rectangle(rectangle);
        show.y -= 50;
        show.height += 150;
        this.scrollRectToVisible(show);
    }

    private void clearSizeCache() {
        this.idealSize = null;
        this.lastWidth = -1;
        this.revalidate();
    }

    private boolean isFiltered(RowsLtoR row) {
        Topic topic;
        if (this.topicFilter == null) {
            return false;
        }
        if (row instanceof TalkDraw) {
            topic = ((TalkDraw)row).getTalk();
        } else if (row instanceof SysEventDraw) {
            topic = ((SysEventDraw)row).getSysEvent();
        } else {
            return false;
        }
        return this.topicFilter.isFiltered(topic);
    }

    private Rectangle calcRect(int xPos, int yPos, int widthLimit) {
        int innerLimit = widthLimit - horizontalGap;
        Rectangle unionRect = null;
        for (RowsLtoR row : this.rowList) {
            if (this.isFiltered(row)) continue;
            row.setPos(xPos, yPos);
            Rectangle rowBound = row.setWidth(innerLimit);
            yPos += rowBound.height;
            if (unionRect == null) {
                unionRect = new Rectangle(rowBound);
                continue;
            }
            unionRect.add(rowBound);
        }
        return unionRect;
    }

    public void layoutRows() {
        int width = this.getWidth();
        this.calcIdealSizeIntl(width);
        this.repaint();
        this.revalidate();
    }

    private void calcIdealSize(int newWidth) {
        if (newWidth == this.lastWidth) {
            return;
        }
        this.calcIdealSizeIntl(newWidth);
    }

    private void calcIdealSizeIntl(int newWidth) {
        this.lastWidth = newWidth;
        Rectangle unionRect = this.calcRect(Discussion.insets.left, Discussion.insets.top, newWidth);
        if (this.idealSize == null) {
            this.idealSize = new Dimension();
        }
        int newHeight = verticalGap;
        if (unionRect != null) {
            newHeight += unionRect.height;
        }
        this.idealSize.width = newWidth;
        this.idealSize.height = newHeight;
        this.setPreferredSize(this.idealSize);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.hints);
        g2.setColor(Color.BLACK);
        Rectangle clipRect = g.getClipBounds();
        g2.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        for (RowsLtoR row : this.rowList) {
            Rectangle rowRect = row.getBounds();
            if (!rowRect.intersects(clipRect) || this.isFiltered(row)) continue;
            row.paint(g2);
        }
    }

    @Override
    public void setSize(Dimension size) {
        this.setBounds(this.getX(), this.getY(), size.width, size.height);
    }

    @Override
    public void setSize(int width, int height) {
        this.setBounds(this.getX(), this.getY(), width, height);
    }

    @Override
    @Deprecated
    public void resize(Dimension size) {
        this.setBounds(this.getX(), this.getY(), size.width, size.height);
    }

    @Override
    @Deprecated
    public void resize(int width, int height) {
        this.setBounds(this.getX(), this.getY(), width, height);
    }

    @Override
    public void setBounds(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int oldWidth = this.getWidth();
        super.setBounds(x, y, width, height);
        if (oldWidth == width) {
            return;
        }
        this.calcIdealSize(width);
        if (this.idealSize.width != width || this.idealSize.height != height) {
            this.revalidate();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return visibleRect.height;
        }
        return 30;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 30;
    }

    public Rectangle getTalkBounds(Talk talk) {
        if (this.topicFilter != null && this.topicFilter.isFiltered(talk)) {
            return null;
        }
        for (RowsLtoR row : this.rowList) {
            TalkDraw talkDraw;
            if (!(row instanceof TalkDraw) || (talkDraw = (TalkDraw)row).getTalk() != talk) continue;
            Rectangle rect = talkDraw.getBounds();
            return rect;
        }
        return null;
    }

    private void drag(Point from, Point to) {
        Rectangle dragRegion = new Rectangle();
        dragRegion.setFrameFromDiagonal(from, to);
        for (RowsLtoR row : this.rowList) {
            if (this.isFiltered(row) || !row.getBounds().intersects(dragRegion)) continue;
            row.drag(from, to);
        }
        this.repaint();
    }

    private void clearSelect() {
        for (RowsLtoR row : this.rowList) {
            row.clearSelect();
        }
        this.repaint();
    }

    public RowsLtoR hittedRow(Point pt) {
        for (RowsLtoR row : this.rowList) {
            Rectangle bounds;
            if (this.isFiltered(row) || !(bounds = row.getBounds()).contains(pt)) continue;
            return row;
        }
        return null;
    }

    private void hitAnchor(Point pt) {
        if (this.period == null) {
            return;
        }
        RowsLtoR row = this.hittedRow(pt);
        if (row == null) {
            return;
        }
        if (!(row instanceof TalkDraw)) {
            return;
        }
        TalkDraw chat = (TalkDraw)row;
        Anchor anchor = chat.getAnchor(pt);
        if (anchor == null) {
            return;
        }
        for (AnchorHitListener listener : this.getAnchorHitListeners()) {
            AnchorHitEvent event = new AnchorHitEvent(this, chat, anchor, pt);
            listener.anchorHitted(event);
        }
    }

    private void hitRegex(Point pt) {
        if (this.period == null) {
            return;
        }
        RowsLtoR row = this.hittedRow(pt);
        if (row == null) {
            return;
        }
        if (!(row instanceof TalkDraw)) {
            return;
        }
        TalkDraw chat = (TalkDraw)row;
        int index = chat.getRegexMatchIndex(pt);
        if (index < 0) {
            return;
        }
        this.clearHotTarget();
        chat.setHotTargetIndex(index);
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        Point pt = ev.getPoint();
        if (ev.getButton() == 1) {
            this.clearSelect();
            this.hitAnchor(pt);
            this.hitRegex(pt);
        }
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        this.requestFocusInWindow();
        this.lastPressedPoint = ev.getPoint();
        if (ev.getButton() == 1) {
            this.clearSelect();
            this.dragFrom = ev.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (ev.getButton() == 1) {
            this.dragFrom = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        if (this.dragFrom == null) {
            return;
        }
        Point dragTo = ev.getPoint();
        this.drag(this.dragFrom, dragTo);
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
    }

    public Point getLastPressedPoint() {
        return this.lastPressedPoint;
    }

    public CharSequence getSelected() {
        StringBuilder selected = new StringBuilder();
        for (RowsLtoR row : this.rowList) {
            if (this.isFiltered(row)) continue;
            try {
                row.appendSelected(selected);
            }
            catch (IOException e) {
                assert (false);
                return null;
            }
        }
        if (selected.length() <= 0) {
            return null;
        }
        return selected;
    }

    private void copyToClipBoard(CharSequence data) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        StringSelection selection = new StringSelection(((Object)data).toString());
        clipboard.setContents(selection, selection);
    }

    public CharSequence copySelected() {
        CharSequence selected = this.getSelected();
        if (selected == null) {
            return null;
        }
        this.copyToClipBoard(selected);
        return selected;
    }

    public CharSequence copyTalk() {
        RowsLtoR row = this.popup.lastPopupedRow;
        if (row == null) {
            return null;
        }
        if (!(row instanceof TalkDraw)) {
            return null;
        }
        TalkDraw talkDraw = (TalkDraw)row;
        Talk talk = talkDraw.getTalk();
        StringBuilder selected = new StringBuilder();
        Avatar avatar = talk.getAvatar();
        selected.append(avatar.getName()).append(' ');
        String anchor = talk.getAnchorNotation();
        selected.append(anchor).append('\n');
        selected.append(talk.getDialog());
        if (selected.charAt(selected.length() - 1) != '\n') {
            selected.append('\n');
        }
        this.copyToClipBoard(selected);
        return selected;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.popup.updateUI();
        this.updateInputMap();
    }

    private void updateInputMap() {
        KeyStroke[] strokes;
        InputMap thisInputMap = this.getInputMap();
        InputMap sampleInputMap = new JTextField().getInputMap();
        for (KeyStroke stroke : strokes = sampleInputMap.allKeys()) {
            Object bind = sampleInputMap.get(stroke);
            if (!bind.equals("copy-to-clipboard")) continue;
            thisInputMap.put(stroke, "copy-to-clipboard");
        }
    }

    public void addActionListener(ActionListener listener) {
        this.thisListenerList.add(ActionListener.class, listener);
        this.popup.menuCopy.addActionListener(listener);
        this.popup.menuSelTalk.addActionListener(listener);
        this.popup.menuSummary.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.thisListenerList.remove(ActionListener.class, listener);
        this.popup.menuCopy.removeActionListener(listener);
        this.popup.menuSelTalk.removeActionListener(listener);
        this.popup.menuSummary.removeActionListener(listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.thisListenerList.getListeners(ActionListener.class);
    }

    public void addAnchorHitListener(AnchorHitListener listener) {
        this.thisListenerList.add(AnchorHitListener.class, listener);
    }

    public void removeAnchorHitListener(AnchorHitListener listener) {
        this.thisListenerList.remove(AnchorHitListener.class, listener);
    }

    public AnchorHitListener[] getAnchorHitListeners() {
        return (AnchorHitListener[])this.thisListenerList.getListeners(AnchorHitListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener[] result = this.thisListenerList.getListeners(listenerType);
        if (result.length <= 0) {
            result = super.getListeners(listenerType);
        }
        return result;
    }

    private class DiscussionPopup
    extends JPopupMenu {
        private final JMenuItem menuCopy = new JMenuItem("\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc");
        private final JMenuItem menuSelTalk = new JMenuItem("\u3053\u306e\u767a\u8a00\u3092\u30b3\u30d4\u30fc");
        private final JMenuItem menuSummary = new JMenuItem("\u767a\u8a00\u3092\u96c6\u8a08...");
        private RowsLtoR lastPopupedRow;

        public DiscussionPopup() {
            this.add(this.menuCopy);
            this.add(this.menuSelTalk);
            this.addSeparator();
            this.add(this.menuSummary);
            this.menuCopy.setActionCommand("COPY");
            this.menuSelTalk.setActionCommand("SELTALK");
            this.menuSummary.setActionCommand("SHOWDAYSUMMARY");
        }

        public void show(Component comp, int x, int y) {
            this.lastPopupedRow = Discussion.this.hittedRow(new Point(x, y));
            if (this.lastPopupedRow != null && this.lastPopupedRow instanceof TalkDraw) {
                this.menuSelTalk.setEnabled(true);
            } else {
                this.menuSelTalk.setEnabled(false);
            }
            if (Discussion.this.getSelected() != null) {
                this.menuCopy.setEnabled(true);
            } else {
                this.menuCopy.setEnabled(false);
            }
            super.show(comp, x, y);
        }
    }

    private class ProxyAction
    extends AbstractAction {
        private final String command;

        public ProxyAction(String command) {
            this.command = command;
        }

        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            int id = event.getID();
            String actcmd = this.command;
            long when = event.getWhen();
            int modifiers = event.getModifiers();
            for (ActionListener listener : Discussion.this.getActionListeners()) {
                ActionEvent newEvent = new ActionEvent(source, id, actcmd, when, modifiers);
                listener.actionPerformed(newEvent);
            }
        }
    }
}

