/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import jp.sourceforge.jindolf.Jindolf;

public class GUIUtils {
    public static AffineTransform AFFINETX_IDENTITY = new AffineTransform();
    private static final String logoSource = "resources/image/logo.png";
    private static final String windowIconSource = "resources/image/winicon.png";
    private static Image logoImage;
    private static Icon logoIcon;
    private static Image windowIconImage;
    private static final RenderingHints normalHints;
    private static final RenderingHints qualityHints;
    private static final RenderingHints speedyHints;
    private static final Runnable taskNothing;

    public static RenderingHints getDefaultHints() {
        return normalHints;
    }

    public static RenderingHints getNormalHints() {
        return normalHints;
    }

    public static RenderingHints getQualityHints() {
        return qualityHints;
    }

    public static RenderingHints getSpeedyHints() {
        return speedyHints;
    }

    public static Image loadImageFromResource(String resource) throws IOException {
        URL url = Jindolf.getResource(resource);
        BufferedImage result = ImageIO.read(url);
        return result;
    }

    public static Image getLogoImage() {
        Image image;
        if (logoImage != null) {
            return logoImage;
        }
        try {
            image = GUIUtils.loadImageFromResource(logoSource);
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "\u30ed\u30b4\u30a4\u30e1\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            image = new BufferedImage(100, 100, 2);
        }
        logoImage = image;
        return logoImage;
    }

    public static Image getWindowIconImage() {
        Image image;
        if (windowIconImage != null) {
            return windowIconImage;
        }
        try {
            image = GUIUtils.loadImageFromResource(windowIconSource);
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "\u30a2\u30a4\u30b3\u30f3\u30a4\u30e1\u30fc\u30b8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            image = GUIUtils.getLogoImage();
        }
        windowIconImage = image;
        return windowIconImage;
    }

    public static Icon getLogoIcon() {
        if (logoIcon != null) {
            return logoIcon;
        }
        ImageIcon icon = new ImageIcon(GUIUtils.getLogoImage());
        logoIcon = icon;
        return logoIcon;
    }

    public static void dispatchEmptyAWTEvent() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(taskNothing);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getDirection(Rectangle rect, Point pt) {
        if (pt.y < rect.y) {
            return 1;
        }
        if (rect.y + rect.height <= pt.y) {
            return 5;
        }
        if (pt.x < rect.x) {
            return 3;
        }
        if (rect.x + rect.width <= pt.x) {
            return 7;
        }
        return 0;
    }

    public static void modifyWindowAttributes(Window window, boolean isResizable, boolean isDynamic, boolean isAutoLocation) {
        Toolkit kit = window.getToolkit();
        kit.setDynamicLayout(isDynamic);
        window.setLocationByPlatform(isAutoLocation);
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            frame.setIconImage(GUIUtils.getWindowIconImage());
            frame.setResizable(isResizable);
        } else if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            dialog.setResizable(isResizable);
        }
    }

    private GUIUtils() {
    }

    static {
        taskNothing = new Runnable(){

            public void run() {
            }
        };
        normalHints = new RenderingHints(null);
        qualityHints = new RenderingHints(null);
        speedyHints = new RenderingHints(null);
        qualityHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        speedyHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        speedyHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        qualityHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        speedyHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        qualityHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        speedyHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        qualityHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        speedyHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        qualityHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        speedyHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        qualityHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        speedyHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        qualityHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        speedyHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        qualityHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        speedyHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
    }
}

