/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;

public class LogFrame
extends JDialog
implements WindowListener,
ActionListener {
    private static final String FRAMETITLE = "\u30ed\u30b0\u8868\u793a - " + Jindolf.TITLE;
    private static final int DOCLIMIT = 100000;
    private static final float CHOPRATIO = 0.9f;
    private static final int CHOPPEDLEN = 90000;
    private static final Document dummyDoc = new PlainDocument();
    private final JTextArea textarea;
    private final Document document = new PlainDocument();
    private final JScrollPane scrollPane;
    private final JScrollBar vertical;
    private final Handler handler = new SwingLogger();
    private final JButton clearButton = new JButton("\u30af\u30ea\u30a2");
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");

    public LogFrame(Frame owner) {
        super(owner, FRAMETITLE, false);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.textarea = new JTextArea();
        this.textarea.setEditable(false);
        this.textarea.setLineWrap(true);
        this.textarea.setDocument(dummyDoc);
        this.textarea.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.scrollPane = new JScrollPane(this.textarea);
        this.vertical = this.scrollPane.getVerticalScrollBar();
        this.design();
        this.clearButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    private void design() {
        Container content = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridwidth = 0;
        content.add((Component)this.scrollPane, constraints);
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 5, 5, 5);
        content.add((Component)new JSeparator(), constraints);
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.gridwidth = 1;
        content.add((Component)this.clearButton, constraints);
        constraints.weightx = 0.0;
        constraints.anchor = 13;
        content.add((Component)this.closeButton, constraints);
    }

    public Handler getHandler() {
        return this.handler;
    }

    private void showLastPos() {
        if (!this.isVisible()) {
            return;
        }
        if (this.textarea.getDocument() != this.document) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogFrame.this.vertical.setValue(Integer.MAX_VALUE);
            }
        });
    }

    private void close() {
        this.setVisible(false);
    }

    private void clear() {
        block2: {
            try {
                this.document.remove(0, this.document.getLength());
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.textarea.setDocument(this.document);
            this.showLastPos();
        } else {
            this.textarea.setDocument(dummyDoc);
        }
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
        this.textarea.setDocument(dummyDoc);
    }

    public void windowDeiconified(WindowEvent event) {
        this.textarea.setDocument(this.document);
        this.showLastPos();
    }

    public void windowOpened(WindowEvent event) {
        this.textarea.setDocument(this.document);
        this.showLastPos();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.close();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.clearButton) {
            this.clear();
        } else if (source == this.closeButton) {
            this.close();
        }
    }

    private class SwingLogger
    extends Handler {
        private SwingLogger() {
            SimpleFormatter formatter = new SimpleFormatter();
            this.setFormatter(formatter);
        }

        public void publish(LogRecord record) {
            if (!this.isLoggable(record)) {
                return;
            }
            Formatter formatter = this.getFormatter();
            String message = formatter.format(record);
            try {
                LogFrame.this.document.insertString(LogFrame.this.document.getLength(), message, null);
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            int docLength = LogFrame.this.document.getLength();
            if (docLength > 100000) {
                int offset = docLength - 90000;
                try {
                    LogFrame.this.document.remove(0, offset);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
            LogFrame.this.showLastPos();
        }

        public void flush() {
        }

        public void close() {
            this.setLevel(Level.OFF);
            this.flush();
        }
    }
}

