/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import jp.sourceforge.jindolf.Jindolf;

public class ActionManager {
    public static final String COMMAND_EXIT = "EXIT";
    public static final String COMMAND_ABOUT = "ABOUT";
    public static final String COMMAND_LANDF = "LANDF";
    public static final String COMMAND_HELPDOC = "HELPDOC";
    public static final String COMMAND_FILTER = "FILTER";
    public static final String COMMAND_ACCOUNT = "ACCOUNT";
    public static final String COMMAND_RELOAD = "RELOAD";
    public static final String COMMAND_COPY = "COPY";
    public static final String COMMAND_PRINT = "PRINT";
    public static final String COMMAND_SELALL = "SELALL";
    public static final String COMMAND_COPYTALK = "SELTALK";
    public static final String COMMAND_SWITCHORDER = "SWITCHORDER";
    public static final String COMMAND_VILLAGELIST = "VILLAGELIST";
    public static final String COMMAND_SHOWLOG = "SHOWLOG";
    public static final String COMMAND_FONTSELECT = "FONTSELECT";
    public static final String COMMAND_FONTSIZESEL = "FONTSIZESEL";
    public static final String COMMAND_FONTAPPLY = "FONTAPPLY";
    public static final String COMMAND_FONTCANCEL = "FONTCANCEL";
    public static final String COMMAND_SEARCHNEXT = "SEARCHNEXT";
    public static final String COMMAND_SEARCHPREV = "SEARCHPREV";
    public static final String COMMAND_SHOWFIND = "FIND";
    public static final String COMMAND_ALLPERIOD = "LOADALLPERIOD";
    public static final String COMMAND_DAYSUMMARY = "SHOWDAYSUMMARY";
    public static final String COMMAND_JUMPANCHOR = "JUMPANCHOR";
    public static final KeyStroke keyF1 = KeyStroke.getKeyStroke("F1");
    public static final KeyStroke keyF3 = KeyStroke.getKeyStroke("F3");
    public static final KeyStroke keyShiftF3 = KeyStroke.getKeyStroke("shift F3");
    public static final KeyStroke keyF5 = KeyStroke.getKeyStroke("F5");
    public static final KeyStroke keyCtrlF = KeyStroke.getKeyStroke("ctrl F");
    private final Set<AbstractButton> items = new HashSet<AbstractButton>();
    private final JMenu menuFile;
    private final JMenu menuEdit;
    private final JMenu menuVillage;
    private final JMenu menuDay;
    private final JMenu menuLook;
    private final JMenu menuPreference;
    private final JMenu menuTool;
    private final JMenu menuHelp;
    private final JMenuItem itemExit;
    private final JMenuItem itemAbout;
    private final JMenuItem itemHelpDoc;
    private final JMenuItem itemFilter;
    private final JMenuItem itemAccount;
    private final JMenuItem itemShowLog;
    private final JMenuItem itemFontSelect;
    private final JMenuItem itemCopy;
    private final JMenuItem itemFind;
    private final JMenuItem itemSearchPrev;
    private final JMenuItem itemSearchNext;
    private final JMenuItem itemReloadDay;
    private final JMenuItem itemLoadAllPeriod;
    private final JMenuItem itemDaySummary;
    private final ButtonGroup landfGroup = new ButtonGroup();
    private final Map<ButtonModel, String> landfMap = new HashMap<ButtonModel, String>();
    private final JButton reloadPeriodButton = new JButton();
    private final JButton showFindButton = new JButton();
    private final JButton searchNextButton = new JButton();
    private final JButton searchPrevButton = new JButton();
    private final JMenuBar menuBar;
    private final JToolBar browseToolBar;

    public ActionManager() {
        this.menuFile = new JMenu("\u30d5\u30a1\u30a4\u30eb(F)");
        this.menuEdit = new JMenu("\u7de8\u96c6(E)");
        this.menuVillage = new JMenu("\u6751(V)");
        this.menuDay = new JMenu("\u65e5(D)");
        this.menuLook = new JMenu("\u30eb\u30c3\u30af&\u30d5\u30a3\u30fc\u30eb(L)");
        this.menuPreference = new JMenu("\u8a2d\u5b9a(P)");
        this.menuTool = new JMenu("\u30c4\u30fc\u30eb(T)");
        this.menuHelp = new JMenu("\u30d8\u30eb\u30d7(H)");
        this.itemExit = new JMenuItem("\u7d42\u4e86(X)");
        this.itemAbout = new JMenuItem(Jindolf.TITLE + "\u306b\u3064\u3044\u3066...(A)");
        this.itemHelpDoc = new JMenuItem("\u30d8\u30eb\u30d7\u8868\u793a(H)");
        this.itemFilter = new JMenuItem("\u767a\u8a00\u30d5\u30a3\u30eb\u30bf(F)");
        this.itemAccount = new JMenuItem("\u30a2\u30ab\u30a6\u30f3\u30c8\u7ba1\u7406(M)");
        this.itemShowLog = new JMenuItem("\u30ed\u30b0\u8868\u793a(S)");
        this.itemFontSelect = new JMenuItem("\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u9078\u629e...(F)");
        this.itemCopy = new JMenuItem("\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc(C)");
        this.itemFind = new JMenuItem("\u691c\u7d22...(F)");
        this.itemSearchPrev = new JMenuItem("\u524d\u5019\u88dc(P)");
        this.itemSearchNext = new JMenuItem("\u6b21\u5019\u88dc(N)");
        this.itemReloadDay = new JMenuItem("\u3053\u306e\u65e5\u3092\u5f37\u5236\u30ea\u30ed\u30fc\u30c9(R)");
        this.itemLoadAllPeriod = new JMenuItem("\u5168\u65e5\u7a0b\u306e\u4e00\u62ec\u8aad\u307f\u8fbc\u307f(R)");
        this.itemDaySummary = new JMenuItem("\u3053\u306e\u65e5\u306e\u767a\u8a00\u3092\u96c6\u8a08...(D)");
        this.itemExit.setActionCommand(COMMAND_EXIT);
        this.itemAbout.setActionCommand(COMMAND_ABOUT);
        this.itemHelpDoc.setActionCommand(COMMAND_HELPDOC);
        this.itemFilter.setActionCommand(COMMAND_FILTER);
        this.itemAccount.setActionCommand(COMMAND_ACCOUNT);
        this.itemShowLog.setActionCommand(COMMAND_SHOWLOG);
        this.itemFontSelect.setActionCommand(COMMAND_FONTSELECT);
        this.itemCopy.setActionCommand(COMMAND_COPY);
        this.itemFind.setActionCommand(COMMAND_SHOWFIND);
        this.itemSearchPrev.setActionCommand(COMMAND_SEARCHPREV);
        this.itemSearchNext.setActionCommand(COMMAND_SEARCHNEXT);
        this.itemReloadDay.setActionCommand(COMMAND_RELOAD);
        this.itemLoadAllPeriod.setActionCommand(COMMAND_ALLPERIOD);
        this.itemDaySummary.setActionCommand(COMMAND_DAYSUMMARY);
        this.itemExit.setMnemonic(88);
        this.itemAbout.setMnemonic(65);
        this.itemHelpDoc.setMnemonic(72);
        this.itemFilter.setMnemonic(70);
        this.itemAccount.setMnemonic(77);
        this.itemShowLog.setMnemonic(83);
        this.itemFontSelect.setMnemonic(70);
        this.itemCopy.setMnemonic(67);
        this.itemFind.setMnemonic(70);
        this.itemSearchPrev.setMnemonic(80);
        this.itemSearchNext.setMnemonic(78);
        this.itemReloadDay.setMnemonic(82);
        this.itemLoadAllPeriod.setMnemonic(82);
        this.itemDaySummary.setMnemonic(68);
        this.itemFind.setAccelerator(keyCtrlF);
        this.itemSearchPrev.setAccelerator(keyShiftF3);
        this.itemSearchNext.setAccelerator(keyF3);
        this.itemHelpDoc.setAccelerator(keyF1);
        this.itemReloadDay.setAccelerator(keyF5);
        this.items.add(this.itemExit);
        this.items.add(this.itemAbout);
        this.items.add(this.itemHelpDoc);
        this.items.add(this.itemFilter);
        this.items.add(this.itemAccount);
        this.items.add(this.itemShowLog);
        this.items.add(this.itemFontSelect);
        this.items.add(this.itemCopy);
        this.items.add(this.itemFind);
        this.items.add(this.itemSearchPrev);
        this.items.add(this.itemSearchNext);
        this.items.add(this.itemReloadDay);
        this.items.add(this.itemLoadAllPeriod);
        this.items.add(this.itemDaySummary);
        this.items.add(this.reloadPeriodButton);
        this.items.add(this.showFindButton);
        this.items.add(this.searchNextButton);
        this.items.add(this.searchPrevButton);
        this.createLookAndFeelMenuItems();
        this.menuBar = this.createMenuBar();
        this.browseToolBar = this.createBrowseToolBar();
        this.appearVillage(false);
        this.appearPeriod(false);
    }

    private void createLookAndFeelMenuItems() {
        UIManager.LookAndFeelInfo[] landfs;
        LookAndFeel currentLookAndFeel = UIManager.getLookAndFeel();
        String currentName = currentLookAndFeel.getClass().getName();
        AbstractButton matchedButton = null;
        for (UIManager.LookAndFeelInfo lafInfo : landfs = UIManager.getInstalledLookAndFeels()) {
            String name = lafInfo.getName();
            String className = lafInfo.getClassName();
            JRadioButtonMenuItem button = new JRadioButtonMenuItem(name);
            button.setActionCommand(COMMAND_LANDF);
            if (className.equals(currentName)) {
                matchedButton = button;
            }
            this.items.add(button);
            this.landfGroup.add(button);
            this.landfMap.put(button.getModel(), className);
        }
        if (matchedButton != null) {
            matchedButton.setSelected(true);
        }
    }

    public String getSelectedLookAndFeel() {
        ButtonModel selected = this.landfGroup.getSelection();
        if (selected == null) {
            return null;
        }
        String className = this.landfMap.get(selected);
        return className;
    }

    public void addActionListener(ActionListener listener) {
        for (AbstractButton button : this.items) {
            button.addActionListener(listener);
        }
    }

    private JMenuBar createMenuBar() {
        this.menuFile.setMnemonic(70);
        this.menuEdit.setMnemonic(69);
        this.menuVillage.setMnemonic(86);
        this.menuDay.setMnemonic(68);
        this.menuPreference.setMnemonic(80);
        this.menuTool.setMnemonic(84);
        this.menuHelp.setMnemonic(72);
        this.menuFile.add(this.itemAccount);
        this.menuFile.addSeparator();
        this.menuFile.add(this.itemExit);
        this.menuEdit.add(this.itemCopy);
        this.menuEdit.addSeparator();
        this.menuEdit.add(this.itemFind);
        this.menuEdit.add(this.itemSearchPrev);
        this.menuEdit.add(this.itemSearchNext);
        this.menuVillage.add(this.itemLoadAllPeriod);
        this.menuDay.add(this.itemReloadDay);
        this.menuDay.add(this.itemDaySummary);
        this.menuTool.add(this.itemFilter);
        this.menuTool.add(this.itemShowLog);
        this.menuHelp.add(this.itemHelpDoc);
        this.menuHelp.addSeparator();
        this.menuHelp.add(this.itemAbout);
        this.menuLook.setMnemonic(76);
        Enumeration<AbstractButton> landfButtons = this.landfGroup.getElements();
        while (landfButtons.hasMoreElements()) {
            JMenuItem item = (JMenuItem)landfButtons.nextElement();
            this.menuLook.add(item);
        }
        this.menuPreference.add(this.itemFontSelect);
        this.menuPreference.addSeparator();
        this.menuPreference.add(this.menuLook);
        JMenuBar bar = new JMenuBar();
        bar.add(this.menuFile);
        bar.add(this.menuEdit);
        bar.add(this.menuVillage);
        bar.add(this.menuDay);
        bar.add(this.menuPreference);
        bar.add(this.menuTool);
        bar.add(this.menuHelp);
        return bar;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private JToolBar createBrowseToolBar() {
        URL url = Jindolf.getResource("resources/image/reload.png");
        ImageIcon reloadIcon = new ImageIcon(url);
        this.reloadPeriodButton.setIcon(reloadIcon);
        url = Jindolf.getResource("resources/image/find.png");
        ImageIcon findIcon = new ImageIcon(url);
        this.showFindButton.setIcon(findIcon);
        url = Jindolf.getResource("resources/image/findprev.png");
        ImageIcon findPrevIcon = new ImageIcon(url);
        this.searchPrevButton.setIcon(findPrevIcon);
        url = Jindolf.getResource("resources/image/findnext.png");
        ImageIcon findNextIcon = new ImageIcon(url);
        this.searchNextButton.setIcon(findNextIcon);
        this.reloadPeriodButton.setToolTipText("\u9078\u629e\u4e2d\u306e\u65e5\u3092\u5f37\u5236\u30ea\u30ed\u30fc\u30c9");
        this.showFindButton.setToolTipText("\u691c\u7d22");
        this.searchPrevButton.setToolTipText("\u2191\u524d\u5019\u88dc");
        this.searchNextButton.setToolTipText("\u2193\u6b21\u5019\u88dc");
        this.reloadPeriodButton.setMargin(new Insets(1, 1, 1, 1));
        this.showFindButton.setMargin(new Insets(1, 1, 1, 1));
        this.searchPrevButton.setMargin(new Insets(1, 1, 1, 1));
        this.searchNextButton.setMargin(new Insets(1, 1, 1, 1));
        this.reloadPeriodButton.setActionCommand(COMMAND_RELOAD);
        this.showFindButton.setActionCommand(COMMAND_SHOWFIND);
        this.searchNextButton.setActionCommand(COMMAND_SEARCHNEXT);
        this.searchPrevButton.setActionCommand(COMMAND_SEARCHPREV);
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.reloadPeriodButton);
        toolBar.addSeparator();
        toolBar.add(this.showFindButton);
        toolBar.add(this.searchNextButton);
        toolBar.add(this.searchPrevButton);
        return toolBar;
    }

    public JToolBar getBrowseToolBar() {
        return this.browseToolBar;
    }

    public void appearPeriod(boolean appear) {
        if (appear) {
            this.appearVillage(appear);
        }
        this.menuEdit.setEnabled(appear);
        this.menuDay.setEnabled(appear);
        this.reloadPeriodButton.setEnabled(appear);
        this.showFindButton.setEnabled(appear);
        this.searchNextButton.setEnabled(appear);
        this.searchPrevButton.setEnabled(appear);
    }

    public void appearVillage(boolean appear) {
        if (!appear) {
            this.appearPeriod(appear);
        }
        this.menuVillage.setEnabled(appear);
    }
}

