/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.GlyphDraw;
import jp.sourceforge.jindolf.Jindolf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontChooser
extends JDialog
implements ListSelectionListener,
ActionListener,
ItemListener,
WindowListener {
    public static final Font defaultFont;
    public static final FontRenderContext defaultRenderContext;
    private static final String FRAMETITLE;
    private static final String[] initFamilyNames;
    private static final Integer[] pointSizes;
    private static final int defaultFontStyle = 0;
    private static final int defaultFontSize = 16;
    private static final SortedSet<String> familySet;
    private static final CharSequence previewContent;
    private static final String CHECK_CODE = "9A\u3042\u3091\u30a2\uff71\u30f4\u30f0\u253c\u0416\u03a9\u5ce0\u51dc\u7199";
    private Font selectedFont = defaultFont;
    private FontRenderContext renderContext = defaultRenderContext;
    private Font lastFont = this.selectedFont;
    private FontRenderContext lastContext = this.renderContext;
    private final JList familySelector;
    private final JComboBox sizeSelector;
    private final JCheckBox isBoldCheck;
    private final JCheckBox isItalicCheck;
    private final JCheckBox useTextAntiAliaseCheck;
    private final JCheckBox useFractionalCheck;
    private final JLabel maxBounds;
    private final JTextField invokeOption;
    private final FontPreview preview;
    private final JButton applyButton;
    private final JButton cancelButton;
    private boolean maskListener = false;
    private boolean isCanceled = false;

    private static SortedSet<String> createFontSet() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] allFonts = ge.getAllFonts();
        TreeSet<String> result = new TreeSet<String>();
        for (Font font : allFonts) {
            if (font.canDisplayUpTo(CHECK_CODE) >= 0) continue;
            String familyName = font.getFamily();
            result.add(familyName.intern());
        }
        return result;
    }

    private static Font createDefaultFont() {
        String defaultFamilyName = "Dialog";
        for (String familyName : initFamilyNames) {
            Font dummyFont = new Font(familyName, 0, 1);
            String dummyFontName = dummyFont.getFamily();
            if (!dummyFontName.equals(familyName)) continue;
            defaultFamilyName = dummyFontName;
            break;
        }
        Font result = new Font(defaultFamilyName, 0, 16);
        return result;
    }

    private static FontRenderContext createDefaultFontRenderContext() {
        boolean isAntiAliased = true;
        boolean usesFractionalMetrics = true;
        if (FontChooser.guessBitmapFont(defaultFont)) {
            isAntiAliased = false;
            usesFractionalMetrics = false;
        }
        FontRenderContext result = new FontRenderContext(GUIUtils.AFFINETX_IDENTITY, isAntiAliased, usesFractionalMetrics);
        return result;
    }

    public static boolean guessBitmapFont(Font font) {
        String familyName = font.getFamily();
        return font.getSize() < 24 && familyName.startsWith("\uff2d\uff33") && (familyName.contains("\u30b4\u30b7\u30c3\u30af") || familyName.contains("\u660e\u671d"));
    }

    public FontChooser(Frame owner) {
        super(owner, FRAMETITLE, true);
        Jindolf.logger.info("\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u306b" + this.selectedFont + "\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f");
        Jindolf.logger.info("\u767a\u8a00\u8868\u793a\u306e\u30a2\u30f3\u30c1\u30a8\u30a4\u30ea\u30a2\u30b9\u6307\u5b9a\u306b" + this.renderContext.isAntiAliased() + "\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        Jindolf.logger.info("\u767a\u8a00\u8868\u793a\u306eFractional\u6307\u5b9a\u306b" + this.renderContext.usesFractionalMetrics() + "\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        Vector<String> familyList = new Vector<String>(familySet);
        this.familySelector = new JList<String>(familyList);
        this.familySelector.setVisibleRowCount(-1);
        this.familySelector.setSelectionMode(0);
        this.sizeSelector = new JComboBox();
        this.sizeSelector.setEditable(true);
        this.sizeSelector.setActionCommand("FONTSIZESEL");
        for (Integer size : pointSizes) {
            this.sizeSelector.addItem(size);
        }
        this.isBoldCheck = new JCheckBox("\u30dc\u30fc\u30eb\u30c9");
        this.isItalicCheck = new JCheckBox("\u30a4\u30bf\u30ea\u30c3\u30af");
        this.useTextAntiAliaseCheck = new JCheckBox("\u30a2\u30f3\u30c1\u30a8\u30a4\u30ea\u30a2\u30b9");
        this.useFractionalCheck = new JCheckBox("\u30b5\u30d6\u30d4\u30af\u30bb\u30eb\u7cbe\u5ea6");
        this.maxBounds = new JLabel();
        this.invokeOption = new JTextField();
        this.invokeOption.setEditable(false);
        Font oldFont = this.invokeOption.getFont();
        Font newFont = new Font("Monospaced", oldFont.getStyle(), oldFont.getSize());
        this.invokeOption.setFont(newFont);
        this.preview = new FontPreview(previewContent, this.selectedFont, this.renderContext);
        this.applyButton = new JButton("\u9069\u7528\u3059\u308b");
        this.cancelButton = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.applyButton.setActionCommand("FONTAPPLY");
        this.cancelButton.setActionCommand("FONTCANCEL");
        this.getRootPane().setDefaultButton(this.applyButton);
        this.design();
        this.updateControlls();
        this.updatePreview();
        this.familySelector.addListSelectionListener(this);
        this.sizeSelector.addActionListener(this);
        this.isBoldCheck.addItemListener(this);
        this.isItalicCheck.addItemListener(this);
        this.useTextAntiAliaseCheck.addItemListener(this);
        this.useFractionalCheck.addItemListener(this);
        this.applyButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void design() {
        Container content = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        JComponent fontPref = this.createFontPrefPanel();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        content.add((Component)fontPref, constraints);
        TitledBorder border = BorderFactory.createTitledBorder("\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.invokeOption, "Center");
        panel.setBorder(border);
        content.add((Component)panel, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        border = BorderFactory.createTitledBorder("\u30d7\u30ec\u30d3\u30e5\u30fc");
        panel = new JPanel();
        panel.add(this.preview);
        panel.setBorder(border);
        content.add((Component)this.createPreviewPanel(), constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        content.add((Component)this.maxBounds, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        content.add((Component)new JSeparator(), constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        content.add((Component)this.applyButton, constraints);
        constraints.weightx = 0.0;
        content.add((Component)this.cancelButton, constraints);
    }

    private JComponent createFontPrefPanel() {
        JPanel result = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        result.setLayout(layout);
        constraints.insets = new Insets(0, 0, 0, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 0;
        constraints.fill = 1;
        Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.familySelector.setBorder(border);
        JScrollPane familyScroller = new JScrollPane(this.familySelector);
        border = BorderFactory.createTitledBorder("\u30d5\u30a9\u30f3\u30c8\u30d5\u30a1\u30df\u30ea\u9078\u629e");
        JPanel familyPanel = new JPanel();
        familyPanel.setLayout(new BorderLayout());
        familyPanel.add((Component)familyScroller, "Center");
        familyPanel.setBorder(border);
        result.add((Component)familyPanel, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 0.0;
        constraints.gridheight = 1;
        constraints.fill = 2;
        constraints.anchor = 17;
        border = BorderFactory.createTitledBorder("\u30dd\u30a4\u30f3\u30c8\u30b5\u30a4\u30ba\u6307\u5b9a");
        JPanel panel = new JPanel();
        panel.add(this.sizeSelector);
        panel.setBorder(border);
        result.add((Component)panel, constraints);
        constraints.anchor = 18;
        result.add((Component)this.isBoldCheck, constraints);
        result.add((Component)this.isItalicCheck, constraints);
        result.add((Component)this.useTextAntiAliaseCheck, constraints);
        result.add((Component)this.useFractionalCheck, constraints);
        return result;
    }

    private JComponent createPreviewPanel() {
        JPanel result = new JPanel();
        JScrollPane scroller = new JScrollPane(this.preview);
        scroller.getVerticalScrollBar().setUnitIncrement(8);
        TitledBorder border = BorderFactory.createTitledBorder("\u30d7\u30ec\u30d3\u30e5\u30fc");
        result.setBorder(border);
        result.setLayout(new BorderLayout());
        result.add((Component)scroller, "Center");
        return result;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font font) {
        this.selectedFont = font;
        this.updateControlls();
        this.updatePreview();
    }

    public FontRenderContext getFontRenderContext() {
        return this.renderContext;
    }

    public void setFontRenderContext(FontRenderContext renderContext) {
        this.renderContext = renderContext;
        this.updateControlls();
        this.updatePreview();
    }

    private void updatePreview() {
        this.preview.setFontInfo(this.selectedFont, this.renderContext);
    }

    private void updateControlls() {
        this.maskListener = true;
        String defaultFamily = this.selectedFont.getFamily().intern();
        this.familySelector.setSelectedValue(defaultFamily, true);
        Integer selectedInteger = new Integer(this.selectedFont.getSize());
        this.sizeSelector.setSelectedItem(selectedInteger);
        int sizeItems = this.sizeSelector.getItemCount();
        for (int index = 0; index <= sizeItems - 1; ++index) {
            Object sizeItem = this.sizeSelector.getItemAt(index);
            if (!sizeItem.equals(selectedInteger)) continue;
            this.sizeSelector.setSelectedIndex(index);
            break;
        }
        this.isBoldCheck.setSelected(this.selectedFont.isBold());
        this.isItalicCheck.setSelected(this.selectedFont.isItalic());
        this.useTextAntiAliaseCheck.setSelected(this.renderContext.isAntiAliased());
        this.useFractionalCheck.setSelected(this.renderContext.usesFractionalMetrics());
        StringBuilder arg = new StringBuilder();
        StringBuilder styleArg = new StringBuilder();
        if (this.selectedFont.isBold()) {
            styleArg.append("BOLD");
        }
        if (this.selectedFont.isItalic()) {
            styleArg.append("ITALIC");
        }
        if (styleArg.length() <= 0) {
            styleArg.append("PLAIN");
        }
        StringBuilder fontid = new StringBuilder();
        fontid.append(this.selectedFont.getFamily());
        fontid.append('-').append((CharSequence)styleArg);
        fontid.append('-').append(this.selectedFont.getSize());
        if (fontid.indexOf(" ") >= 0) {
            fontid.insert(0, '\"').append('\"');
        }
        arg.append("-initfont ").append((CharSequence)fontid);
        arg.append(" -antialias ");
        if (this.renderContext.isAntiAliased()) {
            arg.append("on");
        } else {
            arg.append("off");
        }
        arg.append(" -fractional ");
        if (this.renderContext.usesFractionalMetrics()) {
            arg.append("on");
        } else {
            arg.append("off");
        }
        this.invokeOption.setText(arg.toString());
        this.invokeOption.setCaretPosition(0);
        Rectangle2D r2d = this.selectedFont.getMaxCharBounds(this.renderContext);
        Rectangle rect = r2d.getBounds();
        String boundInfo = "\u6700\u5927\u6587\u5b57\u5bf8\u6cd5 : " + rect.width + " pixel\u5e45 \u00d7 " + rect.height + " pixel\u9ad8";
        this.maxBounds.setText(boundInfo);
        this.maskListener = false;
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.updateControlls();
            this.updatePreview();
        }
        this.lastFont = this.selectedFont;
        this.lastContext = this.renderContext;
        super.setVisible(isVisible);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (this.maskListener) {
            return;
        }
        Object source = event.getSource();
        if (source != this.isBoldCheck && source != this.isItalicCheck && source != this.useTextAntiAliaseCheck && source != this.useFractionalCheck) {
            return;
        }
        int style = 0;
        if (this.isBoldCheck.isSelected()) {
            style |= 1;
        }
        if (this.isItalicCheck.isSelected()) {
            style |= 2;
        }
        if (this.selectedFont.getStyle() != style) {
            this.selectedFont = this.selectedFont.deriveFont(style);
        }
        boolean isAntiAliases = this.useTextAntiAliaseCheck.isSelected();
        boolean useFractional = this.useFractionalCheck.isSelected();
        AffineTransform tx = this.renderContext.getTransform();
        this.renderContext = new FontRenderContext(tx, isAntiAliases, useFractional);
        this.updateControlls();
        this.updatePreview();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    private void actionApply() {
        this.isCanceled = false;
        this.setVisible(false);
    }

    private void actionCancel() {
        this.isCanceled = true;
        this.selectedFont = this.lastFont;
        this.renderContext = this.lastContext;
        this.setVisible(false);
    }

    private void actionFontSizeSelected() {
        Integer selectedInteger;
        Object selected = this.sizeSelector.getSelectedItem();
        if (selected == null) {
            return;
        }
        if (selected instanceof Integer) {
            selectedInteger = (Integer)selected;
        } else {
            try {
                selectedInteger = new Integer(selected.toString());
            }
            catch (NumberFormatException e) {
                selectedInteger = new Integer(this.lastFont.getSize());
            }
        }
        if (selectedInteger <= 0) {
            selectedInteger = new Integer(this.lastFont.getSize());
        }
        float fontSize = selectedInteger.floatValue();
        this.selectedFont = this.selectedFont.deriveFont(fontSize);
        int sizeItems = this.sizeSelector.getItemCount();
        for (int index = 0; index <= sizeItems - 1; ++index) {
            Object sizeItem = this.sizeSelector.getItemAt(index);
            if (!sizeItem.equals(selectedInteger)) continue;
            this.sizeSelector.setSelectedIndex(index);
            break;
        }
        this.updateControlls();
        this.updatePreview();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.maskListener) {
            return;
        }
        String cmd = event.getActionCommand();
        if (cmd.equals("FONTAPPLY")) {
            this.actionApply();
        } else if (cmd.equals("FONTCANCEL")) {
            this.actionCancel();
        } else if (cmd.equals("FONTSIZESEL")) {
            this.actionFontSizeSelected();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.maskListener) {
            return;
        }
        if (event.getSource() != this.familySelector) {
            return;
        }
        if (event.getValueIsAdjusting()) {
            return;
        }
        Object selected = this.familySelector.getSelectedValue();
        if (selected == null) {
            return;
        }
        String familyName = selected.toString();
        int style = this.selectedFont.getStyle();
        int size = this.selectedFont.getSize();
        this.selectedFont = new Font(familyName, style, size);
        this.updateControlls();
        this.updatePreview();
    }

    @Override
    public void windowActivated(WindowEvent event) {
    }

    @Override
    public void windowDeactivated(WindowEvent event) {
    }

    @Override
    public void windowIconified(WindowEvent event) {
    }

    @Override
    public void windowDeiconified(WindowEvent event) {
    }

    @Override
    public void windowOpened(WindowEvent event) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        this.actionCancel();
    }

    @Override
    public void windowClosed(WindowEvent event) {
    }

    static {
        CharSequence resourceText;
        FRAMETITLE = "\u767a\u8a00\u8868\u793a\u30d5\u30a9\u30f3\u30c8\u306e\u9078\u629e - " + Jindolf.TITLE;
        initFamilyNames = new String[]{"Hiragino Kaku Gothic Pro", "Hiragino Kaku Gothic Std", "Osaka", "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af"};
        pointSizes = new Integer[]{8, 10, 12, 16, 18, 24, 32, 36, 48, 72};
        familySet = FontChooser.createFontSet();
        defaultFont = FontChooser.createDefaultFont();
        defaultRenderContext = FontChooser.createDefaultFontRenderContext();
        try {
            resourceText = Jindolf.loadResourceText("resources/preview.txt");
        }
        catch (IOException e) {
            resourceText = "ABC";
        }
        previewContent = resourceText;
    }

    private static class FontPreview
    extends JComponent {
        private static int MARGIN = 5;
        private final GlyphDraw draw;
        private Font font;
        private FontRenderContext renderContext;

        public FontPreview(CharSequence source, Font font, FontRenderContext renderContext) {
            this.font = font;
            this.renderContext = renderContext;
            this.draw = new GlyphDraw(source);
            this.draw.setFontInfo(this.font, this.renderContext);
            this.draw.setPos(MARGIN, MARGIN);
            this.draw.setColor(Color.BLACK);
            this.setBackground(Color.WHITE);
            this.updateBounds();
        }

        private void updateBounds() {
            Rectangle bounds = this.draw.setWidth(Integer.MAX_VALUE);
            Dimension dimension = new Dimension(bounds.width + MARGIN * 2, bounds.height + MARGIN * 2);
            this.setPreferredSize(dimension);
            this.revalidate();
            this.repaint();
        }

        public void setFontInfo(Font font, FontRenderContext renderContext) {
            this.font = font;
            this.renderContext = renderContext;
            this.draw.setFontInfo(this.font, this.renderContext);
            this.updateBounds();
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            this.draw.paint(g2d);
        }
    }
}

