/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jp.sourceforge.jindolf.AppSetting;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;

public class HelpFrame
extends JFrame
implements ActionListener,
HyperlinkListener {
    private static final String HELP_HTML = "resources/html/help.html";
    private JTabbedPane tabPanel = new JTabbedPane();
    private JEditorPane htmlView = new JEditorPane();
    private JTextArea vmInfo = new JTextArea();
    private JButton closeButton = new JButton("\u9589\u3058\u308b");

    public HelpFrame() {
        super(Jindolf.TITLE + " \u30d8\u30eb\u30d7");
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.htmlView.setEditable(false);
        this.htmlView.setContentType("text/html");
        this.htmlView.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        this.htmlView.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.htmlView.addHyperlinkListener(this);
        this.vmInfo.setEditable(false);
        this.vmInfo.setLineWrap(true);
        this.closeButton.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                HelpFrame.this.close();
            }
        });
        URL topUrl = Jindolf.getResource(HELP_HTML);
        this.loadURL(topUrl);
        this.vmInfo.setText(AppSetting.getVMInfo());
        this.design();
    }

    private void design() {
        Container content = this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        content.setLayout(layout);
        constraints.gridwidth = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        JScrollPane sc = new JScrollPane(this.htmlView);
        this.tabPanel.add("\u30d8\u30eb\u30d7", sc);
        sc = new JScrollPane(this.vmInfo);
        this.tabPanel.add("\u5b9f\u884c\u74b0\u5883", sc);
        content.add((Component)this.tabPanel, constraints);
        constraints.weighty = 0.0;
        constraints.fill = 2;
        content.add((Component)new JSeparator(), constraints);
        constraints.weightx = 0.0;
        constraints.anchor = 13;
        constraints.fill = 0;
        content.add((Component)this.closeButton, constraints);
    }

    private void close() {
        this.setVisible(false);
    }

    private void loadURL(URL url) {
        if (url == null) {
            return;
        }
        try {
            this.htmlView.setPage(url);
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "\u30d8\u30eb\u30d7\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093", e);
            assert (false);
            throw new Error();
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() != this.closeButton) {
            return;
        }
        this.close();
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        URL url = event.getURL();
        this.loadURL(url);
    }
}

