/*
 * Village icon renderer for JTree
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: VillageIconRenderer.java 288 2008-10-19 14:19:46Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

/**
 * JTreeの村別アイコン表示
 */
@SuppressWarnings("serial")
public class VillageIconRenderer extends DefaultTreeCellRenderer{

    private static final ImageIcon prologueIcon;
    private static final ImageIcon progressIcon;
    private static final ImageIcon epilogueIcon;
    private static final ImageIcon gameoverIcon;

    static{
        URL url;
        url = Jindolf.getResource("resources/image/prologue.png");
        prologueIcon = new ImageIcon(url);
        url = Jindolf.getResource("resources/image/progress.png");
        progressIcon = new ImageIcon(url);
        url = Jindolf.getResource("resources/image/epilogue.png");
        epilogueIcon = new ImageIcon(url);
        url = Jindolf.getResource("resources/image/gameover.png");
        gameoverIcon = new ImageIcon(url);
    }

    /**
     * {@inheritDoc}
     * 村種別によってツリーリストアイコンを書き分ける。
     * @param tree {@inheritDoc}
     * @param value {@inheritDoc}
     * @param sel {@inheritDoc}
     * @param expanded {@inheritDoc}
     * @param leaf {@inheritDoc}
     * @param row {@inheritDoc}
     * @param hasFocus {@inheritDoc}
     * @return {@inheritDoc}
     */
    @Override
    public Component getTreeCellRendererComponent(
            JTree tree,
            Object value,
            boolean sel,
            boolean expanded,
            boolean leaf,
            int row,
            boolean hasFocus ){
        if(leaf && value instanceof Village){
            Village village = (Village) value;
            switch(village.getState()){
            case PROLOGUE:
                setLeafIcon(prologueIcon);
                break;
            case PROGRESS:
                setLeafIcon(progressIcon);
                break;
            case EPILOGUE:
                setLeafIcon(epilogueIcon);
                break;
            case GAMEOVER:
                setLeafIcon(gameoverIcon);
                break;
            }
        }

        Component comp =
                super
                .getTreeCellRendererComponent(
                    tree,
                    value,
                    sel,
                    expanded,
                    leaf,
                    row,
                    hasFocus
                );

        return comp;
    }
}
