/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexPattern {
    private final String editSource;
    private final boolean isRegex;
    private final Pattern pattern;
    private final String comment;

    public RegexPattern(String editSource, boolean isRegex, int flag, String comment) throws PatternSyntaxException {
        this.editSource = editSource;
        this.isRegex = isRegex;
        this.comment = comment;
        String regexExpr = this.isRegex ? this.editSource : Pattern.quote(this.editSource);
        this.pattern = Pattern.compile(regexExpr, flag);
    }

    public RegexPattern(String editSource, boolean isRegex, int flag) throws PatternSyntaxException {
        this(editSource, isRegex, flag, " ");
    }

    public String getEditSource() {
        return this.editSource;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isRegex() {
        return this.isRegex;
    }

    public int getFlag() {
        return this.pattern.flags();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.editSource;
    }

    public boolean equals(Object obj) {
        String otherPattern;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPattern)) {
            return false;
        }
        RegexPattern other = (RegexPattern)obj;
        String thisPattern = this.pattern.pattern();
        if (!thisPattern.equals(otherPattern = other.pattern.pattern())) {
            return false;
        }
        return this.pattern.flags() == other.pattern.flags();
    }

    public int hashCode() {
        int hash = this.pattern.pattern().hashCode();
        return hash ^= this.pattern.flags();
    }
}

