/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class AccountCookie {
    private static final String datePattern = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final SimpleDateFormat dform;
    private final String loginData;
    private final URI pathURI;
    private final Date expireDate;

    public AccountCookie(String loginData, String path, Date expireDate) throws NullPointerException, IllegalArgumentException {
        if (loginData == null || path == null || expireDate == null) {
            throw new NullPointerException();
        }
        this.loginData = loginData;
        try {
            this.pathURI = new URI(path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(path, e);
        }
        this.expireDate = expireDate;
    }

    public boolean hasExpired() {
        long nowMs = System.currentTimeMillis();
        long expireMs = this.expireDate.getTime();
        return expireMs < nowMs;
    }

    public URI getPathURI() {
        return this.pathURI;
    }

    public String getLoginData() {
        return this.loginData;
    }

    public static AccountCookie createCookie(String cookieSource) {
        Date date;
        String[] cookieParts = cookieSource.split("; ");
        if (cookieParts == null) {
            return null;
        }
        if (cookieParts.length <= 0) {
            return null;
        }
        String login = null;
        String path = null;
        String expires = null;
        for (String part : cookieParts) {
            String[] nmval = part.split("=", 2);
            if (nmval == null || nmval.length != 2) continue;
            String name = nmval[0];
            String value = nmval[1];
            if (name.equals("login")) {
                login = value;
                continue;
            }
            if (name.equals("path")) {
                path = value;
                continue;
            }
            if (!name.equals("expires")) continue;
            expires = value;
        }
        if (login == null || path == null || expires == null) {
            return null;
        }
        try {
            date = dform.parse(expires);
        }
        catch (ParseException e) {
            return null;
        }
        AccountCookie cookie = new AccountCookie(login, path, date);
        return cookie;
    }

    public static AccountCookie createCookie(HttpURLConnection connection) {
        String cookieHeader = connection.getHeaderField("Set-Cookie");
        if (cookieHeader == null) {
            return null;
        }
        AccountCookie cookie = AccountCookie.createCookie(cookieHeader);
        return cookie;
    }

    public String toString() {
        return this.loginData;
    }

    static {
        GregorianCalendar gregorian = new GregorianCalendar();
        TimeZone zoneGMT = TimeZone.getTimeZone("GMT");
        DateFormatSymbols customSyms = new DateFormatSymbols();
        String[] sweekdays = customSyms.getShortWeekdays();
        sweekdays[1] = "Sun";
        sweekdays[2] = "Mon";
        sweekdays[3] = "Tue";
        sweekdays[4] = "Wed";
        sweekdays[5] = "Thu";
        sweekdays[6] = "Fri";
        sweekdays[7] = "Sat";
        customSyms.setShortWeekdays(sweekdays);
        String[] months = customSyms.getShortMonths();
        months[0] = "Jan";
        months[1] = "Feb";
        months[2] = "Mar";
        months[3] = "Apr";
        months[4] = "May";
        months[5] = "Jun";
        months[6] = "Jul";
        months[7] = "Aug";
        months[8] = "Sep";
        months[9] = "Oct";
        months[10] = "Nov";
        months[11] = "Dec";
        customSyms.setShortMonths(months);
        dform = new SimpleDateFormat(datePattern);
        dform.setCalendar(gregorian);
        dform.setTimeZone(zoneGMT);
        dform.setDateFormatSymbols(customSyms);
        dform.setLenient(true);
    }
}

