/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.sourceforge.jindolf.Jindolf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Avatar
implements Comparable<Avatar> {
    private static final String AVATAR_DEF = "resources/avatar.properties";
    private static final String KEY_PREFIX = "avatar.serialNo.";
    private static final SortedSet<Avatar> predefinedAvatarSet = Avatar.loadPredefSet();
    private static final Map<String, Avatar> avatarMap = new TreeMap<String, Avatar>();
    private final String name;
    private final String jobTitle;
    private final String fullName;
    private final int idNum;
    private final String identifier;

    private static SortedSet<Avatar> loadPredefSet() {
        InputStream is = Jindolf.getResourceAsStream(AVATAR_DEF);
        return Avatar.loadPredefSet(is);
    }

    private static SortedSet<Avatar> loadPredefSet(InputStream is) {
        Properties properties = new Properties();
        try {
            properties.load(is);
            is.close();
        }
        catch (IOException e) {
            assert (false);
            throw new Error();
        }
        return Avatar.loadPredefSet(properties);
    }

    private static SortedSet<Avatar> loadPredefSet(Properties properties) {
        Integer serialInt;
        String codeCheck = properties.getProperty("codeCheck");
        if (codeCheck == null || codeCheck.length() != 1 || codeCheck.charAt(0) != '\u72fc') {
            Jindolf.logger.severe("\u30ad\u30e3\u30e9\u30af\u30bf\u5b9a\u7fa9\u4e00\u89a7\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u304a\u304b\u3057\u3044\u3088\u3046\u3067\u3059\u3002native2ascii \u306f\u6b63\u3057\u304f\u9069\u7528\u3057\u307e\u3057\u305f\u304b\uff1f");
            Jindolf.exit(1);
            throw new Error();
        }
        Set<Object> keySet = properties.keySet();
        TreeMap<String, Integer> idSerialMap = new TreeMap<String, Integer>();
        for (Object keyObj : keySet) {
            String key;
            if (keyObj == null || !(key = keyObj.toString()).startsWith(KEY_PREFIX)) continue;
            String id = properties.getProperty(key);
            String serialNo = key.replace(KEY_PREFIX, "");
            try {
                serialInt = new Integer(serialNo);
            }
            catch (NumberFormatException e) {
                continue;
            }
            idSerialMap.put(id, serialInt);
        }
        TreeSet<Avatar> result = new TreeSet();
        for (String id : idSerialMap.keySet()) {
            String nameKey = id + ".name";
            String jobKey = id + ".job";
            serialInt = (Integer)idSerialMap.get(id);
            String name = properties.getProperty(nameKey);
            String job = properties.getProperty(jobKey);
            Avatar avatar = new Avatar(name, job, serialInt, id);
            result.add(avatar);
        }
        result = Collections.unmodifiableSortedSet(result);
        return result;
    }

    public static SortedSet<Avatar> getPredefinedAvatarSet() {
        return predefinedAvatarSet;
    }

    public static Avatar getPredefinedAvatar(String fullName) {
        return avatarMap.get(fullName);
    }

    private Avatar(String name, String jobTitle, int idNum, String identifier) {
        this.name = name.intern();
        this.jobTitle = jobTitle.intern();
        this.idNum = idNum;
        this.identifier = identifier.intern();
        this.fullName = (this.jobTitle + " " + this.name).intern();
    }

    public Avatar(String fullName) {
        this.fullName = fullName.intern();
        this.idNum = -1;
        String[] tokens = this.fullName.split("\\p{Blank}+", 2);
        if (tokens.length == 1) {
            this.jobTitle = null;
            this.name = this.fullName;
        } else if (tokens.length == 2) {
            this.jobTitle = tokens[0].intern();
            this.name = tokens[1].intern();
        } else {
            this.jobTitle = null;
            this.name = null;
            assert (false);
        }
        this.identifier = "???".intern();
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getName() {
        return this.name;
    }

    public int getIdNum() {
        return this.idNum;
    }

    public boolean equals(Object obj) {
        boolean idMatch;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Avatar)) {
            return false;
        }
        Avatar other = (Avatar)obj;
        boolean nameMatch = this.fullName.equals(other.fullName);
        boolean bl = idMatch = this.idNum == other.idNum;
        return nameMatch && idMatch;
    }

    public int hashCode() {
        return this.fullName.hashCode() ^ this.idNum;
    }

    @Override
    public int compareTo(Avatar avatar) {
        if (avatar == null) {
            return 1;
        }
        return this.idNum - avatar.idNum;
    }

    static {
        for (Avatar avatar : predefinedAvatarSet) {
            String fullName = avatar.getFullName();
            avatarMap.put(fullName, avatar);
        }
    }
}

