/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.NetUtil;
import jp.sourceforge.jindolf.ServerAccess;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Land {
    private static final String Spchar = " \\t\\n\\r";
    private static final String Sp = "[ \\t\\n\\r]";
    private static final String Sp_n = "[ \\t\\n\\r]*";
    private static final String Sp_m = "[ \\t\\n\\r]+";
    private static final Pattern iso8601Regex;
    private static final Pattern anchorRegex;
    public static final Date DATE_UNKNOWN;
    private final String landName;
    private final String landIdentifier;
    private final String landPrefix;
    private final ServerAccess serverAccess;
    private final Date startDate;
    private final Date endDate;
    private final Type type;
    private final Locale locale;
    private final TimeZone timeZone;
    private final String description;
    private final String contactInfo;
    private final List<Village> villageList = new LinkedList<Village>();

    private static Date parseISO8601(CharSequence date) throws IllegalArgumentException {
        int second;
        int minute;
        int hour;
        int day;
        int month;
        int year;
        Matcher matcher = iso8601Regex.matcher(date);
        if (!matcher.lookingAt()) {
            throw new IllegalArgumentException(((Object)date).toString());
        }
        String yearStr = matcher.group(1);
        String monthStr = matcher.group(2);
        String dayStr = matcher.group(3);
        String hourStr = matcher.group(4);
        String minuteStr = matcher.group(5);
        String secondStr = matcher.group(6);
        String tzString = matcher.group(7);
        try {
            year = Integer.parseInt(yearStr);
            month = Integer.parseInt(monthStr);
            day = Integer.parseInt(dayStr);
            hour = Integer.parseInt(hourStr);
            minute = Integer.parseInt(minuteStr);
            second = Integer.parseInt(secondStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(((Object)date).toString(), e);
        }
        String tzID = "GMT";
        tzID = tzString.compareToIgnoreCase("Z") == 0 ? tzID + "+00:00" : tzID + tzString;
        TimeZone timezone = TimeZone.getTimeZone(tzID);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        calendar.setTimeZone(timezone);
        calendar.set(year, month - 1, day, hour, minute, second);
        Date result = calendar.getTime();
        return result;
    }

    public Land(String landName, String landIdentifier, String landPrefix, URL baseURL, Date startDate, Date endDate, Type type, Locale locale, TimeZone timeZone, String description, String contactInfo) {
        this.landName = landName;
        this.landIdentifier = landIdentifier;
        this.landPrefix = landPrefix;
        this.serverAccess = new ServerAccess(baseURL);
        this.startDate = startDate;
        this.endDate = endDate;
        this.type = type;
        this.locale = locale;
        this.timeZone = timeZone;
        this.description = description;
        this.contactInfo = contactInfo;
    }

    public Land(String landId, Properties properties) throws NullPointerException, IllegalArgumentException {
        URL url;
        if (landId == null || properties == null) {
            throw new NullPointerException();
        }
        if (landId.length() <= 0) {
            throw new IllegalArgumentException();
        }
        this.landIdentifier = landId;
        String value = properties.getProperty(landId + ".landname");
        if (value == null || value.length() <= 0) {
            throw new IllegalArgumentException();
        }
        this.landName = value;
        this.landPrefix = value = properties.getProperty(landId + ".prefix", "");
        value = properties.getProperty(landId + ".baseurl");
        if (value == null || value.length() <= 0) {
            throw new IllegalArgumentException();
        }
        try {
            url = new URL(value);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(value, e);
        }
        this.serverAccess = new ServerAccess(url);
        value = properties.getProperty(landId + ".startdate");
        Date date = value == null || value.length() <= 0 ? DATE_UNKNOWN : Land.parseISO8601(value);
        this.startDate = date;
        value = properties.getProperty(landId + ".enddate");
        date = value == null || value.length() <= 0 ? DATE_UNKNOWN : Land.parseISO8601(value);
        this.endDate = date;
        this.contactInfo = value = properties.getProperty(landId + ".contact", "");
        this.description = value = properties.getProperty(landId + ".description", "");
        String lang = "";
        String country = "";
        String variant = "";
        value = properties.getProperty(landId + ".locale");
        if (value == null || value.length() <= 0) {
            throw new IllegalArgumentException();
        }
        String[] lcstr = value.split("_", 3);
        if (lcstr.length >= 1) {
            lang = lcstr[0];
        }
        if (lcstr.length >= 2) {
            country = lcstr[1];
        }
        if (lcstr.length >= 3) {
            variant = lcstr[2];
        }
        this.locale = new Locale(lang, country, variant);
        value = properties.getProperty(landId + ".timezone");
        if (value == null || value.length() <= 0) {
            throw new IllegalArgumentException();
        }
        this.timeZone = TimeZone.getTimeZone(value);
        value = properties.getProperty(landId + ".state");
        if (value == null || value.length() <= 0) {
            throw new IllegalArgumentException();
        }
        if (value.compareToIgnoreCase("CLOSED") == 0) {
            this.type = Type.CLOSED;
        } else if (value.compareToIgnoreCase("HISTORICAL") == 0) {
            this.type = Type.HISTORICAL;
        } else if (value.compareToIgnoreCase("ACTIVE") == 0) {
            this.type = Type.ACTIVE;
        } else {
            throw new IllegalArgumentException(value);
        }
    }

    public String getLandName() {
        return this.landName;
    }

    public String getLandIdentifier() {
        return this.landIdentifier;
    }

    public String getLandPrefix() {
        return this.landPrefix;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Type getType() {
        return this.type;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContactInfo() {
        return this.contactInfo;
    }

    public ServerAccess getServerAccess() {
        return this.serverAccess;
    }

    public Village getVillage(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.getVillageCount()) {
            return null;
        }
        Village result = this.villageList.get(index);
        return result;
    }

    public int getVillageCount() {
        int result = this.villageList.size();
        return result;
    }

    public List<Village> getVillageList() {
        return Collections.unmodifiableList(this.villageList);
    }

    public Image downloadImage(String imageURL) {
        Image image;
        ServerAccess server = this.getServerAccess();
        try {
            image = server.downloadImage(imageURL);
        }
        catch (IOException e) {
            Jindolf.logger.log(Level.WARNING, "\u30a4\u30e1\u30fc\u30b8[" + imageURL + "]" + "\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
            return null;
        }
        return image;
    }

    public static String getValueFromCGIQueries(String key, String allQuery) {
        String result = null;
        String[] queries = allQuery.split("\\Q&\\E");
        if (queries == null) {
            return null;
        }
        for (String pair : queries) {
            String[] namevalue;
            if (pair == null || (namevalue = pair.split("\\Q=\\E")) == null || namevalue.length != 2) continue;
            String name = namevalue[0];
            String value = namevalue[1];
            if (name != null && name.equals(key) && (result = value) != null && result.length() > 0) break;
        }
        return result;
    }

    public static String getVillageIDFromHREF(CharSequence hrefValue) {
        String allQuery = NetUtil.getQueryFromHREF(hrefValue);
        if (allQuery == null) {
            return null;
        }
        String villageID = Land.getValueFromCGIQueries("vid", allQuery);
        if (villageID == null) {
            return null;
        }
        if (villageID.length() <= 0) {
            return null;
        }
        return villageID;
    }

    private Collection<Village> parseVillageList(CharSequence html) {
        Vector<Village> result = new Vector<Village>();
        Matcher matcher = anchorRegex.matcher(html);
        while (matcher.find()) {
            String villageID;
            String hrefValue = matcher.group(1);
            String anchorText = matcher.group(2);
            String option = matcher.group(3);
            if (hrefValue == null || hrefValue.length() <= 0) continue;
            if (anchorText == null) {
                anchorText = "";
            }
            if ((villageID = Land.getVillageIDFromHREF(hrefValue)) == null || villageID.length() <= 0) continue;
            String villageName = anchorText.replaceAll(Sp_m, " ").trim();
            String[] parts = villageName.split(" ");
            if (parts != null && parts[0] != null && parts[0].equals(villageID)) {
                villageName = this.landPrefix + villageName;
            }
            Village village = new Village(this, villageID, villageName);
            Village.State state = option == null || this.getType() == Type.HISTORICAL ? Village.State.GAMEOVER : (option.equals("\u53c2\u52a0\u8005\u52df\u96c6\u4e2d\u3067\u3059\u3002") ? Village.State.PROLOGUE : (option.equals("\u958b\u59cb\u5f85\u3061\u3067\u3059\u3002") ? Village.State.PROLOGUE : (option.equals("\u9032\u884c\u4e2d\u3067\u3059\u3002") ? Village.State.PROGRESS : (option.equals("\u52dd\u6557\u304c\u6c7a\u5b9a\u3057\u307e\u3057\u305f\u3002") ? Village.State.EPILOGUE : (option.equals("\u7d42\u4e86\u30fb\u30ed\u30b0\u516c\u958b\u4e2d\u3002") ? Village.State.GAMEOVER : Village.State.UNKNOWN)))));
            village.setState(state);
            result.add(village);
        }
        return result;
    }

    public void updateVillageList() throws IOException {
        TreeSet<Village> vset = new TreeSet<Village>();
        ServerAccess server = this.getServerAccess();
        CharSequence html = server.getHTMLTopPage();
        Collection<Village> vcol = this.parseVillageList(html);
        vset.addAll(vcol);
        html = server.getHTMLLandList();
        vcol = this.parseVillageList(html);
        vset.addAll(vcol);
        this.villageList.clear();
        this.villageList.addAll(vset);
    }

    public String toString() {
        return this.landName;
    }

    static {
        DATE_UNKNOWN = new Date(-1L);
        String year = "([0-9][0-9][0-9][0-9])";
        String month = "([0-1][0-9])";
        String day = "([0-3][0-9])";
        String hour = "([0-2][0-9])";
        String minute = "([0-5][0-9])";
        String second = "([0-6][0-9])";
        String timezone = "([\\+\\-][0-2][0-9](?::?[0-5][0-9])?|Z)";
        String iso8601 = year + "\\-" + month + "\\-" + day + "T" + hour + ":" + minute + ":" + second + timezone;
        String anchorStart = "<a[ \\t\\n\\r]+href=\"([^\"]*)\"[ \\t\\n\\r]*>";
        String anchorClose = "</a>";
        String deadline = "[ \\t\\n\\r]*<strong>[^<]*</strong>[ \\t\\n\\r]*</td>";
        String status = "[ \\t\\n\\r]*<td>([^<]*)</td>";
        String option = "(?:" + deadline + status + ")?";
        String anchor = anchorStart + "([^<]*)" + anchorClose + option;
        iso8601Regex = Pattern.compile(iso8601);
        anchorRegex = Pattern.compile(anchor, 32);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CLOSED,
        HISTORICAL,
        ACTIVE;

    }
}

