/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import jp.sourceforge.jindolf.AccountCookie;
import jp.sourceforge.jindolf.CountInputStream;
import jp.sourceforge.jindolf.HttpUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Village;

public class ServerAccess {
    private static final String USER_AGENT = HttpUtils.getUserAgentName();
    private static final String ENCODING_HTML = "Shift_JIS";
    private static final Charset CHARSET_SJIS = Charset.forName("Shift_JIS");
    private static final int BUF_SIZE = 1024;
    private static final String JINRO_CGI = "./index.rb";
    private static final Map<String, SoftReference<Image>> imageCache;
    private static final NumberFormat throughputFormat;
    private static final NumberFormat sizeFormat;
    private final URL baseURL;
    private final URL cgiURL;
    private long lastServerMs;
    private long lastLocalMs;
    private long lastSystemMs;
    private AccountCookie cookieAuth = null;
    private String encodedUserID = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image getImageCache(String key) {
        Image image;
        if (key == null) {
            return null;
        }
        Map<String, SoftReference<Image>> map = imageCache;
        synchronized (map) {
            SoftReference<Image> ref = imageCache.get(key);
            if (ref == null) {
                return null;
            }
            Image referent = ref.get();
            if (referent == null) {
                imageCache.remove(key);
                return null;
            }
            image = referent;
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putImageCache(String key, Image image) {
        if (key == null || image == null) {
            return;
        }
        Map<String, SoftReference<Image>> map = imageCache;
        synchronized (map) {
            if (ServerAccess.getImageCache(key) != null) {
                return;
            }
            SoftReference<Image> ref = new SoftReference<Image>(image);
            imageCache.put(key, ref);
        }
    }

    public static String formEncode(String formData) {
        String result;
        if (formData == null) {
            return null;
        }
        try {
            result = URLEncoder.encode(formData, ENCODING_HTML);
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            result = null;
        }
        return result;
    }

    public static String formEncode(char[] formData) {
        return ServerAccess.formEncode(new String(formData));
    }

    public static CharSequence downloadHTMLStream(InputStream is) throws IOException {
        int chs;
        StringBuilder result = new StringBuilder();
        Reader reader = new InputStreamReader(is, CHARSET_SJIS);
        reader = new BufferedReader(reader, 1024);
        char[] buffer = new char[1024];
        while ((chs = reader.read(buffer)) > 0) {
            result.append(buffer, 0, chs);
        }
        reader.close();
        return result;
    }

    private static String throughput(long size, long nano) {
        double sec = (double)nano / 1.0E9;
        double rate = (double)size / sec;
        String unit = "";
        if (rate >= 1500.0) {
            rate /= 1000.0;
            unit = "K";
        }
        if (rate >= 1500.0) {
            rate /= 1000.0;
            unit = "M";
        }
        String result = sizeFormat.format(size) + "Bytes " + throughputFormat.format(rate) + unit + "Bytes/sec";
        return result;
    }

    public ServerAccess(URL baseURL) {
        this.baseURL = baseURL;
        try {
            this.cgiURL = new URL(this.baseURL, JINRO_CGI);
        }
        catch (MalformedURLException e) {
            assert (false);
            throw new Error();
        }
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    protected URL getQueryURL(String query) {
        URL result;
        if (query.length() >= 1 && query.charAt(0) != '?') {
            return null;
        }
        try {
            result = new URL(this.cgiURL, query);
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        return result;
    }

    protected CharSequence downloadHTML(String query) throws IOException {
        URL url = this.getQueryURL(query);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        connection.setDoInput(true);
        connection.setRequestMethod("GET");
        AccountCookie cookie = this.cookieAuth;
        if (cookie != null) {
            if (ServerAccess.shouldAccept(url, cookie)) {
                connection.setRequestProperty("Cookie", "login=" + cookie.getLoginData());
            } else {
                this.clearAuthentication();
            }
        }
        long nanoLap = System.nanoTime();
        connection.connect();
        this.updateLastAccess(connection);
        int responseCode = connection.getResponseCode();
        String responseMessage = connection.getResponseMessage();
        String logMessage = "GET " + url + " [" + responseCode + " " + responseMessage + "]";
        if (responseCode != 200) {
            logMessage = "\u767a\u8a00\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 " + logMessage;
            Jindolf.logger.log(Level.WARNING, logMessage);
            return null;
        }
        String charset = HttpUtils.getHTMLCharset(connection);
        if (!charset.equalsIgnoreCase(ENCODING_HTML)) {
            return null;
        }
        InputStream stream = connection.getInputStream();
        stream = new BufferedInputStream(stream, 512);
        CountInputStream cistream = new CountInputStream(stream);
        CharSequence html = ServerAccess.downloadHTMLStream(cistream);
        cistream.close();
        connection.disconnect();
        nanoLap = System.nanoTime() - nanoLap;
        long htmlSize = cistream.getCount();
        String throughput = ServerAccess.throughput(htmlSize, nanoLap);
        logMessage = logMessage + " " + throughput;
        Jindolf.logger.info(logMessage);
        return html;
    }

    public Image downloadImage(String url) throws IOException {
        URL absolute;
        try {
            URL base = this.getBaseURL();
            absolute = new URL(base, url);
        }
        catch (MalformedURLException e) {
            assert (false);
            return null;
        }
        Image image = ServerAccess.getImageCache(absolute.toString());
        if (image != null) {
            return image;
        }
        HttpURLConnection connection = (HttpURLConnection)absolute.openConnection();
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setUseCaches(true);
        connection.setInstanceFollowRedirects(true);
        connection.setDoInput(true);
        connection.setRequestMethod("GET");
        long nanoLap = System.nanoTime();
        connection.connect();
        int responseCode = connection.getResponseCode();
        String responseMessage = connection.getResponseMessage();
        String logMessage = "GET " + absolute + " [" + responseCode + " " + responseMessage + "]";
        if (responseCode != 200) {
            logMessage = "\u30a4\u30e1\u30fc\u30b8\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 " + logMessage;
            Jindolf.logger.log(Level.WARNING, logMessage);
            return null;
        }
        InputStream stream = connection.getInputStream();
        stream = new BufferedInputStream(stream, 512);
        CountInputStream cistream = new CountInputStream(stream);
        image = ImageIO.read(cistream);
        cistream.close();
        connection.disconnect();
        nanoLap = System.nanoTime() - nanoLap;
        long imageSize = cistream.getCount();
        String throughput = ServerAccess.throughput(imageSize, nanoLap);
        logMessage = logMessage + " " + throughput;
        Jindolf.logger.info(logMessage);
        ServerAccess.putImageCache(absolute.toString(), image);
        return image;
    }

    protected boolean postAuthData(String authData) throws IOException {
        URL url = this.getBaseURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        byte[] authBytes = authData.getBytes();
        OutputStream os = connection.getOutputStream();
        long nanoLap = System.nanoTime();
        os.write(authBytes);
        os.flush();
        os.close();
        this.updateLastAccess(connection);
        int responseCode = connection.getResponseCode();
        String responseMessage = connection.getResponseMessage();
        String logMessage = "POST " + url + " [" + responseCode + " " + responseMessage + "]";
        if (responseCode != 302) {
            logMessage = "\u8a8d\u8a3c\u60c5\u5831\u306e\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 " + logMessage;
            Jindolf.logger.log(Level.WARNING, logMessage);
            return false;
        }
        connection.disconnect();
        nanoLap = System.nanoTime() - nanoLap;
        long sendSize = authBytes.length;
        String throughput = ServerAccess.throughput(sendSize, nanoLap);
        logMessage = logMessage + " " + throughput;
        Jindolf.logger.info(logMessage);
        AccountCookie loginCookie = AccountCookie.createCookie(connection);
        if (loginCookie == null) {
            return false;
        }
        this.setAuthentication(loginCookie);
        return true;
    }

    public CharSequence getHTMLTopPage() throws IOException {
        return this.downloadHTML("");
    }

    public CharSequence getHTMLLandList() throws IOException {
        return this.downloadHTML("?cmd=log");
    }

    public CharSequence getHTMLBoneHead(Village village) throws IOException {
        String villageID = village.getVillageID();
        return this.downloadHTML("?vid=" + villageID + "&meslog=");
    }

    public CharSequence getHTMLVillage(Village village) throws IOException {
        String villageID = village.getVillageID();
        return this.downloadHTML("?vid=" + villageID);
    }

    public CharSequence getHTMLPeriod(Period period) throws IOException {
        String query = period.getCGIQuery();
        return this.downloadHTML(query);
    }

    public void updateLastAccess(HttpURLConnection connection) {
        this.lastServerMs = connection.getDate();
        this.lastLocalMs = System.currentTimeMillis();
        this.lastSystemMs = System.nanoTime() / 1000000L;
    }

    private static boolean shouldAccept(URL url, AccountCookie cookie) {
        String cookiePath;
        if (cookie.hasExpired()) {
            return false;
        }
        String urlPath = url.getPath();
        return urlPath.startsWith(cookiePath = cookie.getPathURI().getPath());
    }

    public boolean hasLoggedIn() {
        AccountCookie cookie = this.cookieAuth;
        if (cookie == null) {
            return false;
        }
        if (cookie.hasExpired()) {
            this.clearAuthentication();
            return false;
        }
        return true;
    }

    public final boolean login(String userID, char[] password) throws IOException {
        boolean result;
        if (this.hasLoggedIn()) {
            return true;
        }
        String id = ServerAccess.formEncode(userID);
        if (id == null || id.length() <= 0) {
            return false;
        }
        String pw = ServerAccess.formEncode(password);
        if (pw == null || pw.length() <= 0) {
            return false;
        }
        this.encodedUserID = id;
        String redirect = ServerAccess.formEncode("&#bottom");
        StringBuilder postData = new StringBuilder();
        postData.append("cmd=login");
        postData.append('&').append("cgi_param=").append(redirect);
        postData.append('&').append("user_id=").append(id);
        postData.append('&').append("password=").append(pw);
        try {
            result = this.postAuthData(postData.toString());
        }
        catch (IOException e) {
            this.clearAuthentication();
            throw e;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws IOException {
        if (!this.hasLoggedIn()) {
            return;
        }
        if (this.encodedUserID == null) {
            this.clearAuthentication();
            return;
        }
        String redirect = ServerAccess.formEncode("&#bottom");
        StringBuilder postData = new StringBuilder();
        postData.append("cmd=logout");
        postData.append('&').append("cgi_param=").append(redirect);
        postData.append('&').append("user_id=").append(this.encodedUserID);
        try {
            this.postAuthData(postData.toString());
        }
        finally {
            this.clearAuthentication();
        }
    }

    protected void clearAuthentication() {
        this.cookieAuth = null;
        this.encodedUserID = null;
    }

    private void setAuthentication(AccountCookie cookie) {
        this.cookieAuth = cookie;
    }

    static {
        HashMap cache = new HashMap();
        imageCache = Collections.synchronizedMap(cache);
        throughputFormat = NumberFormat.getInstance();
        throughputFormat.setMaximumFractionDigits(1);
        throughputFormat.setMinimumFractionDigits(1);
        throughputFormat.setGroupingUsed(true);
        sizeFormat = NumberFormat.getInstance();
        sizeFormat.setGroupingUsed(true);
    }
}

