/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import jp.sourceforge.jindolf.ClipboardAction;
import jp.sourceforge.jindolf.EditArray;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.TalkEditor;
import jp.sourceforge.jindolf.TextEditor;
import jp.sourceforge.jindolf.TextPopup;

public class TalkPreview
extends JFrame
implements ActionListener,
ChangeListener {
    private static final String FRAMETITLE = "\u767a\u8a00\u30a8\u30c7\u30a3\u30bf - " + Jindolf.TITLE;
    private static final Color COLOR_EDITORBACK = Color.BLACK;
    private final JTextComponent freeMemo = new TextEditor();
    private final EditArray editArray = new EditArray();
    private final JButton cutButton = new JButton("\u30ab\u30c3\u30c8");
    private final JButton copyButton = new JButton("\u30b3\u30d4\u30fc");
    private final JButton cutAllButton = new JButton("\u5168\u30ab\u30c3\u30c8");
    private final JButton copyAllButton = new JButton("\u5168\u30b3\u30d4\u30fc");
    private final JButton closeButton = new JButton("\u9589\u3058\u308b");
    private final TitledBorder numberBorder = new TitledBorder("");
    private final JComponent singleGroup = this.buildSingleGroup();
    private final JComponent multiGroup = this.buildMultiGroup();

    public TalkPreview(Frame owner) {
        super(FRAMETITLE);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        this.setDefaultCloseOperation(1);
        this.cutButton.addActionListener(this);
        this.copyButton.addActionListener(this);
        this.cutAllButton.addActionListener(this);
        this.copyAllButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.editArray.addChangeListener(this);
        Container content = this.getContentPane();
        this.design(content);
        this.setBorderNumber(1);
    }

    private void design(Container content) {
        JComponent freeNotePanel = this.buildFreeNotePanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        JViewport viewPort = new JViewport();
        viewPort.setBackground(COLOR_EDITORBACK);
        viewPort.setView(this.editArray);
        scrollPane.setViewport(viewPort);
        JPanel editPanel = new JPanel();
        BorderLayout layout = new BorderLayout();
        editPanel.setLayout(layout);
        editPanel.add((Component)scrollPane, "Center");
        JComponent buttonPanel = this.buildButtonPanel();
        editPanel.add((Component)buttonPanel, "East");
        TitledBorder border = BorderFactory.createTitledBorder("\u767a\u8a00\u7de8\u96c6");
        editPanel.setBorder(border);
        JSplitPane split = new JSplitPane();
        split.setOrientation(1);
        split.setContinuousLayout(false);
        split.setDividerSize(10);
        split.setDividerLocation(200);
        split.setOneTouchExpandable(true);
        split.setLeftComponent(freeNotePanel);
        split.setRightComponent(editPanel);
        layout = new BorderLayout();
        content.setLayout(layout);
        content.add((Component)split, "Center");
    }

    private JComponent buildButtonPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = -1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.singleGroup, constraints);
        constraints.insets = new Insets(10, 3, 3, 3);
        panel.add((Component)this.multiGroup, constraints);
        constraints.weighty = 1.0;
        constraints.anchor = 15;
        constraints.insets = new Insets(3, 3, 10, 3);
        panel.add((Component)this.closeButton, constraints);
        return panel;
    }

    private JComponent buildSingleGroup() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = -1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.cutButton, constraints);
        panel.add((Component)this.copyButton, constraints);
        panel.setBorder(this.numberBorder);
        return panel;
    }

    private JComponent buildMultiGroup() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = -1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.insets = new Insets(3, 3, 3, 3);
        panel.add((Component)this.cutAllButton, constraints);
        panel.add((Component)this.copyAllButton, constraints);
        TitledBorder border = BorderFactory.createTitledBorder("\u5168\u767a\u8a00\u3092");
        panel.setBorder(border);
        return panel;
    }

    private JComponent buildFreeNotePanel() {
        Insets margin = new Insets(3, 3, 3, 3);
        this.freeMemo.setMargin(margin);
        TextPopup popup = new TextPopup();
        this.freeMemo.setComponentPopupMenu(popup);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setHorizontalScrollBarPolicy(31);
        JViewport viewPort = new JViewport();
        viewPort.setView(this.freeMemo);
        scrollPane.setViewport(viewPort);
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(layout);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)scrollPane, constraints);
        TitledBorder border = BorderFactory.createTitledBorder("\u30d5\u30ea\u30fc\u30e1\u30e2");
        panel.setBorder(border);
        return panel;
    }

    private void setBorderNumber(int num) {
        String title = "\u767a\u8a00#" + num + " \u3092";
        this.numberBorder.setTitle(title);
        this.singleGroup.revalidate();
        this.singleGroup.repaint();
    }

    public void setTextFont(Font textFont) {
        this.freeMemo.setFont(textFont);
        this.editArray.setTextFont(textFont);
    }

    public Font getTextFont() {
        return this.editArray.getTextFont();
    }

    private TalkEditor actionCutActive() {
        TalkEditor activeEditor = this.actionCopyActive();
        if (activeEditor == null) {
            return null;
        }
        activeEditor.clearText();
        return activeEditor;
    }

    private TalkEditor actionCopyActive() {
        TalkEditor activeEditor = this.editArray.getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        String text = activeEditor.getText();
        ClipboardAction.copyToClipBoard(text);
        return activeEditor;
    }

    private void actionCutAll() {
        this.actionCopyAll();
        this.editArray.clearAllEditor();
    }

    private void actionCopyAll() {
        CharSequence text = this.editArray.getAllText();
        ClipboardAction.copyToClipBoard(text);
    }

    private void actionClose() {
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.cutButton) {
            this.actionCutActive();
        } else if (source == this.copyButton) {
            this.actionCopyActive();
        } else if (source == this.cutAllButton) {
            this.actionCutAll();
        } else if (source == this.copyAllButton) {
            this.actionCopyAll();
        } else if (source == this.copyAllButton) {
            this.actionCopyAll();
        } else if (source == this.closeButton) {
            this.actionClose();
        }
    }

    public void stateChanged(ChangeEvent event) {
        TalkEditor activeEditor = this.editArray.getActiveEditor();
        int seqNo = activeEditor.getSequenceNumber();
        this.setBorderNumber(seqNo);
    }
}

