/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.Land;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LandsModel
implements TreeModel {
    private static final String LANDS_DEF = "resources/land.properties";
    private static final String KEY_PREFIX = "land.order.";
    private static final String ROOT = "ROOT";
    private static final int SECTION_INTERVAL = 100;
    private final List<Land> landList = new LinkedList<Land>();
    private final List<Land> unmodList = Collections.unmodifiableList(this.landList);
    private final Map<Land, List<VillageSection>> sectionMap = new HashMap<Land, List<VillageSection>>();
    private boolean isLandListLoaded = false;
    private final EventListenerList listeners = new EventListenerList();
    private boolean ascending = false;

    public void loadVillageList(Land land) throws IOException {
        land.updateVillageList();
        List sectionList = VillageSection.getSectionList(land, 100);
        this.sectionMap.put(land, sectionList);
        int[] childIndices = new int[sectionList.size()];
        for (int ct = 0; ct < childIndices.length; ++ct) {
            childIndices[ct] = ct;
        }
        Object[] children = sectionList.toArray();
        Object[] path = new Object[]{ROOT, land};
        TreePath treePath = new TreePath(path);
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath, childIndices, children);
        this.fireTreeStructureChanged(event);
    }

    public void loadLandList() throws IOException {
        if (this.isLandListLoaded) {
            return;
        }
        InputStream is = Jindolf.getResourceAsStream(LANDS_DEF);
        this.loadLandList(is);
    }

    public void loadLandList(InputStream is) throws IOException {
        if (this.isLandListLoaded) {
            return;
        }
        Properties properties = new Properties();
        properties.load(is);
        is.close();
        this.loadLandList(properties);
    }

    public void loadLandList(Properties properties) {
        String key;
        if (this.isLandListLoaded) {
            return;
        }
        String codeCheck = properties.getProperty("codeCheck");
        if (codeCheck == null || codeCheck.length() != 1 || codeCheck.charAt(0) != '\u72fc') {
            Jindolf.logger.severe("\u56fd\u5b9a\u7fa9\u4e00\u89a7\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u304c\u304a\u304b\u3057\u3044\u3088\u3046\u3067\u3059\u3002native2ascii \u306f\u6b63\u3057\u304f\u9069\u7528\u3057\u307e\u3057\u305f\u304b\uff1f");
            Jindolf.exit(1);
            return;
        }
        Set<Object> keySet = properties.keySet();
        TreeSet<Integer> orderSet = new TreeSet<Integer>();
        for (Object keyObj : keySet) {
            Integer order;
            if (keyObj == null || !(key = keyObj.toString()).startsWith(KEY_PREFIX)) continue;
            key = key.replace(KEY_PREFIX, "");
            try {
                order = new Integer(key);
            }
            catch (NumberFormatException e) {
                continue;
            }
            orderSet.add(order);
        }
        this.landList.clear();
        for (Integer order : orderSet) {
            String landId;
            if (order == null || (landId = properties.getProperty(key = KEY_PREFIX + order.toString())) == null || landId.length() <= 0) continue;
            Land land = new Land(landId, properties);
            this.landList.add(land);
        }
        this.isLandListLoaded = true;
        this.fireLandListChanged();
    }

    private void fireLandListChanged() {
        int size = this.landList.size();
        int[] childIndices = new int[size];
        for (int ct = 0; ct < size; ++ct) {
            int index;
            childIndices[ct] = index = ct;
        }
        Object[] children = this.landList.toArray();
        TreePath treePath = new TreePath(ROOT);
        TreeModelEvent event = new TreeModelEvent((Object)this, treePath, childIndices, children);
        this.fireTreeStructureChanged(event);
    }

    public void setAscending(boolean ascending) {
        if (this.ascending == ascending) {
            return;
        }
        this.ascending = ascending;
        this.fireLandListChanged();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }

    private TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
    }

    protected void fireTreeStructureChanged(TreeModelEvent event) {
        for (TreeModelListener listener : this.getTreeModelListeners()) {
            listener.treeStructureChanged(event);
        }
    }

    public List<Land> getLandList() {
        return this.unmodList;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.getChildCount(parent)) {
            return null;
        }
        if (parent == ROOT) {
            List<Land> list = this.getLandList();
            if (!this.ascending) {
                index = list.size() - index - 1;
            }
            Land land = list.get(index);
            return land;
        }
        if (parent instanceof Land) {
            Land land = (Land)parent;
            List<VillageSection> sectionList = this.sectionMap.get(land);
            if (!this.ascending) {
                index = sectionList.size() - index - 1;
            }
            VillageSection section = sectionList.get(index);
            return section;
        }
        if (parent instanceof VillageSection) {
            VillageSection section = (VillageSection)parent;
            if (!this.ascending) {
                index = section.getVillageCount() - index - 1;
            }
            Village village = section.getVillage(index);
            return village;
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == ROOT) {
            return this.getLandList().size();
        }
        if (parent instanceof Land) {
            Land land = (Land)parent;
            List<VillageSection> sectionList = this.sectionMap.get(land);
            if (sectionList == null) {
                return 0;
            }
            return sectionList.size();
        }
        if (parent instanceof VillageSection) {
            VillageSection section = (VillageSection)parent;
            return section.getVillageCount();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (child == null) {
            return -1;
        }
        if (parent == ROOT) {
            List<Land> list = this.getLandList();
            int index = list.indexOf(child);
            if (!this.ascending) {
                index = list.size() - index - 1;
            }
            return index;
        }
        if (parent instanceof Land) {
            Land land = (Land)parent;
            List<VillageSection> sectionList = this.sectionMap.get(land);
            int index = sectionList.indexOf(child);
            if (!this.ascending) {
                index = sectionList.size() - index - 1;
            }
            return index;
        }
        if (parent instanceof VillageSection) {
            VillageSection section = (VillageSection)parent;
            int index = section.getIndexOfVillage(child);
            if (!this.ascending) {
                index = section.getVillageCount() - index - 1;
            }
            return index;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return ROOT;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == ROOT) {
            return false;
        }
        if (node instanceof Land) {
            return false;
        }
        if (node instanceof VillageSection) {
            return false;
        }
        if (node instanceof Village) {
            return true;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VillageSection {
        private final int startID;
        private final int endID;
        private final String prefix;
        private final List<Village> villageList = new LinkedList<Village>();

        private static List<VillageSection> getSectionList(Land land, int interval) throws IllegalArgumentException {
            int fixedStart;
            if (interval <= 0) {
                throw new IllegalArgumentException();
            }
            List<Village> villageList = land.getVillageList();
            Village village1st = villageList.get(0);
            Village villageLast = villageList.get(villageList.size() - 1);
            int startID = village1st.getVillageIDNum();
            int endID = villageLast.getVillageIDNum();
            LinkedList<VillageSection> result = new LinkedList<VillageSection>();
            for (int ct = fixedStart = startID / interval * interval; ct <= endID; ct += interval) {
                VillageSection section = new VillageSection(land, ct, ct + interval - 1);
                result.add(section);
            }
            return Collections.unmodifiableList(result);
        }

        private VillageSection(Land land, int startID, int endID) throws IndexOutOfBoundsException {
            if (startID < 0 || startID > endID) {
                throw new IndexOutOfBoundsException();
            }
            this.startID = startID;
            this.endID = endID;
            this.prefix = land.getLandPrefix();
            for (Village village : land.getVillageList()) {
                int id = village.getVillageIDNum();
                if (startID > id || id > endID) continue;
                this.villageList.add(village);
            }
        }

        private int getVillageCount() {
            return this.villageList.size();
        }

        private Village getVillage(int index) {
            return this.villageList.get(index);
        }

        private int getIndexOfVillage(Object child) {
            return this.villageList.indexOf(child);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.prefix).append(this.startID);
            result.append(" \uff5e ");
            result.append(this.prefix).append(this.endID);
            return result.toString();
        }
    }
}

