/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexPattern {
    private static final String REGEX_DELIM = "[\\s\u3000]+";
    private final String editSource;
    private final boolean isRegex;
    private final Pattern pattern;
    private final String comment;

    public RegexPattern(String editSource, boolean isRegex, int flag, String comment) throws PatternSyntaxException {
        String regexExpr;
        this.isRegex = isRegex;
        this.comment = comment;
        if (this.isRegex) {
            regexExpr = this.editSource = editSource;
        } else {
            String[] tokens;
            String newSource = "";
            regexExpr = "";
            for (String token : tokens = editSource.split(REGEX_DELIM)) {
                if (token == null || token.length() <= 0) continue;
                newSource = newSource.length() <= 0 ? token : newSource + " " + token;
                String quoted = "(?:" + Pattern.quote(token) + ")";
                regexExpr = regexExpr.length() <= 0 ? quoted : regexExpr + "|" + quoted;
            }
            this.editSource = newSource;
        }
        this.pattern = Pattern.compile(regexExpr, flag);
    }

    public RegexPattern(String editSource, boolean isRegex, int flag) throws PatternSyntaxException {
        this(editSource, isRegex, flag, " ");
    }

    public String getEditSource() {
        return this.editSource;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isRegex() {
        return this.isRegex;
    }

    public int getRegexFlag() {
        return this.pattern.flags();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.editSource;
    }

    public boolean equals(Object obj) {
        String otherPattern;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPattern)) {
            return false;
        }
        RegexPattern other = (RegexPattern)obj;
        String thisPattern = this.pattern.pattern();
        if (!thisPattern.equals(otherPattern = other.pattern.pattern())) {
            return false;
        }
        return this.pattern.flags() == other.pattern.flags();
    }

    public int hashCode() {
        int hash = this.pattern.pattern().hashCode();
        return hash ^= this.pattern.flags();
    }
}

