/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Topic;

public class Talk
implements Topic {
    private final Period homePeriod;
    private final Type talkType;
    private final Avatar avatar;
    private final String messageID;
    private final int hour;
    private final int minute;
    private final String dialog;
    private final int charNum;
    private int count = -1;

    public Talk(Period homePeriod, Type talkType, Avatar avatar, String messageID, int hour, int minute, String dialog) {
        if (homePeriod == null || talkType == null || avatar == null || messageID == null || dialog == null) {
            throw new NullPointerException();
        }
        if (hour < 0 || 23 < hour) {
            throw new IllegalArgumentException();
        }
        if (minute < 0 || 59 < minute) {
            throw new IllegalArgumentException();
        }
        this.homePeriod = homePeriod;
        this.talkType = talkType;
        this.avatar = avatar;
        this.messageID = messageID;
        this.hour = hour;
        this.minute = minute;
        this.dialog = dialog.replace("<br />", "\n").replace("&gt;", ">").replace("&lt;", "<").replace("&nbsp;", " ").replace("&quot;", "\"").replace("&amp;", "&");
        this.charNum = this.dialog.length();
    }

    public Period getPeriod() {
        return this.homePeriod;
    }

    public Type getTalkType() {
        return this.talkType;
    }

    public int getTalkCount() {
        return this.count;
    }

    public int getTotalChars() {
        return this.charNum;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public long getTimeFromID() {
        String epoch = this.messageID.replace("mes", "");
        long result = Long.parseLong(epoch) * 1000L;
        return result;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public String getDialog() {
        return this.dialog;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getAnchorNotation() {
        int day = this.homePeriod.getDay();
        String hstr = "0" + this.hour;
        hstr = hstr.substring(hstr.length() - 2);
        String mstr = "0" + this.minute;
        mstr = mstr.substring(mstr.length() - 2);
        return String.valueOf(day) + "d" + hstr + ":" + mstr;
    }

    public static Type decodeType(String encoded) {
        Type type;
        if (encoded.equals("say")) {
            type = Type.PUBLIC;
        } else if (encoded.equals("think")) {
            type = Type.PRIVATE;
        } else if (encoded.equals("whisper")) {
            type = Type.WOLFONLY;
        } else if (encoded.equals("groan")) {
            type = Type.GRAVE;
        } else {
            return null;
        }
        return type;
    }

    public static String encodeColorName(Type type) {
        String result;
        switch (type) {
            case PUBLIC: {
                result = "\u767d";
                break;
            }
            case PRIVATE: {
                result = "\u7070";
                break;
            }
            case WOLFONLY: {
                result = "\u8d64";
                break;
            }
            case GRAVE: {
                result = "\u9752";
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.avatar.getFullName());
        if (this.talkType == Type.PUBLIC) {
            result.append(" says ");
        } else if (this.talkType == Type.PRIVATE) {
            result.append(" think ");
        } else if (this.talkType == Type.WOLFONLY) {
            result.append(" howl ");
        } else if (this.talkType == Type.GRAVE) {
            result.append(" groan ");
        }
        result.append(this.dialog);
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PUBLIC,
        WOLFONLY,
        PRIVATE,
        GRAVE;

    }
}

