/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class UriExporter
implements Transferable {
    private static final String[] mimes = new String[]{"text/uri-list", "text/plain"};
    private static final List<DataFlavor> uriFlavors = new ArrayList<DataFlavor>(mimes.length);
    private URI uri;

    public UriExporter(URI uri) {
        this.uri = uri;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] result = new DataFlavor[uriFlavors.size()];
        int index = 0;
        for (DataFlavor dataFlavor : uriFlavors) {
            try {
                result[index++] = (DataFlavor)dataFlavor.clone();
            }
            catch (CloneNotSupportedException e) {
                assert (false);
                return null;
            }
        }
        return result;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor dataFlavor : uriFlavors) {
            if (!dataFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        String result = this.uri.toASCIIString();
        return result;
    }

    static {
        String stringClassName = "class=" + String.class.getName();
        for (String mime : mimes) {
            DataFlavor dataFlavor;
            mime = mime + "; " + stringClassName;
            try {
                dataFlavor = new DataFlavor(mime);
            }
            catch (ClassNotFoundException e) {
                assert (false);
                throw new ExceptionInInitializerError(e);
            }
            uriFlavors.add(dataFlavor);
        }
    }
}

