/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebIPC {
    private static final Class desktopKlass = WebIPC.getClass("java.awt.Desktop");
    private static final Method isDesktopSupportedMethod;
    private static final Method getDesktopMethod;
    private static final Method isSupportedMethod;
    private static final Method browseMethod;
    private static final Class desktopActionKlass;
    private static final Enum browserEnum;
    private final Object desktop;

    private static Class getClass(String klassName) {
        Class<?> result;
        try {
            result = Class.forName(klassName);
        }
        catch (ClassNotFoundException e) {
            result = null;
        }
        return result;
    }

    private static Class getInnerClass(Class parent, String canonical) {
        Class<?>[] innerKlasses;
        if (parent == null) {
            return null;
        }
        Class<?> result = null;
        for (Class<?> klass : innerKlasses = parent.getClasses()) {
            if (!klass.getCanonicalName().equals(canonical)) continue;
            result = klass;
            break;
        }
        return result;
    }

    private static Method getMethod(String methodName, Class<?> ... paramTypes) {
        Method result;
        if (desktopKlass == null) {
            return null;
        }
        try {
            result = desktopKlass.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            result = null;
        }
        return result;
    }

    private static Enum getEnumMember(Class parent, String memberName) {
        Object value;
        Field field;
        if (parent == null) {
            return null;
        }
        try {
            field = parent.getField(memberName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        try {
            value = field.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (!(value instanceof Enum)) {
            return null;
        }
        return (Enum)value;
    }

    public static boolean isDesktopSupported() {
        Object invokeResult;
        if (isDesktopSupportedMethod == null) {
            return false;
        }
        try {
            invokeResult = isDesktopSupportedMethod.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            assert (false);
            return false;
        }
        catch (IllegalArgumentException e) {
            assert (false);
            return false;
        }
        catch (NullPointerException e) {
            assert (false);
            return false;
        }
        if (!(invokeResult instanceof Boolean)) {
            assert (false);
            return false;
        }
        boolean result = (Boolean)invokeResult;
        return result;
    }

    public static WebIPC getWebIPC() throws HeadlessException, UnsupportedOperationException {
        WebIPC webIPC;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (!WebIPC.isDesktopSupported()) {
            throw new UnsupportedOperationException();
        }
        try {
            webIPC = new WebIPC();
        }
        catch (HeadlessException e) {
            throw e;
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException(e);
        }
        return webIPC;
    }

    private WebIPC() throws Throwable {
        try {
            this.desktop = getDesktopMethod.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw targetException;
        }
        catch (IllegalAccessException e) {
            assert (false);
            throw e;
        }
        catch (IllegalArgumentException e) {
            assert (false);
            throw e;
        }
        catch (NullPointerException e) {
            assert (false);
            throw e;
        }
    }

    public void browse(URI uri) throws NullPointerException, UnsupportedOperationException, IOException, SecurityException, IllegalArgumentException {
        if (uri == null) {
            throw new NullPointerException();
        }
        if (!this.isSupported(Action.BROWSE)) {
            throw new UnsupportedOperationException();
        }
        try {
            browseMethod.invoke(this.desktop, uri);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof IOException) {
                throw (IOException)targetException;
            }
            if (targetException instanceof SecurityException) {
                throw (SecurityException)targetException;
            }
            if (targetException instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)targetException;
            }
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
        }
        catch (IllegalAccessException e) {
            assert (false);
            throw new UnsupportedOperationException();
        }
        catch (IllegalArgumentException e) {
            assert (false);
            throw new UnsupportedOperationException();
        }
        catch (NullPointerException e) {
            assert (false);
            throw new UnsupportedOperationException();
        }
    }

    public boolean isSupported(Action action) {
        if (Action.BROWSE.equals((Object)action)) {
            Object invokeResult = null;
            try {
                invokeResult = isSupportedMethod.invoke(this.desktop, browserEnum);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                if (targetException instanceof Error) {
                    throw (Error)targetException;
                }
                return false;
            }
            catch (IllegalAccessException e) {
                assert (false);
                return false;
            }
            catch (IllegalArgumentException e) {
                assert (false);
                return false;
            }
            catch (NullPointerException e) {
                assert (false);
                return false;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                return false;
            }
            if (!(invokeResult instanceof Boolean)) {
                assert (false);
                return false;
            }
            boolean result = (Boolean)invokeResult;
            return result;
        }
        return false;
    }

    static {
        desktopActionKlass = WebIPC.getInnerClass(desktopKlass, "java.awt.Desktop.Action");
        isDesktopSupportedMethod = WebIPC.getMethod("isDesktopSupported", new Class[0]);
        getDesktopMethod = WebIPC.getMethod("getDesktop", new Class[0]);
        isSupportedMethod = WebIPC.getMethod("isSupported", desktopActionKlass);
        browseMethod = WebIPC.getMethod("browse", URI.class);
        browserEnum = WebIPC.getEnumMember(desktopActionKlass, "BROWSE");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        BROWSE;

    }
}

