/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import jp.sourceforge.jindolf.ClipboardAction;
import jp.sourceforge.jindolf.GUIUtils;
import jp.sourceforge.jindolf.Jindolf;
import jp.sourceforge.jindolf.TextPopup;
import jp.sourceforge.jindolf.UriExporter;
import jp.sourceforge.jindolf.WebIPC;

public class WebIPCDialog
extends JDialog
implements ActionListener {
    private static final String FRAMETITLE = "URL\u3078\u306e\u30a2\u30af\u30bb\u30b9\u78ba\u8a8d - " + Jindolf.TITLE;
    private final JLabel info = new JLabel("\u4ee5\u4e0b\u306eURL\u3078\u306e\u30a2\u30af\u30bb\u30b9\u304c\u6307\u793a\u3055\u308c\u307e\u3057\u305f\u3002");
    private final JTextArea urltext = new JTextArea("");
    private final JButton browse = new JButton("\u30c7\u30d5\u30a9\u30eb\u30c8\u306eWeb\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a");
    private final JButton clipcopy = new JButton("URL\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc");
    private final JLabel dndLabel = new JLabel("\u2026\u307e\u305f\u306f\u30d6\u30e9\u30a6\u30b6\u306bDrag&Drop \u2192");
    private final JButton cancel = new JButton("\u9589\u3058\u308b");
    private final WebIPC ipc;
    private URI uri;

    public static void showDialog(Frame owner, String url) {
        WebIPCDialog dialog = new WebIPCDialog(owner);
        dialog.setURLtext(url);
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
    }

    private static boolean isValidURI(URI uri) {
        if (uri == null) {
            return false;
        }
        if (!uri.isAbsolute()) {
            return false;
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            return false;
        }
        if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            return false;
        }
        String host = uri.getHost();
        return host != null;
    }

    public WebIPCDialog(Frame owner) {
        super(owner, FRAMETITLE, true);
        GUIUtils.modifyWindowAttributes(this, true, false, true);
        WebIPC webipc = null;
        if (WebIPC.isDesktopSupported() && !(webipc = WebIPC.getWebIPC()).isSupported(WebIPC.Action.BROWSE)) {
            webipc = null;
        }
        this.ipc = webipc;
        Border inside = BorderFactory.createEmptyBorder(1, 4, 1, 4);
        Border outside = BorderFactory.createEtchedBorder(0);
        CompoundBorder border = BorderFactory.createCompoundBorder(outside, inside);
        this.urltext.setBorder(border);
        this.urltext.setEditable(false);
        this.urltext.setLineWrap(true);
        this.urltext.setComponentPopupMenu(new TextPopup());
        GUIUtils.forceMonoPitchFont(this.urltext);
        this.dndLabel.setIcon(GUIUtils.getWWWIcon());
        this.dndLabel.setHorizontalTextPosition(2);
        this.dndLabel.setTransferHandler(new DnDHandler());
        this.dndLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                JComponent comp = (JComponent)event.getSource();
                TransferHandler handler = comp.getTransferHandler();
                handler.exportAsDrag(comp, event, 1);
            }
        });
        Container container = this.getContentPane();
        this.design(container);
        this.browse.addActionListener(this);
        this.clipcopy.addActionListener(this);
        this.cancel.addActionListener(this);
        this.getRootPane().setDefaultButton(this.browse);
        this.browse.requestFocusInWindow();
        if (this.ipc == null) {
            this.browse.setEnabled(false);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                WebIPCDialog.this.actionCancel();
            }
        });
    }

    private void design(Container container) {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        container.setLayout(layout);
        JComponent buttonPanel = this.buildButtonPanel();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.insets = new Insets(5, 5, 5, 5);
        container.add((Component)this.info, constraints);
        container.add((Component)this.urltext, constraints);
        container.add((Component)buttonPanel, constraints);
        container.add((Component)this.cancel, constraints);
    }

    private JComponent buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder("\u30a2\u30af\u30bb\u30b9\u3059\u308b\u65b9\u6cd5\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        buttonPanel.setBorder(border);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        buttonPanel.setLayout(layout);
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.insets = new Insets(3, 3, 3, 3);
        buttonPanel.add((Component)this.browse, constraints);
        buttonPanel.add((Component)this.clipcopy, constraints);
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(10, 3, 10, 3);
        buttonPanel.add((Component)this.dndLabel, constraints);
        return buttonPanel;
    }

    public void setURLtext(String url) {
        URI uriarg = null;
        try {
            uriarg = new URI(url);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        this.uri = uriarg;
        if (this.uri == null) {
            return;
        }
        if (!WebIPCDialog.isValidURI(this.uri)) {
            return;
        }
        String uriText = this.uri.toASCIIString();
        this.urltext.setText(uriText);
        this.urltext.revalidate();
        this.pack();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.browse) {
            this.actionBrowse();
        } else if (source == this.clipcopy) {
            this.actionClipboardCopy();
        } else if (source == this.cancel) {
            this.actionCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionBrowse() {
        if (this.uri == null) {
            this.close();
            return;
        }
        try {
            try {
                this.ipc.browse(this.uri);
            }
            catch (NullPointerException e) {
                assert (false);
            }
            catch (UnsupportedOperationException e) {
            }
            catch (IOException e) {
            }
            catch (SecurityException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            String logmsg = "URL " + this.uri.toASCIIString() + " \u3078\u306e\u30a2\u30af\u30bb\u30b9\u3092Web\u30d6\u30e9\u30a6\u30b6\u306b\u6307\u793a\u3057\u307e\u3057\u305f";
            Jindolf.logger.info(logmsg);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionClipboardCopy() {
        if (this.uri == null) {
            this.close();
            return;
        }
        String uristring = this.uri.toASCIIString();
        try {
            ClipboardAction.copyToClipBoard(uristring);
            String logmsg = "\u6587\u5b57\u5217\u300c" + uristring + "\u300d\u3092\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3057\u305f";
            Jindolf.logger.info(logmsg);
        }
        finally {
            this.close();
        }
    }

    private void actionCancel() {
        this.close();
    }

    private void close() {
        this.setVisible(false);
    }

    private class DnDHandler
    extends TransferHandler {
        public int getSourceActions(JComponent comp) {
            return 1;
        }

        protected Transferable createTransferable(JComponent comp) {
            UriExporter result = new UriExporter(WebIPCDialog.this.uri);
            return result;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 0) {
                return;
            }
            String logmsg = "URL " + WebIPCDialog.this.uri.toASCIIString() + " \u304c\u3069\u3053\u304b\u3078\u30c9\u30e9\u30c3\u30b0&\u30c9\u30ed\u30c3\u30d7\u3055\u308c\u307e\u3057\u305f";
            Jindolf.logger.info(logmsg);
            WebIPCDialog.this.close();
        }

        public Icon getVisualRepresentation(Transferable tx) {
            return GUIUtils.getWWWIcon();
        }
    }
}

