/*
 * InputStream with byte-counter
 *
 * Copyright(c) 2009 olyutorskii
 * $Id: CountInputStream.java 339 2009-01-15 14:21:10Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.io.IOException;
import java.io.InputStream;

/**
 * 読み込みバイト数を記録するInputStream
 */
public class CountInputStream extends InputStream{

    private final InputStream in;
    private long counter;

    /**
     * コンストラクタ
     * @param in 委譲先InputStream
     */
    public CountInputStream(InputStream in){
        this.in = in;
        this.counter = 0;
        return;
    }

    /**
     * 読み込みバイト数を返す。
     * @return 読み込みバイト数。
     */
    public long getCount(){
        return this.counter;
    }

    /**
     * {@inheritDoc}
     *
     * @return {@inheritDoc}
     * @throws java.io.IOException {@inheritDoc}
     */
    @Override
    public int available() throws IOException{
        int bytes = this.in.available();
        return bytes;
    }

    /**
     * {@inheritDoc}
     *
     * @throws java.io.IOException {@inheritDoc}
     */
    @Override
    public void close() throws IOException{
        this.in.close();
        return;
    }

    /**
     * {@inheritDoc}
     *
     * @param readlimit {@inheritDoc}
     */
    @Override
    public void mark(int readlimit){
        this.in.mark(readlimit);
        return;
    }

    /**
     * {@inheritDoc}
     *
     * @return {@inheritDoc}
     */
    @Override
    public boolean markSupported(){
        return this.in.markSupported();
    }

    /**
     * {@inheritDoc}
     *
     * @return {@inheritDoc}
     * @throws java.io.IOException {@inheritDoc}
     */
    public int read() throws IOException{
        int byteData = this.in.read();
        this.counter++;
        return byteData;
    }

    /**
     * {@inheritDoc}
     *
     * @param buf {@inheritDoc}
     * @return {@inheritDoc}
     * @throws java.io.IOException {@inheritDoc}
     */
    @Override
    public int read(byte[] buf) throws IOException{
        int count = this.in.read(buf);
        this.counter += count;
        return count;
    }

    /**
     * {@inheritDoc}
     *
     * @param buf {@inheritDoc}
     * @param off {@inheritDoc}
     * @param len {@inheritDoc}
     * @return {@inheritDoc}
     * @throws java.io.IOException {@inheritDoc}
     */
    @Override
    public int read(byte[] buf, int off, int len) throws IOException{
        int count = this.in.read(buf, off, len);
        this.counter += count;
        return count;
    }

    /**
     * {@inheritDoc}
     *
     * @throws java.io.IOException {@inheritDoc}
     */
    @Override
    public void reset() throws IOException{
        this.in.reset();
        return;
    }

    /**
     * {@inheritDoc}
     *
     * @param n {@inheritDoc}
     * @return {@inheritDoc}
     * @throws java.io.IOException {@inheritDoc}
     */
    @Override
    public long skip(long n) throws IOException{
        long skipped = this.in.skip(n);
        this.counter += skipped;
        return skipped;
    }
}
