/*
 * 文字列ユーティリティ
 *
 * Copyright(c) 2008 olyutorskii
 * $Id: StringUtils.java 324 2008-12-06 16:18:06Z olyutorskii $
 */

package jp.sourceforge.jindolf;

import java.util.regex.Matcher;

/**
 * 文字列ユーティリティクラス
 */
public class StringUtils{

    /**
     * 正規表現にマッチした領域を数値化する
     * @param seq 文字列
     * @param matcher Matcher
     * @param groupIndex 前方指定グループ番号
     * @return 数値
     */
    public static int parseInt(CharSequence seq,
                                Matcher matcher,
                                int groupIndex     ){
        return parseInt(seq,
                        matcher.start(groupIndex),
                        matcher.end(groupIndex)   );
    }

    /**
     * 文字列を数値化する
     * @param seq 文字列
     * @return 数値
     */
    public static int parseInt(CharSequence seq){
        return parseInt(seq, 0, seq.length());
    }

    /**
     * 部分文字列を数値化する。
     * @param seq 文字列
     * @param startPos 範囲開始位置
     * @param endPos 範囲終了位置
     * @return パースした数値
     */
    public static int parseInt(CharSequence seq, int startPos, int endPos){
        int result = 0;

        for(int pos=startPos; pos<endPos; pos++){
            char ch = seq.charAt(pos);
            int digit = Character.digit(ch, 10);
            if(digit < 0) break;
            result *= 10;
            result += digit;
        }

        return result;
    }

    /**
     * 長い文字列を三点リーダで省略する。
     * 「abcdefg」→「abc…efg」
     * @param str 文字列
     * @return 省略した文字列
     */
    public static CharSequence suppressString(CharSequence str){
        final int SUPLEN = 5;
        String result = str.toString();
        result = result.replaceAll("[\u0020\\t\\n\\r\u3000]", "");
        if(result.length() <= SUPLEN *2) return result;
        int len = result.length();
        String head = result.substring(0, SUPLEN);
        String tail = result.substring(len-SUPLEN, len);
        result = head + "…" + tail;
        return result;
    }

    /**
     * ダミーコンストラクタ
     */
    private StringUtils(){
        super();
        assert false;
        throw new Error();
    }

    // TODO 文字エンコーダ・デコーダ処理の一本化。
    // TODO 文字エンコーダ・デコーダのカスタム化。「～」対策など。
}
