/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.jindolf.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Anchor {
    private static final int EPILOGUEDAY = 99;
    private static final Pattern anchorRegex;
    private final CharSequence source;
    private final int startPos;
    private final int endPos;
    private final int day;
    private final int hour;
    private final int minute;

    public static Anchor getAnchor(CharSequence charSequence, int n, int n2, int n3) {
        Matcher matcher = anchorRegex.matcher(charSequence);
        matcher.region(n, n2);
        if (!matcher.find()) {
            return null;
        }
        Anchor anchor = Anchor.getAnchorFromMatched(charSequence, matcher, n3);
        return anchor;
    }

    public static List<Anchor> getAnchorList(CharSequence charSequence, int n) {
        LinkedList<Anchor> linkedList = new LinkedList<Anchor>();
        Matcher matcher = anchorRegex.matcher(charSequence);
        int n2 = charSequence.length();
        while (matcher.find()) {
            Anchor anchor = Anchor.getAnchorFromMatched(charSequence, matcher, n);
            linkedList.add(anchor);
            int n3 = matcher.end();
            matcher.region(n3, n2);
        }
        return linkedList;
    }

    private static Anchor getAnchorFromMatched(CharSequence charSequence, Matcher matcher, int n) {
        int n2;
        int n3;
        int n4 = matcher.start();
        int n5 = matcher.end();
        int n6 = n;
        if (matcher.start(1) < matcher.end(1)) {
            if (matcher.start(2) < matcher.end(2)) {
                n6 = 0;
            } else if (matcher.start(3) < matcher.end(3)) {
                n6 = 99;
            } else if (matcher.start(4) < matcher.end(4)) {
                n6 = StringUtils.parseInt(charSequence, matcher, 4);
            } else {
                assert (false);
                return null;
            }
        }
        boolean bl = false;
        if (matcher.start(5) < matcher.end(5)) {
            if (matcher.start(6) < matcher.end(6)) {
                bl = false;
            } else if (matcher.start(7) < matcher.end(7)) {
                bl = true;
            } else {
                assert (false);
                return null;
            }
        }
        if (matcher.start(8) < matcher.end(8)) {
            n3 = 9;
            n2 = 10;
        } else if (matcher.start(11) < matcher.end(11)) {
            n3 = 12;
            n2 = 13;
        } else {
            assert (false);
            return null;
        }
        int n7 = StringUtils.parseInt(charSequence, matcher, n3);
        int n8 = StringUtils.parseInt(charSequence, matcher, n2);
        if (bl && n7 < 12) {
            n7 += 12;
        }
        Anchor anchor = new Anchor(charSequence, n4, n5, n6, n7 %= 24, n8);
        return anchor;
    }

    private Anchor(CharSequence charSequence, int n, int n2, int n3, int n4, int n5) {
        this.source = charSequence;
        this.startPos = n;
        this.endPos = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
    }

    public CharSequence getSource() {
        return this.source;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public boolean isEpilogueDay() {
        boolean bl = this.day >= 99;
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getDay()).append('d');
        int n = this.getHour();
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n).append(':');
        int n2 = this.getMinute();
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    static {
        String string = " \u3000\\t";
        String string2 = "[" + string + "]";
        String string3 = "(?:" + string2 + "|" + "(?:\\Q&nbsp;\\E)" + ")*?";
        String string4 = "((?:(\u30d7\u30ed(?:\u30ed\u30fc\u30b0)?)|(\u30a8\u30d4(?:\u30ed\u30fc\u30b0)?)|(?:([1-9\uff11-\uff19]?[0-9\uff10-\uff19])" + string3 + "(?:[dD\uff44\uff24]|(?:\u65e5\u76ee?))" + ")" + ")" + "[\\-\\[\\(/_\uff0d\u30fc\u2015\uff3b\uff3f]?" + string3 + ")?";
        String string5 = "((?:((?:[aA\uff41\uff21][\\.\uff0e]?[mM\uff4d\uff2d][\\.\uff0e]?)|(?:\u5348\u524d))|((?:[pP\uff50\uff30][\\.\uff0e]?[mM\uff4d\uff2d][\\.\uff0e]?)|(?:\u5348\u5f8c)))" + string3 + ")?";
        String string6 = "(?:(([0-2\uff10-\uff12]?[0-9\uff10-\uff19])" + string3 + "[:;\uff1a\uff1b]?" + string3 + "([0-5\uff10-\uff15][0-9\uff10-\uff19])" + ")" + "|" + "(" + "([0-2\uff10-\uff12]?[0-9\uff10-\uff19])" + string3 + "\u6642" + string3 + "([0-5\uff10-\uff15]?[0-9\uff10-\uff19])" + string3 + "\u5206" + ")" + ")";
        anchorRegex = Pattern.compile(string4 + string5 + string6, 32);
    }
}

