/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebIPC {
    private static final Class desktopKlass = WebIPC.getClass("java.awt.Desktop");
    private static final Method isDesktopSupportedMethod;
    private static final Method getDesktopMethod;
    private static final Method isSupportedMethod;
    private static final Method browseMethod;
    private static final Class desktopActionKlass;
    private static final Enum browserEnum;
    private final Object desktop;

    private static Class getClass(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        return clazz;
    }

    private static Class getInnerClass(Class clazz, String string) {
        Class<?>[] classArray;
        if (clazz == null) {
            return null;
        }
        Class<?> clazz2 = null;
        for (Class<?> clazz3 : classArray = clazz.getClasses()) {
            if (!clazz3.getCanonicalName().equals(string)) continue;
            clazz2 = clazz3;
            break;
        }
        return clazz2;
    }

    private static Method getMethod(String string, Class<?> ... classArray) {
        Method method;
        if (desktopKlass == null) {
            return null;
        }
        try {
            method = desktopKlass.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        return method;
    }

    private static Enum getEnumMember(Class clazz, String string) {
        Object object;
        Field field;
        if (clazz == null) {
            return null;
        }
        try {
            field = clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        try {
            object = field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        if (!(object instanceof Enum)) {
            return null;
        }
        return (Enum)object;
    }

    public static boolean isDesktopSupported() {
        Object object;
        if (isDesktopSupportedMethod == null) {
            return false;
        }
        try {
            object = isDesktopSupportedMethod.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            assert (false);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            assert (false);
            return false;
        }
        catch (NullPointerException nullPointerException) {
            assert (false);
            return false;
        }
        if (!(object instanceof Boolean)) {
            assert (false);
            return false;
        }
        boolean bl = (Boolean)object;
        return bl;
    }

    public static WebIPC getWebIPC() throws HeadlessException, UnsupportedOperationException {
        WebIPC webIPC;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (!WebIPC.isDesktopSupported()) {
            throw new UnsupportedOperationException();
        }
        try {
            webIPC = new WebIPC();
        }
        catch (HeadlessException headlessException) {
            throw headlessException;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw unsupportedOperationException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
        return webIPC;
    }

    private WebIPC() throws Throwable {
        try {
            this.desktop = getDesktopMethod.invoke(null, (Object[])null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw throwable;
        }
        catch (IllegalAccessException illegalAccessException) {
            assert (false);
            throw illegalAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            assert (false);
            throw illegalArgumentException;
        }
        catch (NullPointerException nullPointerException) {
            assert (false);
            throw nullPointerException;
        }
    }

    public void browse(URI uRI) throws NullPointerException, UnsupportedOperationException, IOException, SecurityException, IllegalArgumentException {
        if (uRI == null) {
            throw new NullPointerException();
        }
        if (!this.isSupported(Action.BROWSE)) {
            throw new UnsupportedOperationException();
        }
        try {
            browseMethod.invoke(this.desktop, uRI);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof SecurityException) {
                throw (SecurityException)throwable;
            }
            if (throwable instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            assert (false);
            throw new UnsupportedOperationException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            assert (false);
            throw new UnsupportedOperationException();
        }
        catch (NullPointerException nullPointerException) {
            assert (false);
            throw new UnsupportedOperationException();
        }
    }

    public boolean isSupported(Action action) {
        if (Action.BROWSE.equals((Object)action)) {
            Object object = null;
            try {
                object = isSupportedMethod.invoke(this.desktop, browserEnum);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false);
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                assert (false);
                return false;
            }
            catch (NullPointerException nullPointerException) {
                assert (false);
                return false;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                return false;
            }
            if (!(object instanceof Boolean)) {
                assert (false);
                return false;
            }
            boolean bl = (Boolean)object;
            return bl;
        }
        return false;
    }

    static {
        desktopActionKlass = WebIPC.getInnerClass(desktopKlass, "java.awt.Desktop.Action");
        isDesktopSupportedMethod = WebIPC.getMethod("isDesktopSupported", new Class[0]);
        getDesktopMethod = WebIPC.getMethod("getDesktop", new Class[0]);
        isSupportedMethod = WebIPC.getMethod("isSupported", desktopActionKlass);
        browseMethod = WebIPC.getMethod("browse", URI.class);
        browserEnum = WebIPC.getEnumMember(desktopActionKlass, "BROWSE");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        BROWSE;

    }
}

