/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class ClipboardAction
extends TextAction {
    public static final String ACTION_CUT = "ACTION_CUT";
    public static final String ACTION_COPY = "ACTION_COPY";
    public static final String ACTION_PASTE = "ACTION_PASTE";
    public static final String ACTION_SELALL = "ACTION_SELALL";

    public static void copyToClipBoard(CharSequence charSequence) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        StringSelection stringSelection = new StringSelection(((Object)charSequence).toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    public static ClipboardAction cutAction() {
        return new ClipboardAction("\u9078\u629e\u7bc4\u56f2\u3092\u30ab\u30c3\u30c8", ACTION_CUT);
    }

    public static ClipboardAction copyAction() {
        return new ClipboardAction("\u9078\u629e\u7bc4\u56f2\u3092\u30b3\u30d4\u30fc", ACTION_COPY);
    }

    public static ClipboardAction pasteAction() {
        return new ClipboardAction("\u30da\u30fc\u30b9\u30c8", ACTION_PASTE);
    }

    public static ClipboardAction selectallAction() {
        return new ClipboardAction("\u3059\u3079\u3066\u9078\u629e", ACTION_SELALL);
    }

    protected ClipboardAction(String string, String string2) {
        super(string);
        this.setActionCommand(string2);
    }

    protected void setActionCommand(String string) {
        this.putValue("ActionCommandKey", string);
    }

    protected String getActionCommand() {
        Object object = this.getValue("ActionCommandKey");
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        if (jTextComponent == null) {
            return;
        }
        String string = this.getActionCommand();
        if (ACTION_CUT.equals(string)) {
            jTextComponent.cut();
        } else if (ACTION_COPY.equals(string)) {
            jTextComponent.copy();
        } else if (ACTION_PASTE.equals(string)) {
            jTextComponent.paste();
        } else if (ACTION_SELALL.equals(string)) {
            jTextComponent.selectAll();
        }
    }
}

