/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import jp.sourceforge.jindolf.Avatar;
import jp.sourceforge.jindolf.Period;
import jp.sourceforge.jindolf.Talk;
import jp.sourceforge.jindolf.Topic;
import jp.sourceforge.jindolf.TopicFilter;
import jp.sourceforge.jindolf.Village;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvExporter {
    private static final String[] encNames = new String[]{"UTF-8", "ISO-2022-JP", "ISO-2022-JP-2", "ISO-2022-JP-3", "ISO-2022-JP-2004", "EUC-JP", "x-euc-jp-linux", "x-eucJP-Open", "Shift_JIS", "windows-31j", "x-MS932_0213", "x-SJIS_0213", "x-PCK"};
    private static final String jpcheck = "[]09AZ\u3042\u3093\u30a2\u30f3\uff71\uff9d\u3090\u3091\u30f5\u30f6\u30f4\u30f0\u30f1\u30ee\u4e9c\u7464\u51dc\u7199\u58f7\u58fa\u5c2d\u582f\u5ce0\u3012\u254b";
    private static final String CSVEXT = ".csv";
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final String CRLF = "\r\n";
    private static final int BUFSIZ = 1024;
    private static final List<Charset> jpCharsets = CsvExporter.buildCharsetList();
    private static final JComboBox encodeBox = new JComboBox();
    private static final FileFilter csvFilter = new CsvFileFilter();
    private static final JFileChooser chooser = CsvExporter.buildChooser();

    private static boolean hasJPencoder(Charset charset) {
        if (!charset.canEncode()) {
            return false;
        }
        CharsetEncoder charsetEncoder = charset.newEncoder();
        try {
            if (charsetEncoder.canEncode(jpcheck)) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private static List<Charset> buildCharsetList() {
        LinkedList<Charset> linkedList = new LinkedList<Charset>();
        for (String string : encNames) {
            Charset charset;
            if (!Charset.isSupported(string) || linkedList.contains(charset = Charset.forName(string)) || !CsvExporter.hasJPencoder(charset)) continue;
            linkedList.add(charset);
        }
        Object object = Charset.defaultCharset();
        if (((Charset)object).name().equals("windows-31j") && Charset.isSupported("Shift_JIS")) {
            object = Charset.forName("Shift_JIS");
        }
        if (CsvExporter.hasJPencoder((Charset)object) || linkedList.size() <= 0) {
            if (linkedList.contains(object)) {
                linkedList.remove(object);
            }
            linkedList.add(0, (Charset)object);
        }
        return linkedList;
    }

    private static JFileChooser buildChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.setFileFilter(csvFilter);
        JComponent jComponent = CsvExporter.buildAccessory();
        jFileChooser.setAccessory(jComponent);
        return jFileChooser;
    }

    private static JComponent buildAccessory() {
        for (Charset object2 : jpCharsets) {
            encodeBox.addItem(object2);
        }
        TitledBorder titledBorder = BorderFactory.createTitledBorder("\u51fa\u529b\u30a8\u30f3\u30b3\u30fc\u30c9");
        encodeBox.setBorder(titledBorder);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)encodeBox, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    private static void writeError(File file) {
        Component component = null;
        String string = "\u30d5\u30a1\u30a4\u30eb\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc";
        String string2 = "\u30d5\u30a1\u30a4\u30eb\u300c" + file.toString() + "\u300d\n" + "\u306b\u66f8\u304d\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
        JOptionPane.showMessageDialog(component, string2, string, 0);
    }

    private static boolean confirmOverwrite(File file) {
        Component component = null;
        String string = "\u4e0a\u66f8\u304d\u78ba\u8a8d";
        String string2 = "\u65e2\u5b58\u306e\u30d5\u30a1\u30a4\u30eb\u300c" + file.toString() + "\u300d\n" + "\u3092\u4e0a\u66f8\u304d\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059\u3002\u7d9a\u3051\u307e\u3059\u304b\uff1f";
        int n = JOptionPane.showConfirmDialog(component, string2, string, 2, 2);
        return n == 0;
    }

    private static void setTitle(Period period) {
        Village village = period.getVillage();
        String string = village.getVillageName();
        String string2 = string + "\u6751 " + period.getCaption();
        string2 = string2 + "\u306e\u767a\u8a00\u3092CSV\u30d5\u30a1\u30a4\u30eb\u3078\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u3057\u307e\u3059";
        chooser.setDialogTitle(string2);
    }

    private static String createUniqueFileName(Period period) {
        String string;
        Village village = period.getVillage();
        String string2 = village.getVillageName();
        String string3 = "JIN_" + string2;
        switch (period.getType()) {
            case PROLOGUE: {
                string3 = string3 + "_Prologue";
                break;
            }
            case EPILOGUE: {
                string3 = string3 + "_Epilogue";
                break;
            }
            case PROGRESS: {
                string3 = string3 + "_Day";
                string3 = string3 + period.getDay();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        int n = 1;
        while (true) {
            string = string3;
            if (n > 1) {
                string = string + "(" + n + ")";
            }
            string = string + CSVEXT;
            File file = chooser.getCurrentDirectory();
            File file2 = new File(file, string);
            if (!file2.exists()) break;
            ++n;
        }
        return string;
    }

    private static void dumpPeriod(Appendable appendable, Period period, TopicFilter topicFilter) throws IOException {
        String string = "" + period.getDay();
        List<Topic> list = period.getTopicList();
        for (Topic topic : list) {
            Talk talk;
            if (!(topic instanceof Talk) || (talk = (Talk)topic).getTalkCount() <= 0 || topicFilter.isFiltered(talk)) continue;
            Avatar avatar = talk.getAvatar();
            String string2 = avatar.getName();
            int n = talk.getHour();
            int n2 = talk.getMinute();
            Talk.Type type = talk.getTalkType();
            CharSequence charSequence = talk.getDialog();
            appendable.append(string2).append(',');
            appendable.append(string).append(',');
            appendable.append(Character.forDigit(n / 10, 10));
            appendable.append(Character.forDigit(n % 10, 10));
            appendable.append(':');
            appendable.append(Character.forDigit(n2 / 10, 10));
            appendable.append(Character.forDigit(n2 % 10, 10));
            appendable.append(',');
            switch (type) {
                case PUBLIC: {
                    appendable.append("say");
                    break;
                }
                case PRIVATE: {
                    appendable.append("think");
                    break;
                }
                case WOLFONLY: {
                    appendable.append("whisper");
                    break;
                }
                case GRAVE: {
                    appendable.append("groan");
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            appendable.append(',');
            CsvExporter.escapeCSV(appendable, charSequence);
            appendable.append(CRLF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File exportPeriod(Period period, TopicFilter topicFilter) {
        OutputStream outputStream;
        boolean bl;
        FileFilter fileFilter;
        CsvExporter.setTitle(period);
        String string = CsvExporter.createUniqueFileName(period);
        File file = new File(string);
        chooser.setSelectedFile(file);
        int n = chooser.showSaveDialog(null);
        if (n != 0) {
            return null;
        }
        File file2 = chooser.getSelectedFile();
        if (!CsvExporter.hasExtent(file2.getName()) && (fileFilter = chooser.getFileFilter()) == csvFilter) {
            String string2 = file2.getPath();
            string2 = string2 + CSVEXT;
            file2 = new File(string2);
        }
        if (file2.exists()) {
            if (!file2.isFile() || !file2.canWrite()) {
                CsvExporter.writeError(file2);
                return null;
            }
            bl = CsvExporter.confirmOverwrite(file2);
            if (!bl) {
                return null;
            }
        } else {
            boolean bl2;
            try {
                bl = file2.createNewFile();
            }
            catch (IOException iOException) {
                CsvExporter.writeError(file2);
                return null;
            }
            if (!bl && !(bl2 = CsvExporter.confirmOverwrite(file2))) {
                return null;
            }
        }
        try {
            outputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            CsvExporter.writeError(file2);
            return null;
        }
        outputStream = new BufferedOutputStream(outputStream, 1024);
        Charset charset = (Charset)encodeBox.getSelectedItem();
        boolean bl3 = false;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset);
        try {
            CsvExporter.dumpPeriod(outputStreamWriter, period, topicFilter);
        }
        catch (IOException iOException) {
            bl3 = true;
        }
        finally {
            try {
                ((Writer)outputStreamWriter).close();
            }
            catch (IOException iOException) {
                bl3 = true;
            }
        }
        if (bl3) {
            CsvExporter.writeError(file2);
        }
        return file2;
    }

    public static Appendable escapeCSV(Appendable appendable, CharSequence charSequence) throws IOException {
        appendable.append('\"');
        int n = charSequence.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\"': {
                    appendable.append("\"\"");
                    continue block4;
                }
                case '\n': {
                    appendable.append(CRLF);
                    continue block4;
                }
                default: {
                    appendable.append(c);
                }
            }
        }
        appendable.append('\"');
        return appendable;
    }

    public static boolean hasExtent(CharSequence charSequence, CharSequence charSequence2) {
        int n = charSequence.length();
        int n2 = charSequence2.length();
        if (n2 < 2) {
            return false;
        }
        if (n <= n2) {
            return false;
        }
        if (charSequence.charAt(0) == '.') {
            return false;
        }
        int n3 = n - n2;
        assert (n3 > 0);
        for (int i = 0; i < n2; ++i) {
            char c = Character.toLowerCase(charSequence2.charAt(i));
            char c2 = Character.toLowerCase(charSequence.charAt(i + n3));
            if (c2 == c) continue;
            return false;
        }
        return true;
    }

    public static boolean hasExtent(CharSequence charSequence) {
        int n = charSequence.length();
        if (n < 3) {
            return false;
        }
        if (charSequence.charAt(0) == '.') {
            return false;
        }
        int n2 = n - 1;
        if (charSequence.charAt(n2) == '.') {
            return false;
        }
        for (int i = 1; i <= n2 - 1; ++i) {
            char c = charSequence.charAt(i);
            if (c != '.') continue;
            return true;
        }
        return false;
    }

    private CsvExporter() {
        assert (false);
        throw new Error();
    }

    private static class CsvFileFilter
    extends FileFilter {
        private CsvFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            if (!file.isFile()) {
                return false;
            }
            return CsvExporter.hasExtent(file.getName(), CsvExporter.CSVEXT);
        }

        public String getDescription() {
            return "CSV\u30d5\u30a1\u30a4\u30eb (*.csv)";
        }
    }
}

